/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.biopax.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cytoscape.biopax.internal.CyServices;
import org.cytoscape.biopax.internal.util.BioPaxReaderError;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;

public class CustomSifParser {
    private final CyNetwork network;
    private Map<Object, CyNode> nMap = new HashMap<Object, CyNode>();

    public CustomSifParser(CyNetwork network, CyServices serviceRegistrar) {
        this.network = network;
    }

    public void parse(String row) {
        String[] parts = row.split("\\t", -1);
        if (parts == null || parts.length < 6) {
            throw new BioPaxReaderError("Bad SIF entry: " + row);
        }
        CyNode source = this.createNode(parts[0]);
        String interactionType = parts[1];
        CyNode target = this.createNode(parts[2]);
        CyEdge edge = this.network.addEdge(source, target, true);
        this.network.getRow((CyIdentifiable)edge).set("interaction", (Object)interactionType);
        String edgeName = (String)this.network.getRow((CyIdentifiable)source).get("name", String.class) + " (" + interactionType + ") " + (String)this.network.getRow((CyIdentifiable)target).get("name", String.class);
        this.network.getRow((CyIdentifiable)edge).set("name", (Object)edgeName);
        if (edge != null) {
            this.addEdgeAttributes(edge, "datasource", parts[3]);
            this.addEdgeAttributes(edge, "publication", parts[4]);
            this.addEdgeAttributes(edge, "pathway", parts[5]);
        }
    }

    private CyNode createNode(String uri) {
        CyNode node = this.nMap.get(uri);
        if (node == null) {
            node = this.network.addNode();
            this.network.getRow((CyIdentifiable)node).set("name", (Object)uri);
            this.nMap.put(uri, this.network.getNode(node.getSUID().longValue()));
        }
        return node;
    }

    private void addEdgeAttributes(CyEdge element, String column, String entry) {
        CyTable table = this.network.getRow((CyIdentifiable)element).getTable();
        if (table.getColumn(column) == null) {
            table.createListColumn(column, String.class, false);
        }
        List<String> value = Arrays.asList(entry.split(";"));
        this.network.getRow((CyIdentifiable)element).set(column, value);
    }
}

