/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.biopax.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringEscapeUtils;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.Entity;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.pattern.miner.SIFEnum;
import org.biopax.paxtools.pattern.miner.SIFType;
import org.cytoscape.application.NetworkViewRenderer;
import org.cytoscape.biopax.internal.BioPaxMapper;
import org.cytoscape.biopax.internal.CustomSifParser;
import org.cytoscape.biopax.internal.CyServices;
import org.cytoscape.biopax.internal.util.AttributeUtil;
import org.cytoscape.biopax.internal.util.BioPaxReaderError;
import org.cytoscape.biopax.internal.util.VisualStyleUtil;
import org.cytoscape.io.read.CyNetworkReader;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewFactory;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.util.ListMultipleSelection;
import org.cytoscape.work.util.ListSingleSelection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BioPaxReaderTask
extends AbstractTask
implements CyNetworkReader {
    private static final Logger log = LoggerFactory.getLogger(BioPaxReaderTask.class);
    private static final String CREATE_NEW_COLLECTION = "A new network collection";
    private final HashMap<String, CyRootNetwork> nameToRootNetworkMap;
    private final VisualStyleUtil visualStyleUtil;
    private final CyServices cyServices;
    private InputStream stream;
    private String inputName;
    private final Collection<CyNetwork> networks = new HashSet<CyNetwork>();
    private CyRootNetwork rootNetwork;
    private CyNetworkReader anotherReader;
    @Tunable(description="Model Mapping:", groups={"Options"}, tooltip="<html>Choose how to read BioPAX:<ul><li><strong>Default</strong>: map states, interactions to nodes; properties - to edges, attributes;</li><li><strong>SIF</strong>: convert BioPAX to SIF network and attributes;</li><li><strong>SBGN</strong>: convert BioPAX to SBGN, find a SBGN reader, etc.</li></ul></html>", gravity=500.0, xorChildren=true)
    public ListSingleSelection<ReaderMode> readerMode;
    @Tunable(description="Network Collection:", groups={"Options", "Default"}, tooltip="Choose a Network Collection", dependsOn="readerMode=Default", gravity=701.0, xorKey="Default")
    public ListSingleSelection<String> rootNetworkSelection;
    @Tunable(description="Network View Renderer:", groups={"Options", "Default"}, gravity=702.0, xorKey="Default", dependsOn="readerMode=Default")
    public ListSingleSelection<NetworkViewRenderer> rendererList;
    @Tunable(description="Binary interactions to infer:", groups={"Options", "SIF"}, tooltip="Select inference patterns/rules to search/apply", gravity=703.0, xorKey="SIF", dependsOn="readerMode=SIF")
    public ListMultipleSelection<SIFType> sifSelection;
    @Tunable(description="SBGN Options:", groups={"Options", "SBGN"}, tooltip="Currently not available", gravity=704.0, xorKey="SBGN", dependsOn="readerMode=SBGN")
    public ListSingleSelection<String> sbgnSelection;

    @ProvidesTitle
    public String tunableDialogTitle() {
        return "BioPAX Reader Task";
    }

    public BioPaxReaderTask(InputStream stream, String inputName, CyServices cyServices, VisualStyleUtil visualStyleUtil) {
        this.stream = stream;
        this.inputName = inputName;
        this.cyServices = cyServices;
        this.visualStyleUtil = visualStyleUtil;
        this.nameToRootNetworkMap = new HashMap();
        for (CyNetwork net : cyServices.networkManager.getNetworkSet()) {
            CyRootNetwork rootNet = cyServices.rootNetworkManager.getRootNetwork(net);
            if (this.nameToRootNetworkMap.containsValue(rootNet)) continue;
            this.nameToRootNetworkMap.put((String)rootNet.getRow((CyIdentifiable)rootNet).get("name", String.class), rootNet);
        }
        ArrayList<String> rootNames = new ArrayList<String>();
        rootNames.add(CREATE_NEW_COLLECTION);
        rootNames.addAll(this.nameToRootNetworkMap.keySet());
        this.rootNetworkSelection = new ListSingleSelection(rootNames);
        this.rootNetworkSelection.setSelectedValue((Object)CREATE_NEW_COLLECTION);
        this.readerMode = new ListSingleSelection((Object[])ReaderMode.values());
        this.readerMode.setSelectedValue((Object)ReaderMode.DEFAULT);
        this.sifSelection = new ListMultipleSelection((Object[])SIFEnum.values());
        this.sifSelection.setSelectedValues(this.sifSelection.getPossibleValues());
        this.sbgnSelection = new ListSingleSelection((Object[])new String[0]);
        ArrayList renderers = new ArrayList();
        Set rendererSet = cyServices.applicationManager.getNetworkViewRendererSet();
        if (rendererSet.size() > 1) {
            renderers.addAll(rendererSet);
            Collections.sort(renderers, new Comparator<NetworkViewRenderer>(){

                @Override
                public int compare(NetworkViewRenderer r1, NetworkViewRenderer r2) {
                    return r1.toString().compareToIgnoreCase(r2.toString());
                }
            });
        }
        this.rendererList = new ListSingleSelection(renderers);
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        taskMonitor.setTitle("BioPAX reader");
        taskMonitor.setProgress(0.0);
        if (this.cancelled) {
            return;
        }
        Model model = null;
        try {
            model = BioPaxMapper.read(this.stream);
        }
        catch (Throwable e) {
            throw new BioPaxReaderError("BioPAX reader failed to build a BioPAX model (check the data for syntax errors) - " + e);
        }
        if (model == null) {
            throw new BioPaxReaderError("BioPAX reader did not find any BioPAX data there.");
        }
        final String networkName = this.getNetworkName(model);
        String msg = "Model " + networkName + " contains " + model.getObjects().size() + " BioPAX elements";
        log.info(msg);
        taskMonitor.setStatusMessage(msg);
        this.rootNetwork = this.nameToRootNetworkMap.get(this.rootNetworkSelection.getSelectedValue());
        BioPaxMapper mapper = new BioPaxMapper(model, this.cyServices.networkFactory);
        ReaderMode selectedMode = (ReaderMode)((Object)this.readerMode.getSelectedValue());
        switch (selectedMode) {
            case DEFAULT: {
                this.anotherReader = null;
                taskMonitor.setStatusMessage("Mapping BioPAX model to CyNetwork...");
                CyNetwork network = mapper.createCyNetwork(networkName, this.rootNetwork);
                if (network.getNodeCount() == 0) {
                    throw new BioPaxReaderError("Pathway is empty. Please check the BioPAX source file.");
                }
                AttributeUtil.set(network, (CyIdentifiable)network, "BIOPAX_NETWORK", "DEFAULT", String.class);
                this.networks.add(network);
                break;
            }
            case SIF: {
                taskMonitor.setStatusMessage("Mapping BioPAX model to SIF, then to CyNetwork (using the first discovered SIF reader)...");
                File tmpSifFile = File.createTempFile("tmp_biopax2sif", ".sif");
                tmpSifFile.deleteOnExit();
                BioPaxMapper.convertToCustomSIF(model, this.sifSelection.getSelectedValues().toArray(new SIFType[0]), new FileOutputStream(tmpSifFile));
                CySubNetwork net = this.rootNetwork == null ? this.cyServices.networkFactory.createNetwork() : this.rootNetwork.addSubNetwork();
                CustomSifParser customSifParser = new CustomSifParser((CyNetwork)net, this.cyServices);
                BufferedReader reader = Files.newBufferedReader(tmpSifFile.toPath());
                String line = null;
                while ((line = reader.readLine()) != null) {
                    customSifParser.parse(line);
                }
                reader.close();
                this.createSifNodeAttr(model, (CyNetwork)net, taskMonitor);
                AttributeUtil.set((CyNetwork)net, (CyIdentifiable)net, "BIOPAX_NETWORK", "SIF", String.class);
                AttributeUtil.set((CyNetwork)net, (CyIdentifiable)net, "name", networkName, String.class);
                this.networks.add((CyNetwork)net);
                taskMonitor.setStatusMessage("SIF network updated...");
                break;
            }
            case SBGN: {
                taskMonitor.setStatusMessage("Mapping BioPAX model to SBGN...");
                File sbgnFile = File.createTempFile("biopax", ".sbgn.xml");
                sbgnFile.deleteOnExit();
                BioPaxMapper.convertToSBGN(model, new FileOutputStream(sbgnFile));
                try {
                    this.anotherReader = this.cyServices.networkViewReaderManager.getReader(sbgnFile.toURI(), networkName);
                }
                catch (Throwable t) {
                    log.warn("No SBGN reader found or BioPAX-SBGN conversion failed", (Object)t.getMessage());
                }
                if (this.anotherReader != null) {
                    this.insertTasksAfterCurrentTask(new Task[]{this.anotherReader, new AbstractTask(){

                        public void run(TaskMonitor taskMonitor) throws Exception {
                            taskMonitor.setTitle("BioPAX reader");
                            taskMonitor.setStatusMessage("Updating attributess...");
                            for (CyNetwork network : BioPaxReaderTask.this.anotherReader.getNetworks()) {
                                AttributeUtil.set(network, (CyIdentifiable)network, "BIOPAX_NETWORK", "SBGN", String.class);
                                AttributeUtil.set(network, (CyIdentifiable)network, "name", networkName, String.class);
                                BioPaxReaderTask.this.networks.add(network);
                            }
                            taskMonitor.setProgress(1.0);
                        }
                    }});
                    break;
                }
                taskMonitor.setStatusMessage("No SBGN ML reader found - no CyNetwork created");
                break;
            }
        }
    }

    private void createSifNodeAttr(Model model, CyNetwork cyNetwork, TaskMonitor taskMonitor) throws IOException {
        taskMonitor.setStatusMessage("Updating SIF network node attributes from the BioPAX model...");
        AttributeUtil.set(cyNetwork, (CyIdentifiable)cyNetwork, "quickfind.default_index", "name", String.class);
        if (this.cancelled) {
            return;
        }
        for (CyNode node : cyNetwork.getNodeList()) {
            String uri = (String)cyNetwork.getRow((CyIdentifiable)node).get("name", String.class);
            BioPAXElement e = model.getByID(uri);
            if (e instanceof EntityReference || e instanceof Entity) {
                BioPaxMapper.createAttributesFromProperties(e, model, node, cyNetwork);
                continue;
            }
            if (e != null) {
                log.warn("SIF network has an unexpected node: " + uri + " of type " + e.getModelInterface());
                BioPaxMapper.createAttributesFromProperties(e, model, node, cyNetwork);
                continue;
            }
            log.error("(BUG) the biopax model does not have an object with URI=" + uri);
        }
    }

    private String getNetworkName(Model model) {
        String name = BioPaxMapper.getName(model);
        if (name == null || name.trim().isEmpty()) {
            name = this.inputName == null || this.inputName.trim().isEmpty() ? "BioPAX_Network" : this.inputName;
        } else {
            int l = name.length() < 100 ? name.length() : 100;
            name = this.inputName == null || this.inputName.trim().isEmpty() ? name.substring(0, l) : this.inputName;
        }
        name = this.cyServices.naming.getSuggestedNetworkTitle(StringEscapeUtils.unescapeHtml4((String)name) + " (" + this.readerMode.getSelectedValue() + ")");
        log.info("New BioPAX network name is: " + name);
        return name;
    }

    public CyNetwork[] getNetworks() {
        return this.networks.toArray(new CyNetwork[0]);
    }

    public CyNetworkView buildCyNetworkView(CyNetwork network) {
        CyNetworkView view;
        ReaderMode currentMode = (ReaderMode)((Object)this.readerMode.getSelectedValue());
        switch (currentMode) {
            case DEFAULT: {
                view = this.getNetworkViewFactory().createNetworkView(network);
                break;
            }
            case SIF: {
                view = this.getNetworkViewFactory().createNetworkView(network);
                break;
            }
            default: {
                view = this.anotherReader.buildCyNetworkView(network);
            }
        }
        if (!this.cyServices.networkViewManager.getNetworkViews(network).contains(view)) {
            this.cyServices.networkViewManager.addNetworkView(view);
        }
        return view;
    }

    private CyNetworkViewFactory getNetworkViewFactory() {
        if (this.rendererList != null && this.rendererList.getSelectedValue() != null) {
            return ((NetworkViewRenderer)this.rendererList.getSelectedValue()).getNetworkViewFactory();
        }
        return this.cyServices.networkViewFactory;
    }

    private static enum ReaderMode {
        DEFAULT("Default"),
        SIF("SIF"),
        SBGN("SBGN");

        private final String name;

        private ReaderMode(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        static String[] names() {
            ReaderMode[] vals = ReaderMode.values();
            String[] names = new String[vals.length];
            for (int i = 0; i < vals.length; ++i) {
                names[i] = vals[i].toString();
            }
            return names;
        }
    }
}

