/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.biopax.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.SwingUtilities;
import org.cytoscape.biopax.internal.BioPaxReaderTask;
import org.cytoscape.biopax.internal.CyServices;
import org.cytoscape.biopax.internal.util.BioPaxReaderError;
import org.cytoscape.biopax.internal.util.VisualStyleUtil;
import org.cytoscape.io.CyFileFilter;
import org.cytoscape.io.read.AbstractInputStreamTaskFactory;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTable;
import org.cytoscape.session.events.SessionAboutToBeLoadedEvent;
import org.cytoscape.session.events.SessionAboutToBeLoadedListener;
import org.cytoscape.session.events.SessionLoadCancelledEvent;
import org.cytoscape.session.events.SessionLoadCancelledListener;
import org.cytoscape.session.events.SessionLoadedEvent;
import org.cytoscape.session.events.SessionLoadedListener;
import org.cytoscape.view.layout.CyLayoutAlgorithm;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.events.NetworkViewAddedEvent;
import org.cytoscape.view.model.events.NetworkViewAddedListener;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BioPaxReader
extends AbstractInputStreamTaskFactory
implements NetworkViewAddedListener,
SessionAboutToBeLoadedListener,
SessionLoadCancelledListener,
SessionLoadedListener {
    private final CyServices cyServices;
    private final VisualStyleUtil visualStyleUtil;
    private boolean loadingSession;
    private static final Logger LOG = LoggerFactory.getLogger(BioPaxReader.class);

    public BioPaxReader(CyFileFilter filter, CyServices cyServices, VisualStyleUtil visualStyleUtil) {
        super(filter);
        this.cyServices = cyServices;
        this.visualStyleUtil = visualStyleUtil;
    }

    public TaskIterator createTaskIterator(InputStream is, String inputName) {
        LOG.info("createTaskIterator: input stream name: " + inputName);
        try {
            return new TaskIterator(new Task[]{new BioPaxReaderTask(this.copy(is), inputName, this.cyServices, this.visualStyleUtil)});
        }
        catch (IOException e) {
            throw new BioPaxReaderError(e.toString());
        }
    }

    public void handleEvent(SessionAboutToBeLoadedEvent e) {
        this.loadingSession = true;
    }

    public void handleEvent(SessionLoadedEvent e) {
        this.loadingSession = false;
    }

    public void handleEvent(SessionLoadCancelledEvent e) {
        this.loadingSession = false;
    }

    public void handleEvent(NetworkViewAddedEvent e) {
        if (this.loadingSession) {
            return;
        }
        final CyNetworkView view = e.getNetworkView();
        CyNetwork cyNetwork = (CyNetwork)view.getModel();
        if (this.isBioPaxNetwork(cyNetwork)) {
            VisualStyle style = null;
            String kind = (String)cyNetwork.getRow((CyIdentifiable)cyNetwork).get("BIOPAX_NETWORK", String.class);
            if ("DEFAULT".equals(kind)) {
                style = this.visualStyleUtil.getBioPaxVisualStyle();
            } else if ("SIF".equals(kind)) {
                style = this.visualStyleUtil.getBinarySifVisualStyle();
            }
            if (style != null) {
                final VisualStyle vs = style;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BioPaxReader.this.layout(view);
                        BioPaxReader.this.cyServices.mappingManager.setVisualStyle(vs, view);
                        vs.apply(view);
                        view.updateView();
                    }
                });
            }
        }
    }

    private void layout(CyNetworkView view) {
        CyLayoutAlgorithm layout = this.cyServices.layoutManager.getLayout("force-directed");
        if (layout == null) {
            layout = this.cyServices.layoutManager.getDefaultLayout();
            LOG.warn("'force-directed' layout not found; will use the default one.");
        }
        this.cyServices.taskManager.execute(layout.createTaskIterator(view, layout.getDefaultLayoutContext(), CyLayoutAlgorithm.ALL_NODE_VIEWS, ""));
    }

    private boolean isBioPaxNetwork(CyNetwork cyNetwork) {
        CyTable cyTable = cyNetwork.getDefaultNetworkTable();
        return cyTable.getColumn("BIOPAX_NETWORK") != null;
    }

    private InputStream copy(InputStream is) throws IOException {
        ByteArrayOutputStream copy = new ByteArrayOutputStream();
        int chunk = 0;
        byte[] data = new byte[0x100000];
        while (-1 != (chunk = is.read(data))) {
            copy.write(data, 0, chunk);
        }
        is.close();
        return new ByteArrayInputStream(copy.toByteArray());
    }
}

