/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.biopax.internal;

import com.ctc.wstx.stax.WstxInputFactory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.biopax.paxtools.controller.AbstractTraverser;
import org.biopax.paxtools.controller.EditorMap;
import org.biopax.paxtools.controller.ModelUtils;
import org.biopax.paxtools.controller.ObjectPropertyEditor;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.controller.SimpleEditorMap;
import org.biopax.paxtools.converter.LevelUpgrader;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.biopax.paxtools.io.sbgn.L3ToSBGNPDConverter;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.BioSource;
import org.biopax.paxtools.model.level3.Catalysis;
import org.biopax.paxtools.model.level3.CellularLocationVocabulary;
import org.biopax.paxtools.model.level3.Complex;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.ControlType;
import org.biopax.paxtools.model.level3.Controller;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.Entity;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.Interaction;
import org.biopax.paxtools.model.level3.Named;
import org.biopax.paxtools.model.level3.Pathway;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.Process;
import org.biopax.paxtools.model.level3.PublicationXref;
import org.biopax.paxtools.model.level3.RelationshipTypeVocabulary;
import org.biopax.paxtools.model.level3.RelationshipXref;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;
import org.biopax.paxtools.model.level3.Stoichiometry;
import org.biopax.paxtools.model.level3.UnificationXref;
import org.biopax.paxtools.model.level3.XReferrable;
import org.biopax.paxtools.model.level3.Xref;
import org.biopax.paxtools.pattern.miner.CustomFormat;
import org.biopax.paxtools.pattern.miner.IDFetcher;
import org.biopax.paxtools.pattern.miner.OutputColumn;
import org.biopax.paxtools.pattern.miner.SIFInteraction;
import org.biopax.paxtools.pattern.miner.SIFSearcher;
import org.biopax.paxtools.pattern.miner.SIFType;
import org.biopax.paxtools.pattern.miner.SimpleIDFetcher;
import org.biopax.paxtools.util.ClassFilterSet;
import org.biopax.paxtools.util.Filter;
import org.cytoscape.biopax.internal.util.AttributeUtil;
import org.cytoscape.biopax.internal.util.ClassLoaderHack;
import org.cytoscape.biopax.internal.util.ExternalLink;
import org.cytoscape.biopax.internal.util.ExternalLinkUtil;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkFactory;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BioPaxMapper {
    public static final Logger log = LoggerFactory.getLogger(BioPaxMapper.class);
    public static final String BIOPAX_URI = "URI";
    public static final String BIOPAX_NETWORK = "BIOPAX_NETWORK";
    public static final String BIOPAX_ENTITY_TYPE = "BIOPAX_TYPE";
    public static final String BIOPAX_CHEMICAL_MODIFICATIONS_LIST = "CHEMICAL_MODIFICATIONS";
    public static final String BIOPAX_UNIFICATION_REFERENCES = "UNIFICATION_REFERENCES";
    public static final String BIOPAX_RELATIONSHIP_REFERENCES = "RELATIONSHIP_REFERENCES";
    public static final String BIOPAX_PUBLICATION_REFERENCES = "PUBLICATION_REFERENCES";
    public static final String BIOPAX_UNIFICATION = "UNIFICATION";
    public static final String BIOPAX_RELATIONSHIP = "RELATIONSHIP";
    public static final String BIOPAX_PUBLICATION = "PUBLICATION";
    public static final String BIOPAX_IHOP_LINKS = "IHOP_LINKS";
    public static final String PHOSPHORYLATION_SITE = "phosphorylation site";
    public static final String PROTEIN_PHOSPHORYLATED = "Protein-phosphorylated";
    private final Model model;
    private final CyNetworkFactory networkFactory;
    private final Map<BioPAXElement, CyNode> bpeToCyNodeMap = new HashMap<BioPAXElement, CyNode>();

    public BioPaxMapper(Model model, CyNetworkFactory cyNetworkFactory) {
        this.model = model;
        this.networkFactory = cyNetworkFactory;
    }

    public CyNetwork createCyNetwork(String networkName, CyRootNetwork rootNetwork) {
        CySubNetwork network = rootNetwork == null ? this.networkFactory.createNetwork() : rootNetwork.addSubNetwork();
        this.createEntityNodes((CyNetwork)network);
        this.createInteractionEdges((CyNetwork)network);
        this.createComplexEdges((CyNetwork)network);
        this.createMemberEdges((CyNetwork)network);
        AttributeUtil.set((CyNetwork)network, (CyIdentifiable)network, "name", networkName, String.class);
        AttributeUtil.set((CyNetwork)network, (CyIdentifiable)network, "quickfind.default_index", "name", String.class);
        return network;
    }

    private void createMemberEdges(CyNetwork network) {
        for (PhysicalEntity par : this.model.getObjects(PhysicalEntity.class)) {
            Set members = par.getMemberPhysicalEntity();
            if (members.isEmpty()) continue;
            CyNode cyParentNode = this.bpeToCyNodeMap.get(par);
            assert (cyParentNode != null) : "cyParentNode is NULL.";
            for (PhysicalEntity member : members) {
                CyNode cyMemberNode = this.bpeToCyNodeMap.get(member);
                CyEdge edge = network.addEdge(cyParentNode, cyMemberNode, true);
                AttributeUtil.set(network, (CyIdentifiable)edge, "interaction", "member", String.class);
            }
        }
    }

    private void createEntityNodes(CyNetwork network) {
        Set entities = this.model.getObjects(Entity.class);
        for (Entity bpe : entities) {
            if (bpe instanceof Pathway && bpe.getParticipantOf().isEmpty() && ((Process)bpe).getPathwayComponentOf().isEmpty()) continue;
            CyNode node = network.addNode();
            this.bpeToCyNodeMap.put((BioPAXElement)bpe, node);
            BioPaxMapper.createAttributesFromProperties((BioPAXElement)bpe, this.model, node, network);
        }
        if (log.isDebugEnabled()) {
            log.debug((String)network.getRow((CyIdentifiable)network).get("name", String.class) + network.getNodeList().size() + " nodes created.");
        }
    }

    private void createInteractionEdges(CyNetwork network) {
        Set interactionList = this.model.getObjects(Interaction.class);
        for (Interaction itr : interactionList) {
            if (log.isTraceEnabled()) {
                log.trace("Mapping " + itr.getModelInterface().getSimpleName() + " edges : " + itr.getUri());
            }
            if (itr instanceof Conversion) {
                this.addConversionInteraction(network, (Conversion)itr);
                continue;
            }
            if (itr instanceof Control) {
                this.addControlInteraction(network, (Control)itr);
                continue;
            }
            this.addPhysicalInteraction(network, itr);
        }
    }

    private void createComplexEdges(CyNetwork network) {
        for (Complex complexElement : this.model.getObjects(Complex.class)) {
            Set members = complexElement.getComponent();
            if (members.isEmpty()) continue;
            CyNode complexCyNode = this.bpeToCyNodeMap.get(complexElement);
            for (PhysicalEntity member : members) {
                CyNode complexMemberCyNode = this.bpeToCyNodeMap.get(member);
                CyEdge edge = network.addEdge(complexCyNode, complexMemberCyNode, true);
                AttributeUtil.set(network, (CyIdentifiable)edge, "interaction", "contains", String.class);
            }
        }
    }

    private void addPhysicalInteraction(CyNetwork network, Interaction interactionElement) {
        Set participantElements = interactionElement.getParticipant();
        for (Entity participantElement : participantElements) {
            this.linkNodes(network, (BioPAXElement)interactionElement, (BioPAXElement)participantElement, "participant");
        }
    }

    private void addConversionInteraction(CyNetwork network, Conversion interactionElement) {
        Set leftSideElements = interactionElement.getLeft();
        for (PhysicalEntity leftElement : leftSideElements) {
            this.linkNodes(network, (BioPAXElement)interactionElement, (BioPAXElement)leftElement, "left");
        }
        Set rightSideElements = interactionElement.getRight();
        for (PhysicalEntity rightElement : rightSideElements) {
            this.linkNodes(network, (BioPAXElement)interactionElement, (BioPAXElement)rightElement, "right");
        }
    }

    private void linkNodes(CyNetwork network, BioPAXElement bpeA, BioPAXElement bpeB, String type) {
        CyNode nodeA = this.bpeToCyNodeMap.get(bpeA);
        if (nodeA == null) {
            log.debug("linkNodes: no node was created for " + bpeA.getModelInterface() + " " + bpeA.getUri());
            return;
        }
        CyNode nodeB = this.bpeToCyNodeMap.get(bpeB);
        if (nodeB == null) {
            log.debug("linkNodes: no node was created for " + bpeB.getModelInterface() + " " + bpeB.getUri());
            return;
        }
        CyEdge edge = null;
        String a = BioPaxMapper.getName(bpeA);
        String b = BioPaxMapper.getName(bpeB);
        if (type.equals("right") || type.equals("cofactor") || type.equals("participant")) {
            edge = network.addEdge(nodeA, nodeB, true);
            AttributeUtil.set(network, (CyIdentifiable)edge, "name", a + type + b, String.class);
        } else {
            edge = network.addEdge(nodeB, nodeA, true);
            AttributeUtil.set(network, (CyIdentifiable)edge, "name", b + type + a, String.class);
        }
        AttributeUtil.set(network, (CyIdentifiable)edge, "interaction", type, String.class);
    }

    private void addControlInteraction(CyNetwork network, Control control) {
        Set controlledList = control.getControlled();
        for (Object process : controlledList) {
            String typeStr = "controlled";
            ControlType cType = control.getControlType();
            typeStr = cType == null ? typeStr : cType.toString();
            this.linkNodes(network, (BioPAXElement)process, (BioPAXElement)control, typeStr);
        }
        Set controllerList = control.getController();
        for (Controller controller : controllerList) {
            this.linkNodes(network, (BioPAXElement)control, (BioPAXElement)controller, "controller");
        }
        if (control instanceof Catalysis) {
            Set coFactorList = ((Catalysis)control).getCofactor();
            for (PhysicalEntity cofactor : coFactorList) {
                this.linkNodes(network, (BioPAXElement)control, (BioPAXElement)cofactor, "cofactor");
            }
        }
    }

    private static NodeAttributesWrapper getInteractionChemicalModifications(BioPAXElement participantElement) {
        Collection<?> modificationNotFeatures;
        if (participantElement == null) {
            return null;
        }
        HashSet<String> chemicalModificationsSet = new HashSet<String>();
        Collection<?> modificationFeatures = BioPaxMapper.getValues(participantElement, "feature");
        if (modificationFeatures != null) {
            for (Object modification : modificationFeatures) {
                Object value;
                if (modification == null || (value = BioPaxMapper.getValue((BioPAXElement)modification, "modificationType")) == null) continue;
                String mod = value.toString();
                mod = mod.substring(mod.indexOf("_") + 1).replaceAll("\\[|\\]", "");
                chemicalModificationsSet.add(mod);
            }
        }
        if ((modificationNotFeatures = BioPaxMapper.getValues(participantElement, "notFeature")) != null) {
            for (Object modification : modificationNotFeatures) {
                Object value;
                if (modification == null || (value = BioPaxMapper.getValue((BioPAXElement)modification, "modificationType")) == null) continue;
                Object mod = value.toString();
                mod = "!" + ((String)mod).substring(((String)mod).indexOf("_") + 1).replaceAll("\\[|\\]", "");
                chemicalModificationsSet.add((String)mod);
            }
        }
        return new NodeAttributesWrapper(chemicalModificationsSet);
    }

    private static void createExtraXrefAttributes(BioPAXElement resource, CyNetwork network, CyNode node) {
        if (resource instanceof PhysicalEntity || resource instanceof EntityReference) {
            Object u = resource.getUri();
            if (resource instanceof SimplePhysicalEntity && ((SimplePhysicalEntity)resource).getEntityReference() != null) {
                u = ((SimplePhysicalEntity)resource).getEntityReference().getUri();
            }
            if (((String)u).startsWith("http://identifiers.org/uniprot")) {
                String id = ((String)u).substring(((String)u).lastIndexOf(47) + 1);
                AttributeUtil.set(network, (CyIdentifiable)node, "UNIPROT", id, String.class);
            }
        }
        for (Xref link : BioPaxMapper.getXRefs(resource, Xref.class, false)) {
            if (link.getDb() == null || link.getDb().isEmpty() || link.getId() == null || link.getId().isEmpty()) continue;
            BioPaxMapper.createSpecialXrefAttribute(resource, network, node, link);
        }
        String stringRef = BioPaxMapper.ihopLinks(resource);
        if (stringRef != null) {
            AttributeUtil.set(network, (CyIdentifiable)node, "HIDDEN", BIOPAX_IHOP_LINKS, stringRef, String.class);
        }
        ArrayList<String> uniXrefList = new ArrayList<String>();
        ArrayList<String> relXrefList = new ArrayList<String>();
        ArrayList<String> pubXrefList = new ArrayList<String>();
        ArrayList<String> uniLinkList = new ArrayList<String>();
        ArrayList<String> relLinkList = new ArrayList<String>();
        ArrayList<String> pubLinkList = new ArrayList<String>();
        for (Xref link : BioPaxMapper.getXRefs(resource, Xref.class, true)) {
            String str;
            if (link.getDb() == null || link.getDb().isEmpty() || link.getId() == null || link.getId().isEmpty()) continue;
            StringBuffer temp = new StringBuffer();
            temp.append(ExternalLinkUtil.createLink(link.getDb(), link.getId()));
            if (link instanceof UnificationXref) {
                str = temp.toString();
                if (!uniLinkList.contains(str)) {
                    uniLinkList.add(str);
                }
                if (uniXrefList.contains(str = link.toString())) continue;
                uniXrefList.add(str);
                continue;
            }
            if (link instanceof PublicationXref) {
                PublicationXref xl = (PublicationXref)link;
                temp.append(" ");
                if (!xl.getAuthor().isEmpty()) {
                    temp.append(xl.getAuthor().toString() + " et al., ");
                }
                if (xl.getTitle() != null) {
                    temp.append(xl.getTitle());
                }
                if (!xl.getSource().isEmpty()) {
                    temp.append(" (" + xl.getSource().toString());
                    if (xl.getYear() > 0) {
                        temp.append(", " + xl.getYear());
                    }
                    temp.append(")");
                }
                if (!pubLinkList.contains(str = temp.toString())) {
                    pubLinkList.add(str);
                }
                if (pubXrefList.contains(str = link.toString())) continue;
                pubXrefList.add(str);
                continue;
            }
            if (!(link instanceof RelationshipXref)) continue;
            str = temp.toString();
            if (!relLinkList.contains(str)) {
                relLinkList.add(str);
            }
            if (relXrefList.contains(str = link.toString())) continue;
            relXrefList.add(str);
        }
        AttributeUtil.set(network, (CyIdentifiable)node, BIOPAX_UNIFICATION, uniXrefList, String.class);
        AttributeUtil.set(network, (CyIdentifiable)node, BIOPAX_RELATIONSHIP, relXrefList, String.class);
        AttributeUtil.set(network, (CyIdentifiable)node, BIOPAX_PUBLICATION, pubXrefList, String.class);
        AttributeUtil.set(network, (CyIdentifiable)node, "HIDDEN", BIOPAX_UNIFICATION_REFERENCES, uniLinkList, String.class);
        AttributeUtil.set(network, (CyIdentifiable)node, "HIDDEN", BIOPAX_RELATIONSHIP_REFERENCES, relLinkList, String.class);
        AttributeUtil.set(network, (CyIdentifiable)node, "HIDDEN", BIOPAX_PUBLICATION_REFERENCES, pubLinkList, String.class);
    }

    private static void createSpecialXrefAttribute(BioPAXElement resource, CyNetwork network, CyNode node, Xref link) {
        String exists;
        String db = link.getDb().toUpperCase().trim();
        String id = link.getId().trim();
        if (db.equalsIgnoreCase("HGNC SYMBOL") || db.startsWith("HGNC") || db.startsWith("HUGO GENE") || db.startsWith("GENE SYMBOL") || db.startsWith("GENE NAME")) {
            String exists2 = (String)network.getRow((CyIdentifiable)node).get("GENE SYMBOL", String.class);
            if (exists2 == null && !id.startsWith("HGNC:")) {
                AttributeUtil.set(network, (CyIdentifiable)node, "GENE SYMBOL", id, String.class);
            }
        } else if (db.equalsIgnoreCase("NCBI GENE") || db.equalsIgnoreCase("ENTREZ GENE") || db.equalsIgnoreCase("GENE ID")) {
            String exists3 = (String)network.getRow((CyIdentifiable)node).get("NCBI GENE", String.class);
            if (exists3 == null) {
                AttributeUtil.set(network, (CyIdentifiable)node, "NCBI GENE", id, String.class);
            }
        } else if ((db.startsWith("UNIPROT") || db.startsWith("SWISSPROT") || db.startsWith("SWISS-PROT")) && (exists = (String)network.getRow((CyIdentifiable)node).get("UNIPROT", String.class)) == null) {
            AttributeUtil.set(network, (CyIdentifiable)node, "UNIPROT", id, String.class);
        }
    }

    public static void createAttributesFromProperties(BioPAXElement element, Model model, final CyNode node, final CyNetwork network) {
        Filter<PropertyEditor> filter = new Filter<PropertyEditor>(){

            public boolean filter(PropertyEditor editor) {
                boolean pass = true;
                String prop = editor.getProperty();
                if (editor instanceof ObjectPropertyEditor) {
                    Class c = editor.getRange();
                    if (Entity.class.isAssignableFrom(c) || Stoichiometry.class.isAssignableFrom(c) || "nextStep".equals(prop)) {
                        pass = false;
                    }
                } else if ("name".equals(prop)) {
                    pass = false;
                }
                return pass;
            }
        };
        AbstractTraverser bpeAutoMapper = new AbstractTraverser((EditorMap)SimpleEditorMap.L3, new Filter[]{filter}){
            final Stack<String> propPath;
            {
                super(arg0, arg1);
                this.propPath = new Stack();
            }

            protected void visit(Object obj, BioPAXElement bpe, Model model, PropertyEditor editor) {
                if (obj != null && !editor.isUnknown(obj)) {
                    this.propPath.push(editor.getProperty());
                    String attrName = StringUtils.join(this.propPath, (String)"/");
                    String value = obj.toString();
                    if (!"".equalsIgnoreCase(value.toString().replaceAll("\\]|\\[", ""))) {
                        if (editor.isMultipleCardinality()) {
                            CyRow row = network.getRow((CyIdentifiable)node);
                            ArrayList<String> vals = new ArrayList<String>();
                            if (row.isSet(attrName)) {
                                Class listElementType = row.getTable().getColumn(attrName).getListElementType();
                                List prevList = row.getList(attrName, listElementType);
                                if (!prevList.contains(value)) {
                                    prevList.add(value);
                                }
                            } else {
                                vals.add(value);
                                AttributeUtil.set(network, (CyIdentifiable)node, attrName, vals, String.class);
                            }
                        } else {
                            AttributeUtil.set(network, (CyIdentifiable)node, attrName, value, String.class);
                        }
                    }
                    if (editor instanceof ObjectPropertyEditor && !editor.isMultipleCardinality()) {
                        this.traverse((BioPAXElement)obj, null);
                    }
                    this.propPath.pop();
                }
            }
        };
        AttributeUtil.set(network, (CyIdentifiable)node, BIOPAX_URI, element.getUri(), String.class);
        AttributeUtil.set(network, (CyIdentifiable)node, BIOPAX_ENTITY_TYPE, element.getModelInterface().getSimpleName(), String.class);
        Object name = BioPaxMapper.getName(element);
        if (!(element instanceof Interaction)) {
            CellularLocationVocabulary cl;
            NodeAttributesWrapper chemicalModificationsWrapper = BioPaxMapper.getInteractionChemicalModifications(element);
            if (chemicalModificationsWrapper != null) {
                name = (String)name + chemicalModificationsWrapper.toString();
                List<String> list = chemicalModificationsWrapper.asList();
                if (list != null && !list.isEmpty()) {
                    AttributeUtil.set(network, (CyIdentifiable)node, BIOPAX_CHEMICAL_MODIFICATIONS_LIST, list, String.class);
                    if (list.contains(PHOSPHORYLATION_SITE)) {
                        AttributeUtil.set(network, (CyIdentifiable)node, BIOPAX_ENTITY_TYPE, PROTEIN_PHOSPHORYLATED, String.class);
                    }
                }
            }
            if (element instanceof PhysicalEntity && (cl = ((PhysicalEntity)element).getCellularLocation()) != null) {
                String terms = cl.toString();
                name = (String)name + (String)((terms = terms.substring(terms.indexOf("_") + 1).replaceAll("\\[|\\]", "")).length() > 0 ? "; " + terms : "");
            }
        }
        AttributeUtil.set(network, (CyIdentifiable)node, "name", name, String.class);
        bpeAutoMapper.traverse(element, model);
        BioPaxMapper.createExtraXrefAttributes(element, network, node);
    }

    public static <T extends Xref> List<ExternalLink> xrefToExternalLinks(BioPAXElement bpe, Class<T> xrefClass) {
        if (bpe instanceof XReferrable) {
            ArrayList<ExternalLink> erefs = new ArrayList<ExternalLink>();
            erefs.addAll(BioPaxMapper.extractXrefs((Collection<? extends Xref>)new ClassFilterSet(((XReferrable)bpe).getXref(), xrefClass)));
            if (bpe instanceof SimplePhysicalEntity && ((SimplePhysicalEntity)bpe).getEntityReference() != null) {
                erefs.addAll(BioPaxMapper.extractXrefs((Collection<? extends Xref>)new ClassFilterSet(((SimplePhysicalEntity)bpe).getEntityReference().getXref(), xrefClass)));
            }
            return erefs;
        }
        return new ArrayList<ExternalLink>();
    }

    private static List<ExternalLink> extractXrefs(Collection<? extends Xref> xrefs) {
        ArrayList<ExternalLink> dbList = new ArrayList<ExternalLink>();
        for (Xref xref : xrefs) {
            RelationshipTypeVocabulary v;
            String db = null;
            String id = null;
            String relType = null;
            String title = null;
            String year = null;
            String author = null;
            String url = null;
            String source = null;
            db = xref.getDb();
            id = xref.getId();
            if (xref instanceof RelationshipXref && (v = ((RelationshipXref)xref).getRelationshipType()) != null) {
                relType = v.getTerm().toString();
            }
            if (xref instanceof PublicationXref) {
                PublicationXref px = (PublicationXref)xref;
                author = px.getAuthor().toString();
                title = px.getTitle();
                source = px.getSource().toString();
                url = px.getUrl().toString();
                year = "" + px.getYear();
            }
            if (db == null || id == null) continue;
            ExternalLink link = new ExternalLink(db, id);
            link.setAuthor(author);
            link.setRelType(relType);
            link.setTitle(title);
            link.setYear(year);
            link.setSource(source);
            link.setUrl(url);
            dbList.add(link);
        }
        return dbList;
    }

    private static String ihopLinks(BioPAXElement bpe) {
        ArrayList<String> synList = new ArrayList<String>(BioPaxMapper.getSynonyms(bpe));
        List<ExternalLink> dbList = BioPaxMapper.xrefToExternalLinks(bpe, Xref.class);
        String htmlLink = null;
        if (!synList.isEmpty() || !dbList.isEmpty()) {
            htmlLink = ExternalLinkUtil.createIHOPLink(bpe.getModelInterface().getSimpleName(), synList, dbList, BioPaxMapper.getOrganismTaxonomyId(bpe));
        }
        return htmlLink;
    }

    public static Model read(InputStream in) throws FileNotFoundException {
        Model model = BioPaxMapper.convertFromOwl(in);
        if (model != null && BioPAXLevel.L2.equals((Object)model.getLevel())) {
            model = new LevelUpgrader().filter(model);
        }
        if (model != null) {
            BioPaxMapper.fixDisplayName(model);
        }
        return model;
    }

    private static Model convertFromOwl(final InputStream stream) {
        final Model[] model = new Model[1];
        final SimpleIOHandler handler = new SimpleIOHandler();
        handler.mergeDuplicates(true);
        ClassLoaderHack.runWithHack(new Runnable(){

            @Override
            public void run() {
                try {
                    model[0] = handler.convertFromOWL(stream);
                }
                catch (Throwable e) {
                    log.error("convertFromOwl failed: " + e);
                }
            }
        }, WstxInputFactory.class);
        return model[0];
    }

    public static String getName(BioPAXElement bpe) {
        String nodeName = null;
        if (bpe instanceof Named) {
            nodeName = ((Named)bpe).getDisplayName();
        }
        return nodeName == null || nodeName.isEmpty() ? bpe.getUri() : StringEscapeUtils.unescapeHtml4((String)nodeName);
    }

    public static Object getValue(BioPAXElement bpe, String ... properties) {
        for (String property : properties) {
            try {
                Method method = bpe.getModelInterface().getMethod("get" + property.substring(0, 1).toUpperCase() + property.substring(1).replace('-', '_'), new Class[0]);
                Object invoke = method.invoke((Object)bpe, new Object[0]);
                if (invoke == null) continue;
                return invoke;
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Ignore property " + property + " for " + bpe.getUri() + ": " + e);
            }
        }
        return null;
    }

    public static Collection<?> getValues(BioPAXElement bpe, String ... properties) {
        HashSet<Object> col = new HashSet<Object>();
        for (String property : properties) {
            try {
                Method method = bpe.getModelInterface().getMethod("get" + property.substring(0, 1).toUpperCase() + property.substring(1).replace('-', '_'), new Class[0]);
                Object invoke = method.invoke((Object)bpe, new Object[0]);
                if (invoke == null) continue;
                if (invoke instanceof Collection) {
                    col.addAll((Collection)invoke);
                    continue;
                }
                col.add(invoke);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Cannot get value of '" + property + "' for " + bpe.getUri() + ": " + e);
            }
        }
        return col;
    }

    public static Collection<String> getSynonyms(BioPAXElement bpe) {
        Set<String> names = new HashSet<String>();
        if (bpe instanceof Named) {
            names = ((Named)bpe).getName();
        }
        return names;
    }

    public static int getOrganismTaxonomyId(BioPAXElement bpe) {
        int taxonomyId = -1;
        try {
            Set xrefs;
            Object bs = BioPaxMapper.getValue(bpe, "organism");
            if (bs instanceof BioSource && !(xrefs = ((BioSource)bs).getXref()).isEmpty()) {
                Xref tx = (Xref)xrefs.iterator().next();
                taxonomyId = Integer.parseInt(tx.getId());
            }
        }
        catch (Exception e) {
            taxonomyId = -1;
        }
        return taxonomyId;
    }

    private static <T extends Xref> List<T> getXRefs(BioPAXElement bpe, Class<T> xrefClass, boolean withMembersIfGeneric) {
        if (bpe instanceof XReferrable) {
            ArrayList erefs = new ArrayList();
            erefs.addAll(new ClassFilterSet(((XReferrable)bpe).getXref(), xrefClass));
            if (bpe instanceof SimplePhysicalEntity && ((SimplePhysicalEntity)bpe).getEntityReference() != null) {
                EntityReference entityReference = ((SimplePhysicalEntity)bpe).getEntityReference();
                erefs.addAll(new ClassFilterSet(entityReference.getXref(), xrefClass));
                if (withMembersIfGeneric) {
                    for (EntityReference memberEntityReference : entityReference.getMemberEntityReference()) {
                        erefs.addAll(new ClassFilterSet(memberEntityReference.getXref(), xrefClass));
                    }
                }
            } else if (bpe instanceof EntityReference) {
                erefs.addAll(new ClassFilterSet(((EntityReference)bpe).getXref(), xrefClass));
                if (withMembersIfGeneric) {
                    for (EntityReference memberEntityReference : ((EntityReference)bpe).getMemberEntityReference()) {
                        erefs.addAll(new ClassFilterSet(memberEntityReference.getXref(), xrefClass));
                    }
                }
            }
            return erefs;
        }
        return new ArrayList();
    }

    public static Collection<Class<? extends BioPAXElement>> getSubclassNames(Class<? extends BioPAXElement> ... classes) {
        HashSet<Class<? extends BioPAXElement>> subclasses = new HashSet<Class<? extends BioPAXElement>>();
        for (Class<? extends BioPAXElement> c : classes) {
            subclasses.addAll(SimpleEditorMap.L3.getKnownSubClassesOf(c));
        }
        return subclasses;
    }

    public static String getName(Model model) {
        StringBuffer modelName = new StringBuffer();
        Set pws = ModelUtils.getRootElements((Model)model, Pathway.class);
        for (Pathway pw : pws) {
            modelName.append(" ").append(BioPaxMapper.getName((BioPAXElement)pw));
        }
        if (modelName.length() == 0) {
            Set itrs = ModelUtils.getRootElements((Model)model, Interaction.class);
            for (Interaction it : itrs) {
                modelName.append(" ").append(BioPaxMapper.getName((BioPAXElement)it));
            }
        }
        if (modelName.length() == 0) {
            modelName.append(model.getXmlBase());
        }
        String name = modelName.toString().trim();
        return name;
    }

    public static String toOwl(final BioPAXElement bpe) {
        final StringWriter writer = new StringWriter();
        final SimpleIOHandler simpleExporter = new SimpleIOHandler(BioPAXLevel.L3);
        ClassLoaderHack.runWithHack(new Runnable(){

            @Override
            public void run() {
                try {
                    simpleExporter.writeObject((Writer)writer, bpe);
                }
                catch (Exception e) {
                    log.error("Failed printing '" + bpe.getUri() + "' to OWL", (Throwable)e);
                }
            }
        }, WstxInputFactory.class);
        return writer.toString();
    }

    public static void fixDisplayName(Model model) {
        log.info("Trying to auto-set displayName for all BioPAX elements");
        for (Named e : model.getObjects(Named.class)) {
            if (e.getDisplayName() != null) continue;
            if (e.getStandardName() != null) {
                e.setDisplayName(e.getStandardName());
                continue;
            }
            if (e.getName().isEmpty()) continue;
            String dsp = (String)e.getName().iterator().next();
            for (String name : e.getName()) {
                if (name.length() >= dsp.length()) continue;
                dsp = name;
            }
            e.setDisplayName(dsp);
        }
        for (EntityReference er : model.getObjects(EntityReference.class)) {
            for (SimplePhysicalEntity spe : er.getEntityReferenceOf()) {
                if (spe.getDisplayName() != null && spe.getDisplayName().trim().length() != 0 || er.getDisplayName() == null || er.getDisplayName().trim().length() <= 0) continue;
                spe.setDisplayName(er.getDisplayName());
            }
        }
    }

    public static void convertToCustomSIF(Model m, SIFType[] sifTypes, OutputStream sifOutputStream) throws IOException {
        ModelUtils.mergeEquivalentInteractions((Model)m);
        ModelUtils.normalizeGenerics((Model)m);
        for (SimplePhysicalEntity spe : new HashSet(m.getObjects(SimplePhysicalEntity.class))) {
            ModelUtils.addMissingEntityReference((Model)m, (SimplePhysicalEntity)spe);
        }
        SIFSearcher sifSearcher = new SIFSearcher((IDFetcher)new SimpleIDFetcher(), sifTypes);
        Set binaryInts = sifSearcher.searchSIF(m);
        CustomFormat stt = new CustomFormat(new String[]{OutputColumn.Type.RESOURCE.name(), OutputColumn.Type.PUBMED.name(), OutputColumn.Type.PATHWAY.name()});
        if (!binaryInts.isEmpty()) {
            ArrayList interList = new ArrayList(binaryInts);
            Collections.sort(interList);
            OutputStreamWriter writer = new OutputStreamWriter(sifOutputStream);
            for (SIFInteraction inter : interList) {
                writer.write(stt.convert(inter) + "\n");
            }
            writer.close();
        }
    }

    public static void convertToSBGN(Model m, OutputStream out) {
        ModelUtils.mergeEquivalentInteractions((Model)m);
        try {
            L3ToSBGNPDConverter converter = new L3ToSBGNPDConverter(null, null, true);
            converter.writeSBGN(m, out);
            log.debug("Converter BioPAX to SBGN ML (temporary saved in the java tmpdir)");
        }
        catch (Throwable t) {
            log.error("BioPAX to SBGN ML converter failed", t);
        }
    }

    private static class NodeAttributesWrapper {
        private Set<String> attributesSet;

        public NodeAttributesWrapper(Set<String> attributesSet) {
            this.attributesSet = attributesSet;
        }

        public List<String> asList() {
            if (this.attributesSet != null) {
                ArrayList<String> list = new ArrayList<String>(this.attributesSet);
                list.sort(null);
                return list;
            }
            return Collections.emptyList();
        }

        public String toString() {
            if (this.attributesSet != null && !this.attributesSet.isEmpty()) {
                return " -" + StringUtils.join(this.asList(), (String)",");
            }
            return "";
        }
    }
}

