/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.jobs.internal;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.Logger;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.jobs.CyJob;
import org.cytoscape.jobs.CyJobMonitor;
import org.cytoscape.jobs.CyJobStatus;
import org.cytoscape.jobs.internal.CyJobManagerImpl;
import org.cytoscape.jobs.internal.GUIJobDialog;
import org.cytoscape.jobs.internal.JobStatusBar;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.AbstractTaskFactory;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskMonitor;

public class GUICyJobMonitor
extends AbstractTaskFactory
implements CyJobMonitor {
    final Logger logger;
    final CyServiceRegistrar serviceRegistrar;
    final ConcurrentMap<CyJob, CyJobStatus> statusMap;
    final GUIJobDialog dialog;
    final JobStatusBar statusBar;
    final CyJobManagerImpl jobManager;

    public GUICyJobMonitor(CyServiceRegistrar registrar, CyJobManagerImpl jobManager, JobStatusBar statusBar) {
        this.serviceRegistrar = registrar;
        this.jobManager = jobManager;
        this.statusBar = statusBar;
        jobManager.setJobMonitor(this);
        this.logger = Logger.getLogger((String)"org.cytoscape.application.userlog");
        this.statusMap = new ConcurrentHashMap<CyJob, CyJobStatus>();
        CySwingApplication swingApp = (CySwingApplication)registrar.getService(CySwingApplication.class);
        this.dialog = new GUIJobDialog(this.serviceRegistrar, swingApp, this.statusMap, jobManager, this);
        statusBar.setDialog(this.dialog);
    }

    public TaskIterator createTaskIterator() {
        return new TaskIterator(new Task[]{new AbstractTask(){

            public void run(TaskMonitor monitor) {
                GUICyJobMonitor.this.dialog.setVisible(true);
            }
        }});
    }

    public void jobStatusChanged(CyJob job, CyJobStatus status) {
        String jobId = job.getJobId();
        CyJobStatus.Status stat = status.getStatus();
        if (this.statusMap.containsKey(job) && ((CyJobStatus)this.statusMap.get(job)).getStatus().equals((Object)stat)) {
            return;
        }
        this.statusMap.put(job, status);
        this.dialog.mapChanged();
        this.statusBar.updateIcon(this.statusMap.values());
        switch (stat) {
            case FAILED: {
                this.logger.error((Object)("JobManager: Job " + jobId + " has failed!"));
                break;
            }
            case ERROR: {
                this.logger.error((Object)("JobManager: Job " + jobId + " has experienced an error!"));
                break;
            }
            case CANCELED: {
                this.logger.warn((Object)("JobManager: Job " + jobId + " has been canceled!"));
                break;
            }
            case PURGED: {
                this.logger.warn((Object)("JobManager: Job " + jobId + " has been purged!"));
                break;
            }
            case TERMINATED: {
                this.logger.warn((Object)("JobManager: Job " + jobId + " was terminated"));
                break;
            }
            case FINISHED: {
                this.logger.info((Object)("JobManager: Job " + jobId + " has finished"));
                break;
            }
            case SUBMITTED: {
                this.logger.info((Object)("JobManager: Job " + jobId + " was submitted"));
                break;
            }
            case QUEUED: {
                this.logger.info((Object)("JobManager: Job " + jobId + " has been queued"));
                break;
            }
            case RUNNING: {
                this.logger.info((Object)("JobManager: Job " + jobId + " is running"));
            }
        }
    }

    public void updateIcon() {
        this.statusBar.updateIcon(this.statusMap.values());
    }

    public void loadData(CyJob job, TaskMonitor monitor) {
    }
}

