/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.jobs.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.Logger;
import org.cytoscape.jobs.CyJob;
import org.cytoscape.jobs.CyJobExecutionService;
import org.cytoscape.jobs.CyJobManager;
import org.cytoscape.jobs.CyJobMonitor;
import org.cytoscape.jobs.CyJobStatus;
import org.cytoscape.session.CySession;
import org.cytoscape.session.events.SessionAboutToBeSavedEvent;
import org.cytoscape.session.events.SessionAboutToBeSavedListener;
import org.cytoscape.session.events.SessionLoadedEvent;
import org.cytoscape.session.events.SessionLoadedListener;

public class CyJobManagerImpl
implements CyJobManager,
SessionAboutToBeSavedListener,
SessionLoadedListener {
    private CyJobMonitor jobMonitor;
    final Logger logger = Logger.getLogger((String)"org.cytoscape.application.userlog");
    List<CyJob> jobsList = new ArrayList<CyJob>();
    ConcurrentMap<CyJob, CyJobMonitor> jobMonitorMap = new ConcurrentHashMap<CyJob, CyJobMonitor>();
    ConcurrentMap<CyJob, IntervalCounter> intervalMap = new ConcurrentHashMap<CyJob, IntervalCounter>();
    ConcurrentMap<CyJob, CyJobStatus> statusMap = new ConcurrentHashMap<CyJob, CyJobStatus>();
    ConcurrentMap<String, CyJobMonitor> monitorMap = new ConcurrentHashMap<String, CyJobMonitor>();
    ConcurrentMap<String, CyJobExecutionService> exServiceMap = new ConcurrentHashMap<String, CyJobExecutionService>();
    Timer pollTimer = new Timer("Job Status Poller", true);

    public void setJobMonitor(CyJobMonitor monitor) {
        this.jobMonitor = monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJob(CyJob job, CyJobMonitor jobMonitor, int pollInterval) {
        if (this.jobsList.size() == 0) {
            this.pollTimer.schedule((TimerTask)new Poller(), 1000L);
        }
        List<CyJob> list = this.jobsList;
        synchronized (list) {
            this.jobsList.add(job);
        }
        this.associateMonitor(job, jobMonitor, pollInterval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJob(CyJob job) {
        List<CyJob> list = this.jobsList;
        synchronized (list) {
            this.jobsList.remove(job);
        }
        this.jobMonitorMap.remove(job);
        this.intervalMap.remove(job);
        if (this.jobsList.size() == 0) {
            this.resetTimer();
        }
    }

    public void associateMonitor(CyJob job, CyJobMonitor jobMonitor, int pollInterval) {
        if (this.jobsList.contains(job)) {
            if (jobMonitor == null) {
                jobMonitor = job.getJobMonitor();
            }
            if (jobMonitor != null) {
                this.jobMonitorMap.put(job, jobMonitor);
                if (pollInterval <= 0) {
                    pollInterval = job.getPollInterval();
                }
                this.intervalMap.put(job, new IntervalCounter(pollInterval));
            }
        }
    }

    public void associateMonitor(CyJob job, String jobMonitorName, int pollInterval) {
        if (this.monitorMap.containsKey(jobMonitorName)) {
            this.associateMonitor(job, (CyJobMonitor)this.monitorMap.get(jobMonitorName), pollInterval);
        }
    }

    public CyJobStatus cancelJob(CyJob job) {
        this.removeJob(job);
        return job.getJobExecutionService().cancelJob(job);
    }

    public List<CyJob> getJobs() {
        return this.jobsList;
    }

    public CyJob getJob(String jobId) {
        for (CyJob job : this.jobsList) {
            if (!job.getJobId().equals(jobId)) continue;
            return job;
        }
        return null;
    }

    public void addJobMonitor(CyJobMonitor monitor, Map<?, ?> properties) {
        this.monitorMap.put(monitor.getClass().getCanonicalName(), monitor);
    }

    public void removeJobMonitor(CyJobMonitor monitor, Map<?, ?> properties) {
        String clazz = monitor.getClass().getCanonicalName();
        if (this.monitorMap.containsKey(clazz)) {
            this.monitorMap.remove(clazz);
        }
    }

    public void addExecutionService(CyJobExecutionService exService, Map<?, ?> properties) {
        this.exServiceMap.put(exService.getServiceName(), exService);
    }

    public void removeExecutionService(CyJobExecutionService exService, Map<?, ?> properties) {
        String clazz = exService.getServiceName();
        if (this.exServiceMap.containsKey(clazz)) {
            this.exServiceMap.remove(clazz);
        }
    }

    public void resetTimer() {
        this.pollTimer.cancel();
        this.pollTimer = new Timer("Job Status Poller", true);
    }

    public void handleEvent(SessionAboutToBeSavedEvent e) {
        this.resetTimer();
        String tmpDir = System.getProperty("java.io.tmpdir");
        ArrayList<File> jobFiles = new ArrayList<File>();
        for (CyJob job : this.jobsList) {
            File jobFile;
            CyJobExecutionService exService = job.getJobExecutionService();
            try {
                jobFile = new File(tmpDir, exService.getClass().getCanonicalName() + "_CyJob_" + job.getJobId());
                exService.saveJobInSession(job, jobFile);
            }
            catch (Exception ioe) {
                this.logger.error((Object)("Failed to save job " + job.getJobId() + " in session: " + ioe.getMessage()));
                continue;
            }
            jobFiles.add(jobFile);
        }
        if (jobFiles.size() > 0) {
            try {
                e.addAppFiles("CyJobs", jobFiles);
            }
            catch (Exception ioe) {
                this.logger.error((Object)("Failed to save jobs in session: " + ioe.getMessage()));
            }
        }
        if (this.jobsList.size() > 0) {
            this.pollTimer.schedule((TimerTask)new Poller(), 1000L);
        }
    }

    public void handleEvent(SessionLoadedEvent e) {
        this.resetTimer();
        CySession session = e.getLoadedSession();
        Map appFileList = session.getAppFileListMap();
        if (appFileList.containsKey("CyJobs")) {
            List jobFiles = (List)appFileList.get("CyJobs");
            for (File jobFile : jobFiles) {
                CyJob newJob;
                String name = jobFile.getName();
                String[] parts = name.split("_CyJob_");
                if (!this.exServiceMap.containsKey(parts[0]) || this.getJob((newJob = ((CyJobExecutionService)this.exServiceMap.get(parts[0])).restoreJobFromSession(session, jobFile)).getJobId()) != null) continue;
                this.addJob(newJob, null, -1);
            }
        }
    }

    class IntervalCounter {
        int currentInterval = 0;
        final int pollInterval;

        public IntervalCounter(int pollInterval) {
            this.pollInterval = pollInterval;
        }

        public boolean ready() {
            ++this.currentInterval;
            if (this.currentInterval >= this.pollInterval) {
                this.currentInterval = 0;
                return true;
            }
            return false;
        }
    }

    class Poller
    extends TimerTask {
        Poller() {
        }

        @Override
        public void run() {
            CyJobManagerImpl.this.resetTimer();
            ArrayList<CyJob> orphans = new ArrayList<CyJob>();
            for (CyJob job : CyJobManagerImpl.this.intervalMap.keySet()) {
                if (!((IntervalCounter)CyJobManagerImpl.this.intervalMap.get(job)).ready()) continue;
                CyJobStatus status = job.getJobExecutionService().checkJobStatus(job);
                if (CyJobManagerImpl.this.statusMap.containsKey(job) && ((CyJobStatus)CyJobManagerImpl.this.statusMap.get(job)).equals(status)) continue;
                if (CyJobManagerImpl.this.jobMonitorMap.containsKey(job)) {
                    ((CyJobMonitor)CyJobManagerImpl.this.jobMonitorMap.get(job)).jobStatusChanged(job, status);
                }
                if (status.isDone()) {
                    orphans.add(job);
                }
                CyJobManagerImpl.this.statusMap.put(job, status);
                CyJobManagerImpl.this.jobMonitor.jobStatusChanged(job, status);
            }
            for (CyJob job : orphans) {
                CyJobManagerImpl.this.removeJob(job);
            }
            if (CyJobManagerImpl.this.jobsList.size() > 0) {
                CyJobManagerImpl.this.pollTimer.schedule((TimerTask)new Poller(), 1000L);
            }
        }
    }
}

