/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.jobs.internal;

import java.util.Properties;
import org.cytoscape.jobs.CyJobExecutionService;
import org.cytoscape.jobs.CyJobManager;
import org.cytoscape.jobs.CyJobMonitor;
import org.cytoscape.jobs.internal.CyJobManagerImpl;
import org.cytoscape.jobs.internal.GUICyJobMonitor;
import org.cytoscape.jobs.internal.JobStatusBar;
import org.cytoscape.jobs.internal.SimpleCyJobMonitor;
import org.cytoscape.service.util.AbstractCyActivator;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.session.events.SessionAboutToBeSavedListener;
import org.cytoscape.session.events.SessionLoadedListener;
import org.cytoscape.work.TaskFactory;
import org.cytoscape.work.swing.StatusBarPanelFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class CyActivator
extends AbstractCyActivator {
    public void start(BundleContext bc) {
        CyServiceRegistrar serviceRegistrar = (CyServiceRegistrar)this.getService(bc, CyServiceRegistrar.class);
        ServiceReference ref = bc.getServiceReference("org.cytoscape.application.swing.CySwingApplication");
        CyJobManagerImpl jobManager = new CyJobManagerImpl();
        this.registerService(bc, jobManager, CyJobManager.class, new Properties());
        if (ref == null) {
            SimpleCyJobMonitor jobMonitor = new SimpleCyJobMonitor();
        } else {
            JobStatusBar statusBar = new JobStatusBar(serviceRegistrar);
            Properties statusBarProperties = new Properties();
            statusBarProperties.setProperty("type", "JobStatus");
            this.registerService(bc, statusBar, StatusBarPanelFactory.class, statusBarProperties);
            GUICyJobMonitor jobMonitor = new GUICyJobMonitor(serviceRegistrar, jobManager, statusBar);
            Properties guiJobProperties = new Properties();
            guiJobProperties.setProperty("title", "Job Status Monitor");
            guiJobProperties.setProperty("preferredMenu", "Tools");
            this.registerService(bc, (Object)jobMonitor, TaskFactory.class, guiJobProperties);
        }
        this.registerServiceListener(bc, jobManager::addJobMonitor, jobManager::removeJobMonitor, CyJobMonitor.class);
        this.registerServiceListener(bc, jobManager::addExecutionService, jobManager::removeExecutionService, CyJobExecutionService.class);
        this.registerService(bc, jobManager, SessionAboutToBeSavedListener.class, new Properties());
        this.registerService(bc, jobManager, SessionLoadedListener.class, new Properties());
    }
}

