/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.tableimport.internal.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.JarInputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;
import org.cytoscape.tableimport.internal.util.ProxyHandler;

public class URLUtil {
    private static final String GZIP = ".gz";
    private static final String ZIP = ".zip";
    private static final String JAR = ".jar";
    private static int msConnectionTimeout = 2000;

    public static InputStream getInputStream(URL source) throws IOException {
        InputStream proxyIs = URLUtil.getBasicInputStream(source);
        InputStream newIs = source.toString().toLowerCase().endsWith(GZIP) ? new GZIPInputStream(proxyIs) : (source.toString().toLowerCase().endsWith(ZIP) ? new ZipInputStream(proxyIs) : (source.toString().toLowerCase().endsWith(JAR) ? new JarInputStream(proxyIs) : proxyIs));
        return newIs;
    }

    public static InputStream getBasicInputStream(URL source) throws IOException {
        InputStream is;
        if (source == null) {
            throw new IllegalStateException("getBasicInputStream was given a null 'source' argument.");
        }
        URLConnection uc = URLUtil.getURLConnection(source);
        try {
            is = uc.getInputStream();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to get input stream for \"" + source + "\".");
        }
        return is;
    }

    public static URLConnection getURLConnection(URL source) throws IOException {
        if (source == null) {
            throw new IllegalStateException("getURLConnection was given a null 'source' argument.");
        }
        Proxy cytoProxy = ProxyHandler.getProxyServer();
        URLConnection uc = null;
        if (cytoProxy == null) {
            uc = source.openConnection();
        } else {
            try {
                uc = source.openConnection(cytoProxy);
            }
            catch (UnsupportedOperationException e) {
                uc = source.openConnection();
            }
        }
        uc.setUseCaches(false);
        uc.setConnectTimeout(msConnectionTimeout);
        return uc;
    }

    public static void download(String urlString, File downloadFile) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String download(URL source) throws IOException {
        StringBuffer buffer = new StringBuffer();
        try (InputStream is = null;){
            int c;
            is = URLUtil.getInputStream(source);
            while ((c = is.read()) != -1) {
                buffer.append((char)c);
            }
            is.close();
        }
        return buffer.toString();
    }

    public static boolean isValid(String urlCandidate) {
        try {
            new URL(urlCandidate);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }
}

