/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.tableimport.internal.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.xml.bind.JAXBException;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.io.read.InputStreamTaskFactory;
import org.cytoscape.property.CyProperty;
import org.cytoscape.property.bookmark.Attribute;
import org.cytoscape.property.bookmark.Bookmarks;
import org.cytoscape.property.bookmark.BookmarksUtil;
import org.cytoscape.property.bookmark.DataSource;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.tableimport.internal.task.ImportOntologyAndAnnotationTaskFactory;
import org.cytoscape.tableimport.internal.ui.DataSourceSelectDialog;
import org.cytoscape.tableimport.internal.ui.ImportTablePanel;
import org.cytoscape.tableimport.internal.ui.theme.ImportDialogIcons;
import org.cytoscape.work.swing.DialogTaskManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OntologyPanelBuilder {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private static final String GENE_ASSOCIATION = "gene_association";
    private static final String DEF_ANNOTATION_ITEM = "Please select an annotation data source...";
    private static final String annotationHtml = "<html><body bgcolor=\"white\"><p><strong><font size=\"+1\" face=\"serif\"><u>%DataSourceName%</u></font></strong></p><br><p><em>Annotation File URL</em>: <br><font color=\"blue\">%SourceURL%</font></p><br><p><em>Data Format</em>: <font color=\"green\">%Format%</font></p><br><p><em>Other Information</em>:<br><table width=\"300\" border=\"0\" cellspacing=\"3\" cellpadding=\"3\">%AttributeTable%</table></p></body></html>";
    private static final String ontologyHtml = "<html><body bgcolor=\"white\"><p><strong><font size=\"+1\" face=\"serif\"><u>%DataSourceName%</u></font></strong></p><br><p><em>Data Source URL</em>: <br><font color=\"blue\">%SourceURL%</font></p><br><p><em>Description</em>:<br><table width=\"300\" border=\"0\" cellspacing=\"3\" cellpadding=\"3\"><tr><td rowspan=\"1\" colspan=\"1\">%Description%</td></tr></table></p></body></html>";
    private final ImportTablePanel panel;
    private final InputStreamTaskFactory isTaskFactory;
    private final CyServiceRegistrar serviceRegistrar;
    private Map<String, String> annotationUrlMap;
    private Map<String, String> annotationFormatMap;
    private Map<String, Map<String, String>> annotationAttributesMap;
    private Map<String, String> ontologyUrlMap;
    private Map<String, String> ontologyTypeMap;
    private Map<String, String> ontologyDescriptionMap;

    OntologyPanelBuilder(ImportTablePanel panel, InputStreamTaskFactory isTaskFactory, CyServiceRegistrar serviceRegistrar) {
        this.panel = panel;
        this.isTaskFactory = isTaskFactory;
        this.serviceRegistrar = serviceRegistrar;
        this.annotationUrlMap = new HashMap<String, String>();
        this.annotationFormatMap = new HashMap<String, String>();
        this.annotationAttributesMap = new HashMap<String, Map<String, String>>();
        this.ontologyUrlMap = new HashMap<String, String>();
        this.ontologyDescriptionMap = new HashMap<String, String>();
        this.ontologyTypeMap = new HashMap<String, String>();
    }

    protected void buildPanel() {
        this.panel.getAdvancedButton().setEnabled(false);
        final ListCellRenderer<String> ontologyLcr = this.panel.ontologyComboBox.getRenderer();
        this.panel.ontologyComboBox.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel ontologyItem = (JLabel)ontologyLcr.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                String url = OntologyPanelBuilder.this.ontologyUrlMap.get(value);
                if (isSelected) {
                    ontologyItem.setBackground(list.getSelectionBackground());
                    ontologyItem.setForeground(list.getSelectionForeground());
                } else {
                    ontologyItem.setBackground(list.getBackground());
                    ontologyItem.setForeground(list.getForeground());
                }
                if (url != null && url.startsWith("http://")) {
                    ontologyItem.setIcon(ImportDialogIcons.REMOTE_SOURCE_ICON.getIcon());
                } else {
                    ontologyItem.setIcon(ImportDialogIcons.LOCAL_SOURCE_ICON.getIcon());
                }
                return ontologyItem;
            }
        });
        this.panel.ontologyComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OntologyPanelBuilder.this.ontologyComboBoxActionPerformed(evt);
            }
        });
        this.panel.browseOntologyButton.setToolTipText("Browse local ontology file...");
        this.panel.browseOntologyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OntologyPanelBuilder.this.browseOntologyButtonActionPerformed(evt);
            }
        });
        this.panel.annotationComboBox.setName("annotationComboBox");
        final ListCellRenderer<String> lcr = this.panel.annotationComboBox.getRenderer();
        this.panel.annotationComboBox.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel cmp = (JLabel)lcr.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                String url = OntologyPanelBuilder.this.annotationUrlMap.get(value);
                if (value == null) {
                    cmp.setIcon(null);
                } else if (value.toString().equals(OntologyPanelBuilder.DEF_ANNOTATION_ITEM)) {
                    cmp.setIcon(null);
                } else if (url != null && url.startsWith("http://")) {
                    cmp.setIcon(ImportDialogIcons.REMOTE_SOURCE_ICON.getIcon());
                } else {
                    cmp.setIcon(ImportDialogIcons.LOCAL_SOURCE_ICON.getIcon());
                }
                return cmp;
            }
        });
        this.panel.annotationComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OntologyPanelBuilder.this.annotationComboBoxActionPerformed(evt);
            }
        });
        this.panel.browseAnnotationButton.setToolTipText("Browse local annotation file...");
        this.panel.browseAnnotationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OntologyPanelBuilder.this.browseAnnotationButtonActionPerformed(evt);
            }
        });
    }

    private void ontologyComboBoxActionPerformed(ActionEvent evt) {
        this.panel.ontologyComboBox.setToolTipText(this.getOntologyTooltip());
    }

    private String getOntologyTooltip() {
        String key = this.panel.ontologyComboBox.getSelectedItem().toString();
        String tooltip = ontologyHtml.replace("%DataSourceName%", key);
        String description = this.ontologyDescriptionMap.get(key);
        tooltip = description == null ? tooltip.replace("%Description%", "N/A") : tooltip.replace("%Description%", description);
        if (this.ontologyUrlMap.get(key) != null) {
            return tooltip.replace("%SourceURL%", this.ontologyUrlMap.get(key));
        }
        return tooltip.replace("%SourceURL%", "N/A");
    }

    private void annotationComboBoxActionPerformed(ActionEvent evt) {
        if (this.panel.annotationComboBox.getSelectedItem().toString().equals(DEF_ANNOTATION_ITEM)) {
            this.panel.annotationComboBox.setToolTipText(null);
            this.panel.getAdvancedButton().setEnabled(false);
            return;
        }
        this.panel.annotationComboBox.setToolTipText(this.getAnnotationTooltip());
        this.panel.getAdvancedButton().setEnabled(true);
        try {
            String selectedSourceName = this.panel.annotationComboBox.getSelectedItem().toString();
            URL sourceURL = new URL(this.annotationUrlMap.get(selectedSourceName));
            this.panel.readAnnotationForPreviewOntology(sourceURL, this.panel.checkDelimiter());
        }
        catch (IOException e) {
            logger.error("Could not create preview.", (Throwable)e);
        }
    }

    private String getAnnotationTooltip() {
        String key = this.panel.annotationComboBox.getSelectedItem().toString();
        String tooltip = annotationHtml.replace("%DataSourceName%", key);
        if (this.annotationUrlMap.get(key) == null) {
            return "";
        }
        tooltip = tooltip.replace("%SourceURL%", this.annotationUrlMap.get(key));
        if (this.annotationFormatMap.get(key) != null) {
            tooltip = tooltip.replace("%Format%", this.annotationFormatMap.get(key));
        } else {
            String[] parts = this.annotationUrlMap.get(key).split("/");
            if (parts[parts.length - 1].startsWith(GENE_ASSOCIATION)) {
                tooltip = tooltip.replace("%Format%", "Gene Association");
            }
            tooltip = tooltip.replace("%Format%", "General Annotation Text Table");
        }
        if (this.annotationAttributesMap.get(key) != null) {
            StringBuffer table = new StringBuffer();
            Map<String, String> annotations = this.annotationAttributesMap.get(key);
            for (String anno : annotations.keySet()) {
                table.append("<tr>");
                table.append("<td><strong>" + anno + "</strong></td><td>" + annotations.get(anno) + "</td>");
                table.append("</tr>");
            }
            return tooltip.replace("%AttributeTable%", table.toString());
        }
        return tooltip.replace("%AttributeTable%", "");
    }

    private void browseAnnotationButtonActionPerformed(ActionEvent evt) {
        JFrame parentFrame = ((CySwingApplication)this.serviceRegistrar.getService(CySwingApplication.class)).getJFrame();
        DataSourceSelectDialog dssd = new DataSourceSelectDialog(1, parentFrame, Dialog.ModalityType.APPLICATION_MODAL, this.serviceRegistrar);
        dssd.setLocationRelativeTo(parentFrame);
        dssd.setVisible(true);
        String key = dssd.getSourceName();
        if (key != null) {
            this.panel.annotationComboBox.addItem(key);
            this.annotationUrlMap.put(key, dssd.getSourceUrlString());
            this.panel.annotationComboBox.setSelectedItem(key);
            this.panel.annotationComboBox.setToolTipText(this.getAnnotationTooltip());
        }
    }

    private void browseOntologyButtonActionPerformed(ActionEvent evt) {
        JFrame parentFrame = ((CySwingApplication)this.serviceRegistrar.getService(CySwingApplication.class)).getJFrame();
        DataSourceSelectDialog dssd = new DataSourceSelectDialog(2, parentFrame, Dialog.ModalityType.APPLICATION_MODAL, this.serviceRegistrar);
        dssd.setLocationRelativeTo(parentFrame);
        dssd.setVisible(true);
        String key = dssd.getSourceName();
        if (key != null) {
            this.panel.ontologyComboBox.insertItemAt(key, 0);
            this.ontologyUrlMap.put(key, dssd.getSourceUrlString());
            this.panel.ontologyComboBox.setSelectedItem(key);
            this.panel.ontologyComboBox.setToolTipText(this.getOntologyTooltip());
        }
    }

    protected void setOntologyComboBox() {
        CyProperty bookmarksProp = (CyProperty)this.serviceRegistrar.getService(CyProperty.class, "(cyPropertyName=bookmarks)");
        BookmarksUtil bkUtil = (BookmarksUtil)this.serviceRegistrar.getService(BookmarksUtil.class);
        Bookmarks bookmarks = (Bookmarks)bookmarksProp.getProperties();
        List annotations = bkUtil.getDataSourceList("ontology", bookmarks.getCategory());
        String key = null;
        for (DataSource source : annotations) {
            key = source.getName();
            this.panel.ontologyComboBox.addItem(key);
            this.ontologyUrlMap.put(key, source.getHref());
            this.ontologyDescriptionMap.put(key, bkUtil.getAttribute(source, "description"));
            this.ontologyTypeMap.put(key, bkUtil.getAttribute(source, "ontologyType"));
        }
        this.panel.ontologyComboBox.setToolTipText(this.getOntologyTooltip());
    }

    protected void setAnnotationComboBox() throws JAXBException, IOException {
        CyProperty bookmarksProp = (CyProperty)this.serviceRegistrar.getService(CyProperty.class, "(cyPropertyName=bookmarks)");
        BookmarksUtil bkUtil = (BookmarksUtil)this.serviceRegistrar.getService(BookmarksUtil.class);
        Bookmarks bookmarks = (Bookmarks)bookmarksProp.getProperties();
        List annotations = bkUtil.getDataSourceList("annotation", bookmarks.getCategory());
        String key = null;
        this.panel.annotationComboBox.addItem(DEF_ANNOTATION_ITEM);
        for (DataSource source : annotations) {
            key = source.getName();
            this.panel.annotationComboBox.addItem(key);
            this.annotationUrlMap.put(key, source.getHref());
            this.annotationFormatMap.put(key, source.getFormat());
            HashMap<String, String> attrMap = new HashMap<String, String>();
            for (Attribute attr : source.getAttribute()) {
                attrMap.put(attr.getName(), attr.getContent());
            }
            this.annotationAttributesMap.put(key, attrMap);
        }
        this.panel.annotationComboBox.setToolTipText(this.getAnnotationTooltip());
    }

    private void loadOntology(String dataSource, String ontologyName, String annotationSource) throws IOException {
        URL url = new URL(dataSource);
        URL annotationSourceUrl = new URL(annotationSource);
        InputStream is = null;
        is = annotationSourceUrl.toString().endsWith("gz") ? new GZIPInputStream(annotationSourceUrl.openStream()) : annotationSourceUrl.openStream();
        ImportOntologyAndAnnotationTaskFactory taskFactory = new ImportOntologyAndAnnotationTaskFactory(this.isTaskFactory, url.openStream(), ontologyName, is, annotationSource, this.serviceRegistrar);
        ((DialogTaskManager)this.serviceRegistrar.getService(DialogTaskManager.class)).execute(taskFactory.createTaskIterator());
    }

    protected void importOntologyAndAnnotation() throws IOException {
        String selectedOntologyName = this.panel.ontologyComboBox.getSelectedItem().toString();
        String ontologySourceLocation = this.ontologyUrlMap.get(selectedOntologyName);
        String annotationSource = this.annotationUrlMap.get(this.panel.annotationComboBox.getSelectedItem());
        this.loadOntology(ontologySourceLocation, selectedOntologyName, annotationSource);
    }
}

