/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.tableimport.internal.tunable;

import java.awt.BorderLayout;
import java.awt.Component;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.tableimport.internal.reader.NetworkTableMappingParameters;
import org.cytoscape.tableimport.internal.task.TableImportContext;
import org.cytoscape.tableimport.internal.ui.ImportTablePanel;
import org.cytoscape.tableimport.internal.util.ImportType;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.swing.AbstractGUITunableHandler;

public class NetworkTableMappingParametersHandler
extends AbstractGUITunableHandler {
    private final TableImportContext tableImportContext;
    private final ImportType dialogType;
    private final CyServiceRegistrar serviceRegistrar;
    private ImportTablePanel importTablePanel;
    private NetworkTableMappingParameters ntmp;

    protected NetworkTableMappingParametersHandler(Field field, Object instance, Tunable tunable, ImportType dialogType, TableImportContext tableImportContext, CyServiceRegistrar serviceRegistrar) {
        super(field, instance, tunable);
        this.dialogType = dialogType;
        this.tableImportContext = tableImportContext;
        this.serviceRegistrar = serviceRegistrar;
        this.init();
    }

    protected NetworkTableMappingParametersHandler(Method getter, Method setter, Object instance, Tunable tunable, ImportType dialogType, TableImportContext tableImportContext, CyServiceRegistrar serviceRegistrar) {
        super(getter, setter, instance, tunable);
        this.dialogType = dialogType;
        this.tableImportContext = tableImportContext;
        this.serviceRegistrar = serviceRegistrar;
        this.init();
    }

    private void init() {
        try {
            this.ntmp = (NetworkTableMappingParameters)this.getValue();
        }
        catch (IllegalAccessException e1) {
            e1.printStackTrace();
        }
        catch (InvocationTargetException e1) {
            e1.printStackTrace();
        }
        this.panel = new JPanel(new BorderLayout());
        try {
            this.importTablePanel = new ImportTablePanel(this.dialogType, this.ntmp.is, this.ntmp.fileType, null, this.tableImportContext, this.serviceRegistrar);
        }
        catch (Exception e) {
            JLabel errorLabel = new JLabel("<html><h3>Error: Could not Initialize Preview.</h3><p>The selected file may be empty or contain invalid entries.<br>Please check the contents of the original file and try again.</p></html>");
            errorLabel.setForeground(LookAndFeelUtil.getErrorColor());
            errorLabel.setHorizontalTextPosition(0);
            errorLabel.setHorizontalAlignment(0);
            errorLabel.setFont(errorLabel.getFont().deriveFont(LookAndFeelUtil.getSmallFontSize()));
            this.panel.add((Component)errorLabel, "Center");
            return;
        }
        this.panel.add((Component)this.importTablePanel, "Center");
    }

    public void handle() {
        try {
            if (this.importTablePanel != null) {
                this.ntmp = this.importTablePanel.getNetworkTableMappingParameters();
                this.setValue(this.ntmp);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

