/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.tableimport.internal.task;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.cytoscape.io.util.StreamUtil;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.tableimport.internal.task.LoadNetworkReaderTask;
import org.cytoscape.tableimport.internal.task.LoadTableReaderTask;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectURLTableTask
extends AbstractTask {
    @Tunable(description="Data Table URL", longDescription="The URL of the file or resource that provides the table or network to be imported.", exampleStringValue="https://www.my.domain.org/mywebpage/myFile.csv", params="fileCategory=table;input=true", required=true, gravity=0.0)
    public URL url;
    private LoadTableReaderTask tableReader;
    private LoadNetworkReaderTask networkReader;
    private InputStream stream;
    private final CyServiceRegistrar serviceRegistrar;
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");

    public SelectURLTableTask(Task readerTask, CyServiceRegistrar serviceRegistrar) {
        if (readerTask instanceof LoadTableReaderTask) {
            this.tableReader = (LoadTableReaderTask)readerTask;
            this.networkReader = null;
        }
        if (readerTask instanceof LoadNetworkReaderTask) {
            this.tableReader = null;
            this.networkReader = (LoadNetworkReaderTask)readerTask;
        }
        this.serviceRegistrar = serviceRegistrar;
    }

    public void run(TaskMonitor tm) throws Exception {
        try {
            this.stream = ((StreamUtil)this.serviceRegistrar.getService(StreamUtil.class)).getInputStream(this.url.toURI().toURL());
        }
        catch (IOException e) {
            logger.warn("Error opening stream to URI: " + this.url.toString(), (Throwable)e);
        }
        String fileFormat = this.url.toURI().toString().substring(this.url.toURI().toString().lastIndexOf(46));
        if (this.tableReader != null) {
            this.tableReader.setInputFile(this.stream, fileFormat, this.url.toURI().toString());
        }
        if (this.networkReader != null) {
            this.networkReader.setInputFile(this.stream, fileFormat, this.url.toURI().toString(), this.url.toURI(), (IconManager)this.serviceRegistrar.getService(IconManager.class));
        }
    }
}

