/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.tableimport.internal.task;

import java.util.List;
import java.util.Set;
import org.cytoscape.io.read.CyTableReader;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;

public class MapGeneAssociationTask
extends AbstractTask {
    private static final String MAPPING_KEY = "mapping key";
    private final CyTableReader tableReader;
    private final CyServiceRegistrar serviceRegistrar;

    MapGeneAssociationTask(CyTableReader tableReader, CyServiceRegistrar serviceRegistrar) {
        this.tableReader = tableReader;
        this.serviceRegistrar = serviceRegistrar;
    }

    public void run(TaskMonitor tm) throws Exception {
        tm.setTitle("Mapping Global Gene Association Table to Local Network Tabels");
        tm.setStatusMessage("Mapping global colums to local...");
        CyTable[] tables = this.tableReader.getTables();
        if (tables == null || tables[0] == null) {
            throw new NullPointerException("Could not find table.");
        }
        ((CyTableManager)this.serviceRegistrar.getService(CyTableManager.class)).addTable(tables[0]);
        this.mapping(tm, tables[0]);
        tm.setProgress(1.0);
    }

    private void mapping(TaskMonitor taskMonitor, CyTable globalTable) {
        taskMonitor.setProgress(0.0);
        Set networks = ((CyNetworkManager)this.serviceRegistrar.getService(CyNetworkManager.class)).getNetworkSet();
        if (networks.isEmpty()) {
            return;
        }
        int networkCount = 1;
        double increment = 1.0 / (double)networks.size();
        double progress = 0.0;
        for (CyNetwork network : networks) {
            taskMonitor.setStatusMessage("Mapping networks " + networkCount + "/" + networks.size());
            CyTable networkTable = network.getDefaultNetworkTable();
            Boolean isDag = (Boolean)networkTable.getRow((Object)network.getSUID()).get("Ontology DAG", Boolean.class);
            if (isDag == null || !isDag.booleanValue()) {
                this.buildMapping(network, network.getDefaultNodeTable(), globalTable);
            }
            ++networkCount;
            taskMonitor.setProgress(progress += increment);
        }
    }

    private void buildMapping(CyNetwork network, CyTable nodeTable, CyTable globalTable) {
        List globalKeys = globalTable.getColumn("name").getValues(String.class);
        if (nodeTable.getColumn(MAPPING_KEY) == null) {
            nodeTable.createColumn(MAPPING_KEY, String.class, true);
        }
        block0: for (CyNode node : network.getNodeList()) {
            String nodeName = (String)network.getRow((CyIdentifiable)node).get("name", String.class);
            for (String key : globalKeys) {
                CyRow curRow = globalTable.getRow((Object)key);
                if (!curRow.getList("Synonym", String.class).contains(nodeName)) continue;
                CyRow nodeTableRow = nodeTable.getRow((Object)node.getSUID());
                nodeTableRow.set(MAPPING_KEY, (Object)key);
                continue block0;
            }
        }
        nodeTable.addVirtualColumns(globalTable, MAPPING_KEY, true);
    }
}

