/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.tableimport.internal.task;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.cytoscape.io.read.CyTableReader;
import org.cytoscape.io.read.CyTableReaderManager;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.tableimport.internal.task.CombineTableReaderAndMappingTask;
import org.cytoscape.tableimport.internal.task.LoadTableURLTask;
import org.cytoscape.tableimport.internal.task.TableImportContext;
import org.cytoscape.task.read.LoadTableURLTaskFactory;
import org.cytoscape.work.AbstractTaskFactory;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;

public class LoadTableURLTaskFactoryImpl
extends AbstractTaskFactory
implements LoadTableURLTaskFactory {
    private final TableImportContext tableImportContext;
    private final CyServiceRegistrar serviceRegistrar;

    public LoadTableURLTaskFactoryImpl(TableImportContext tableImportContext, CyServiceRegistrar serviceRegistrar) {
        this.tableImportContext = tableImportContext;
        this.serviceRegistrar = serviceRegistrar;
    }

    public TaskIterator createTaskIterator() {
        return new TaskIterator(2, new Task[]{new LoadTableURLTask(this.tableImportContext, this.serviceRegistrar)});
    }

    public TaskIterator createTaskIterator(URL url) {
        URI uri = null;
        try {
            uri = url.toURI();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        CyTableReaderManager tableReaderMgr = (CyTableReaderManager)this.serviceRegistrar.getService(CyTableReaderManager.class);
        CyTableReader reader = tableReaderMgr.getReader(uri, uri.toString());
        return new TaskIterator(new Task[]{new CombineTableReaderAndMappingTask(reader, this.tableImportContext, this.serviceRegistrar)});
    }
}

