/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.tableimport.internal.task;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.cytoscape.io.read.CyNetworkReader;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.tableimport.internal.reader.ExcelNetworkSheetReader;
import org.cytoscape.tableimport.internal.reader.GraphReader;
import org.cytoscape.tableimport.internal.reader.NetworkTableMappingParameters;
import org.cytoscape.tableimport.internal.reader.NetworkTableReader;
import org.cytoscape.tableimport.internal.reader.SupportedFileType;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewFactory;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.TunableValidator;

public class ImportNetworkTableReaderTask
extends AbstractTask
implements CyNetworkReader,
TunableValidator {
    private InputStream is;
    private final String fileType;
    private CyNetwork[] networks;
    private final String inputName;
    private GraphReader reader;
    @Tunable(description="Network Table Mapping Parameter:")
    public NetworkTableMappingParameters ntmp;
    private CyRootNetwork rootNetwork;
    private Map<Object, CyNode> nMap;
    private CyNetworkViewFactory networkViewFactory;
    private final CyServiceRegistrar serviceRegistrar;

    public ImportNetworkTableReaderTask(InputStream is, String fileType, String inputName, CyServiceRegistrar serviceRegistrar) {
        this.is = is;
        this.fileType = fileType;
        this.inputName = inputName;
        this.serviceRegistrar = serviceRegistrar;
        try {
            File tempFile = File.createTempFile("temp", this.fileType);
            tempFile.deleteOnExit();
            FileOutputStream os = new FileOutputStream(tempFile);
            int read = 0;
            byte[] bytes = new byte[1024];
            while ((read = is.read(bytes)) != -1) {
                os.write(bytes, 0, read);
            }
            os.flush();
            os.close();
            try {
                is.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ntmp = new NetworkTableMappingParameters(new FileInputStream(tempFile), fileType);
            this.is = new FileInputStream(tempFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void run(TaskMonitor tm) throws Exception {
        tm.setTitle("Loading network from table");
        tm.setProgress(0.0);
        tm.setStatusMessage("Loading network...");
        Workbook workbook = null;
        if (this.fileType != null && (this.fileType.equalsIgnoreCase(SupportedFileType.EXCEL.getExtension()) || this.fileType.equalsIgnoreCase(SupportedFileType.OOXML.getExtension())) && workbook == null) {
            try {
                workbook = WorkbookFactory.create((InputStream)this.is);
            }
            catch (InvalidFormatException e) {
                throw new IllegalArgumentException("Could not read Excel file.  Maybe the file is broken?", e);
            }
            finally {
                if (this.is != null) {
                    this.is.close();
                }
            }
        }
        try {
            if (this.fileType.equalsIgnoreCase(SupportedFileType.EXCEL.getExtension()) || this.fileType.equalsIgnoreCase(SupportedFileType.OOXML.getExtension())) {
                String networkName = this.ntmp.getName();
                if (networkName == null) {
                    networkName = workbook.getSheetName(0);
                }
                Sheet sheet = workbook.getSheet(networkName);
                this.reader = new ExcelNetworkSheetReader(networkName, sheet, this.ntmp, this.nMap, this.rootNetwork, this.serviceRegistrar);
            } else {
                this.reader = new NetworkTableReader(this.inputName, this.is, this.ntmp, this.nMap, this.rootNetwork, this.serviceRegistrar);
            }
        }
        catch (Exception ioe) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Unable to read table: " + ioe.getMessage());
            return;
        }
        this.loadNetwork(tm);
        tm.setProgress(1.0);
    }

    private void loadNetwork(TaskMonitor tm) throws IOException {
        CySubNetwork network = this.rootNetwork.addSubNetwork();
        tm.setProgress(0.1);
        this.reader.setNetwork((CyNetwork)network);
        if (this.cancelled) {
            return;
        }
        this.reader.read();
        tm.setProgress(0.8);
        if (this.cancelled) {
            return;
        }
        this.networks = new CyNetwork[]{network};
        tm.setProgress(1.0);
    }

    public CyNetworkView buildCyNetworkView(CyNetwork net) {
        CyNetworkView view = this.networkViewFactory.createNetworkView(net);
        return view;
    }

    public CyNetwork[] getNetworks() {
        return this.networks;
    }

    public TunableValidator.ValidationState getValidationState(Appendable errMsg) {
        if (this.ntmp == null) {
            return TunableValidator.ValidationState.INVALID;
        }
        try {
            if (this.ntmp.getSourceIndex() == -1) {
                if (this.ntmp.getTargetIndex() == -1) {
                    errMsg.append("The network cannot be created without selecting the source and target columns.");
                    return TunableValidator.ValidationState.INVALID;
                }
                errMsg.append("No edges will be created in the network; the target column is not selected.\nDo you want to continue?");
                return TunableValidator.ValidationState.REQUEST_CONFIRMATION;
            }
            if (this.ntmp.getTargetIndex() == -1) {
                errMsg.append("No edges will be created in the network; the source column is not selected.\nDo you want to continue?");
                return TunableValidator.ValidationState.REQUEST_CONFIRMATION;
            }
            return TunableValidator.ValidationState.OK;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return TunableValidator.ValidationState.INVALID;
        }
    }

    public void setRootNetwork(CyRootNetwork rootNetwork) {
        this.rootNetwork = rootNetwork;
    }

    public void setNodeMap(Map<Object, CyNode> nMap) {
        this.nMap = nMap;
    }

    public void setNetworkViewFactory(CyNetworkViewFactory networkViewFactory) {
        this.networkViewFactory = networkViewFactory;
    }
}

