/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.tableimport.internal.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.cytoscape.tableimport.internal.reader.TextDelimiter;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.util.ListMultipleSelection;
import org.cytoscape.work.util.ListSelection;

public class DelimitersTunable {
    @Tunable(description="Text delimiters", longDescription="Select the delimiters to use to separate columns in the table, from the list '``,``',' ','``TAB``', or '``;``'.  ``TAB`` and '``,``' are used by default", exampleStringValue=";,\\,", context="both")
    public ListMultipleSelection<String> delimiters;
    static String[] defaults = new String[]{TextDelimiter.TAB.getDelimiter(), TextDelimiter.COMMA.getDelimiter()};

    public DelimitersTunable() {
        List<String> values = Arrays.asList(TextDelimiter.COMMA.getDelimiter(), TextDelimiter.SEMICOLON.getDelimiter(), TextDelimiter.SPACE.getDelimiter(), TextDelimiter.TAB.getDelimiter(), "\t");
        this.delimiters = new ListMultipleSelection(values);
        this.delimiters.setSelectedValues(Arrays.asList(defaults));
    }

    public void setSelectedValues(List<TextDelimiter> values) {
        List strVaues = values.stream().map(TextDelimiter::getDelimiter).collect(Collectors.toList());
        this.delimiters.setSelectedValues(strVaues);
    }

    public List<String> getSelectedValues() {
        HashSet<String> values = new HashSet<String>(this.delimiters.getSelectedValues());
        if (values.remove("\t")) {
            values.add(TextDelimiter.TAB.getDelimiter());
        }
        return new ArrayList<String>(values);
    }

    ListSelection<String> getTunable() {
        return this.delimiters;
    }
}

