/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.tableimport.internal.reader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.tableimport.internal.reader.AbstractGraphReader;
import org.cytoscape.tableimport.internal.reader.MappingParameter;
import org.cytoscape.tableimport.internal.reader.NetworkLineParser;
import org.cytoscape.tableimport.internal.reader.NetworkTableMappingParameters;
import org.cytoscape.tableimport.internal.reader.TextTableReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkTableReader
extends AbstractGraphReader
implements TextTableReader {
    protected static final String COMMENT_CHAR = "!";
    protected final NetworkTableMappingParameters mapping;
    protected final NetworkLineParser parser;
    protected final List<Long> nodeList;
    protected final List<Long> edgeList;
    protected final int startLineNumber;
    protected final String commentChar;
    protected final InputStream is;
    protected CyNetwork network;
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");

    public NetworkTableReader(String networkName, InputStream is, NetworkTableMappingParameters mapping, Map<Object, CyNode> nMap, CyRootNetwork rootNetwork, CyServiceRegistrar serviceRegistrar) {
        super(networkName, serviceRegistrar);
        this.is = is;
        this.mapping = mapping;
        this.startLineNumber = mapping.getStartLineNumber();
        this.nodeList = new ArrayList<Long>();
        this.edgeList = new ArrayList<Long>();
        this.commentChar = mapping.getCommentChar();
        this.parser = new NetworkLineParser(this.nodeList, this.edgeList, mapping, nMap, rootNetwork, serviceRegistrar);
    }

    @Override
    public List<String> getColumnNames() {
        return Arrays.asList(this.mapping.getAttributeNames());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readTable(CyTable table) throws IOException {
        this.network.getRow((CyIdentifiable)this.network).set("name", (Object)this.getNetworkName());
        this.parser.setNetwork(this.network);
        try (BufferedReader bufRd = null;){
            String line;
            bufRd = new BufferedReader(new InputStreamReader(this.is, Charset.forName("UTF-8").newDecoder()));
            int lineCount = 0;
            int skipped = 0;
            while ((line = bufRd.readLine()) != null) {
                if (this.commentChar != null && this.commentChar.trim().length() != 0 && line.startsWith(this.commentChar)) {
                    ++skipped;
                } else if (line.trim().length() > 0 && this.startLineNumber + skipped <= lineCount) {
                    String[] parts = line.split(this.mapping.getDelimiterRegEx());
                    try {
                        this.parser.parseEntry(parts);
                    }
                    catch (Exception ex) {
                        logger.warn("Couldn't parse row: " + lineCount, (Throwable)ex);
                    }
                }
                ++lineCount;
            }
        }
        finally {
            if (this.is != null) {
                this.is.close();
            }
        }
    }

    @Override
    public void read() throws IOException {
        this.readTable(null);
    }

    @Override
    public String getReport() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.network.getNodeCount() + " nodes and " + this.network.getEdgeCount() + " edges are loaded.\n");
        sb.append("New network name is " + super.getNetworkName() + "\n\n");
        return sb.toString();
    }

    @Override
    public void setNetwork(CyNetwork network) {
        this.network = network;
    }

    @Override
    public MappingParameter getMappingParameter() {
        return this.mapping;
    }
}

