/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.tableimport.internal.reader;

import java.io.IOException;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.tableimport.internal.reader.NetworkTableMappingParameters;
import org.cytoscape.tableimport.internal.reader.NetworkTableReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelNetworkSheetReader
extends NetworkTableReader {
    private final Sheet sheet;
    private final DataFormatter formatter;
    private final FormulaEvaluator evaluator;
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");

    public ExcelNetworkSheetReader(String networkName, Sheet sheet, NetworkTableMappingParameters nmp, Map<Object, CyNode> nMap, CyRootNetwork rootNetwork, CyServiceRegistrar serviceRegistrar) {
        super(networkName, null, nmp, nMap, rootNetwork, serviceRegistrar);
        this.sheet = sheet;
        this.evaluator = sheet.getWorkbook().getCreationHelper().createFormulaEvaluator();
        this.formatter = new DataFormatter();
    }

    @Override
    public void readTable(CyTable table) throws IOException {
        Row row;
        this.network.getRow((CyIdentifiable)this.network).set("name", (Object)this.getNetworkName());
        this.parser.setNetwork(this.network);
        int rowCount = this.startLineNumber;
        while ((row = this.sheet.getRow(rowCount)) != null) {
            String[] cellsInOneRow = this.createElementStringArray(row);
            try {
                this.parser.parseEntry(cellsInOneRow);
            }
            catch (Exception e) {
                logger.warn("Couldn't parse row: " + rowCount, (Throwable)e);
            }
            ++rowCount;
        }
    }

    private String[] createElementStringArray(Row row) {
        if (this.mapping.getColumnCount() == -1) {
            return null;
        }
        String[] cells = new String[this.mapping.getColumnCount()];
        for (int i = 0; i < this.mapping.getColumnCount(); i = (int)((short)(i + 1))) {
            Cell cell = row.getCell(i);
            cells[i] = cell == null || cell.getCellType() == 5 || cell.getCellType() == 2 && cell.getCachedFormulaResultType() == 5 ? null : this.formatter.formatCellValue(cell, this.evaluator);
        }
        return cells;
    }
}

