/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.sbml.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.HashMap;
import org.cytoscape.io.read.CyNetworkReader;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkFactory;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewFactory;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;
import org.sbml.jsbml.JSBML;
import org.sbml.jsbml.KineticLaw;
import org.sbml.jsbml.LocalParameter;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.ModifierSpeciesReference;
import org.sbml.jsbml.Reaction;
import org.sbml.jsbml.SBMLDocument;
import org.sbml.jsbml.Species;
import org.sbml.jsbml.SpeciesReference;

public class SBMLNetworkViewReader
extends AbstractTask
implements CyNetworkReader {
    private static final int BUFFER_SIZE = 16384;
    static final String NODE_NAME_ATTR_LABEL = "name";
    static final String INTERACTION_TYPE_ATTR = "interaction type";
    static final String SBML_TYPE_ATTR = "sbml type";
    static final String SBML_ID_ATTR = "sbml id";
    static final String SBML_INITIAL_CONCENTRATION_ATTR = "sbml initial concentration";
    static final String SBML_INITIAL_AMOUNT_ATTR = "sbml initial amount";
    static final String SBML_CHARGE_ATTR = "sbml charge";
    static final String SBML_COMPARTMENT_ATTR = "sbml compartment";
    static final String SBML_TYPE_SPECIES = "species";
    static final String SBML_TYPE_REACTION = "reaction";
    static final String INTERACTION_TYPE_REACTION_PRODUCT = "reaction-product";
    static final String INTERACTION_TYPE_REACTION_REACTANT = "reaction-reactant";
    static final String INTERACTION_TYPE_REACTION_MODIFIER = "reaction-modifier";
    static final String KINETIC_LAW_ATTR_TEMPLATE = "kineticLaw-%1$s";
    static final String KINETIC_LAW_UNITS_ATTR_TEMPLATE = "kineticLaw-%1$s-units";
    private final InputStream stream;
    private final CyNetworkFactory networkFactory;
    private final CyNetworkViewFactory viewFactory;
    private CyNetwork network;

    public SBMLNetworkViewReader(InputStream stream, CyNetworkFactory networkFactory, CyNetworkViewFactory viewFactory) {
        this.stream = stream;
        this.networkFactory = networkFactory;
        this.viewFactory = viewFactory;
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        String xml = SBMLNetworkViewReader.readString(this.stream);
        SBMLDocument document = JSBML.readSBMLFromString((String)xml);
        this.network = this.networkFactory.createNetwork();
        Model model = document.getModel();
        HashMap<String, CyNode> speciesById = new HashMap<String, CyNode>();
        for (Species species : model.getListOfSpecies()) {
            CyNode node = this.network.addNode();
            speciesById.put(species.getId(), node);
            CyRow attributes = this.network.getRow((CyIdentifiable)node);
            this.checkNodeSchema(attributes);
            attributes.set(NODE_NAME_ATTR_LABEL, (Object)species.getName());
            attributes.set(SBML_TYPE_ATTR, (Object)SBML_TYPE_SPECIES);
            attributes.set(SBML_ID_ATTR, (Object)species.getId());
            attributes.set(SBML_INITIAL_CONCENTRATION_ATTR, (Object)species.getInitialConcentration());
            attributes.set(SBML_INITIAL_AMOUNT_ATTR, (Object)species.getInitialAmount());
            attributes.set(SBML_CHARGE_ATTR, (Object)species.getCharge());
            String compartment = species.getCompartment();
            if (compartment == null) continue;
            attributes.set(SBML_COMPARTMENT_ATTR, (Object)compartment);
        }
        HashMap<String, CyNode> reactionsById = new HashMap<String, CyNode>();
        for (Reaction reaction : model.getListOfReactions()) {
            CyRow edgeAttributes;
            CyEdge edge;
            CyNode sourceNode;
            CyNode node = this.network.addNode();
            reactionsById.put(reaction.getId(), node);
            CyRow attributes = this.network.getRow((CyIdentifiable)node);
            this.checkNodeSchema(attributes);
            String name = reaction.getName();
            if (name == null) {
                attributes.set(NODE_NAME_ATTR_LABEL, (Object)reaction.getId());
            } else {
                attributes.set(NODE_NAME_ATTR_LABEL, (Object)name);
            }
            attributes.set(SBML_TYPE_ATTR, (Object)SBML_TYPE_REACTION);
            attributes.set(SBML_ID_ATTR, (Object)reaction.getId());
            for (SpeciesReference product : reaction.getListOfProducts()) {
                sourceNode = (CyNode)speciesById.get(product.getSpecies());
                edge = this.network.addEdge(sourceNode, node, true);
                edgeAttributes = this.network.getRow((CyIdentifiable)edge);
                this.checkEdgeSchema(edgeAttributes);
                edgeAttributes.set(INTERACTION_TYPE_ATTR, (Object)INTERACTION_TYPE_REACTION_PRODUCT);
            }
            for (SpeciesReference reactant : reaction.getListOfReactants()) {
                sourceNode = (CyNode)speciesById.get(reactant.getSpecies());
                edge = this.network.addEdge(sourceNode, node, true);
                edgeAttributes = this.network.getRow((CyIdentifiable)edge);
                this.checkEdgeSchema(edgeAttributes);
                edgeAttributes.set(INTERACTION_TYPE_ATTR, (Object)INTERACTION_TYPE_REACTION_REACTANT);
            }
            for (ModifierSpeciesReference modifier : reaction.getListOfModifiers()) {
                sourceNode = (CyNode)speciesById.get(modifier.getSpecies());
                edge = this.network.addEdge(sourceNode, node, true);
                edgeAttributes = this.network.getRow((CyIdentifiable)edge);
                this.checkEdgeSchema(edgeAttributes);
                edgeAttributes.set(INTERACTION_TYPE_ATTR, (Object)INTERACTION_TYPE_REACTION_MODIFIER);
            }
            KineticLaw law = reaction.getKineticLaw();
            if (law == null) continue;
            for (LocalParameter parameter : law.getListOfParameters()) {
                String parameterName = parameter.getName();
                String key = String.format(KINETIC_LAW_ATTR_TEMPLATE, parameterName);
                this.checkSchema(attributes, key, Double.class);
                attributes.set(key, (Object)parameter.getValue());
                String units = parameter.getUnits();
                if (units == null) continue;
                String unitsKey = String.format(KINETIC_LAW_UNITS_ATTR_TEMPLATE, parameterName);
                this.checkSchema(attributes, unitsKey, String.class);
                attributes.set(unitsKey, (Object)units);
            }
        }
    }

    private void checkEdgeSchema(CyRow attributes) {
        this.checkSchema(attributes, INTERACTION_TYPE_ATTR, String.class);
    }

    private void checkNodeSchema(CyRow attributes) {
        this.checkSchema(attributes, SBML_TYPE_ATTR, String.class);
        this.checkSchema(attributes, SBML_ID_ATTR, String.class);
        this.checkSchema(attributes, SBML_INITIAL_CONCENTRATION_ATTR, Double.class);
        this.checkSchema(attributes, SBML_INITIAL_AMOUNT_ATTR, Double.class);
        this.checkSchema(attributes, SBML_CHARGE_ATTR, Integer.class);
        this.checkSchema(attributes, SBML_COMPARTMENT_ATTR, String.class);
    }

    private <T> void checkSchema(CyRow attributes, String attributeName, Class<T> type) {
        if (attributes.getTable().getColumn(attributeName) == null) {
            attributes.getTable().createColumn(attributeName, type, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readString(InputStream source) throws IOException {
        StringWriter writer = new StringWriter();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(source));){
            char[] buffer = new char[16384];
            int charactersRead = reader.read(buffer, 0, buffer.length);
            while (charactersRead != -1) {
                writer.write(buffer, 0, charactersRead);
                charactersRead = reader.read(buffer, 0, buffer.length);
            }
        }
        return writer.toString();
    }

    public void cancel() {
    }

    public CyNetwork[] getNetworks() {
        return new CyNetwork[]{this.network};
    }

    public CyNetworkView buildCyNetworkView(CyNetwork network) {
        return this.viewFactory.createNetworkView(network);
    }
}

