/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.sbml.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.cytoscape.io.CyFileFilter;
import org.cytoscape.io.DataCategory;
import org.cytoscape.io.util.StreamUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SBMLFileFilter
implements CyFileFilter {
    private static final String SBML_XML_NAMESPACE = "http://www.sbml.org/sbml/";
    private static final int DEFAULT_LINES_TO_CHECK = 20;
    private final StreamUtil streamUtil;
    private final Set<String> extensions;
    private final Set<String> contentTypes;
    private final String description;

    public SBMLFileFilter(String description, StreamUtil streamUtil) {
        this.streamUtil = streamUtil;
        this.extensions = new HashSet<String>();
        this.extensions.add("xml");
        this.contentTypes = new HashSet<String>();
        this.contentTypes.add("text/sbml");
        this.contentTypes.add("text/sbml+xml");
        this.description = description;
    }

    public boolean accepts(URI uri, DataCategory category) {
        boolean bl;
        block9: {
            if (!category.equals((Object)DataCategory.NETWORK)) {
                return false;
            }
            InputStream is = this.getInputStream(uri.toURL());
            try {
                bl = this.accepts(is, category);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Logger logger = LoggerFactory.getLogger(this.getClass());
                    logger.error("Error while checking header", (Throwable)e);
                    return false;
                }
            }
            is.close();
        }
        return bl;
    }

    private InputStream getInputStream(URL url) throws IOException {
        return this.streamUtil.getInputStream(url);
    }

    private boolean checkHeader(InputStream stream) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        for (int linesToCheck = 20; linesToCheck > 0; --linesToCheck) {
            String line = reader.readLine();
            if (line == null || !line.contains(SBML_XML_NAMESPACE)) continue;
            return true;
        }
        return false;
    }

    public boolean accepts(InputStream stream, DataCategory category) {
        if (!category.equals((Object)DataCategory.NETWORK)) {
            return false;
        }
        try {
            return this.checkHeader(stream);
        }
        catch (IOException e) {
            Logger logger = LoggerFactory.getLogger(this.getClass());
            logger.error("Error while checking header", (Throwable)e);
            return false;
        }
    }

    public Set<String> getExtensions() {
        return this.extensions;
    }

    public Set<String> getContentTypes() {
        return this.contentTypes;
    }

    public String getDescription() {
        return this.description;
    }

    public DataCategory getDataCategory() {
        return DataCategory.NETWORK;
    }
}

