/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.idmapper.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.command.StringToModel;
import org.cytoscape.idmapper.IdMapping;
import org.cytoscape.idmapper.MappingSource;
import org.cytoscape.idmapper.Species;
import org.cytoscape.idmapper.internal.BridgeDbIdMapper;
import org.cytoscape.idmapper.internal.MappingUtil;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;
import org.cytoscape.work.util.ListSingleSelection;

public final class MapColumnCommandTask
extends AbstractTask
implements ObservableTask {
    private final CyTableManager tableManager;
    @ContainsTunables
    @Tunable(description="Species", gravity=0.0, context="nogui", required=true, longDescription="The combined common or latin name of the species to which the identifiers apply", exampleStringValue="Yeast")
    public ListSingleSelection<String> species = new ListSingleSelection(Species.fullNames());
    @Tunable(description="Column name", longDescription="Specifies the column name where the source identifiers are located", exampleStringValue="name", context="nogui", required=true)
    public ListSingleSelection<String> columnName = new ListSingleSelection((Object[])new String[0]);
    @Tunable(description="Source Database", longDescription="Specifies the data source describing the existing identifiers", exampleStringValue="Ensembl", context="nogui", required=true)
    public ListSingleSelection<String> mapFrom = new ListSingleSelection((Object[])new String[0]);
    @Tunable(description="New Column Name", longDescription="Specifies the column name where the target identifiers are located", context="nogui", exampleStringValue="SGD", required=true)
    public ListSingleSelection<String> mapTo = new ListSingleSelection((Object[])new String[0]);
    @Tunable(description="Force single ", gravity=3.0, longDescription="When multiple identifiers can be mapped from a single term, this forces a singular result", exampleStringValue="true")
    public boolean forceSingle = true;
    @Tunable(description="Network ", context="nogui", longDescription="Which network is used in the mapping", exampleStringValue="current")
    public String networkName = "current";
    @Tunable(description="Table ", context="nogui", longDescription="Which table is used as the source of the identifiers, e.g., \"node\" for the default node table", exampleStringValue="default node")
    public String table = "node:current";
    CyColumn column = null;
    CyServiceRegistrar serviceRegistrar;
    private boolean VERBOSE = false;
    private Set<String> matched_ids;
    private Set<String> unmatched_ids;
    private Map<String, IdMapping> res;
    private CyTable networkTable;
    private CyTable nodeTable;
    private String new_column_name;

    @ProvidesTitle
    public String getTitle() {
        return "Map Column";
    }

    MapColumnCommandTask(CyServiceRegistrar registrar) {
        this.tableManager = (CyTableManager)registrar.getService(CyTableManager.class);
        this.serviceRegistrar = registrar;
        if (this.VERBOSE) {
            System.out.println("create MapColumnCommandTask");
        }
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        StringToModel stMod;
        if (this.VERBOSE) {
            System.out.println("run MapColumnCommandTask");
        }
        if ((stMod = (StringToModel)this.serviceRegistrar.getService(StringToModel.class)) == null) {
            taskMonitor.showMessage(TaskMonitor.Level.ERROR, "Unable to StringToModel bundle");
            return;
        }
        CyNetwork network = stMod.getNetwork(this.networkName);
        if (network == null) {
            network = ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetwork();
        }
        this.networkTable = stMod.getTable("defaultNetwork");
        this.nodeTable = stMod.getTable(this.table);
        if (this.nodeTable == null) {
            this.nodeTable = network.getDefaultNodeTable();
            if (this.nodeTable == null) {
                taskMonitor.showMessage(TaskMonitor.Level.ERROR, "Unable to find node table");
                return;
            }
        }
        if (this.mapFrom == null) {
            taskMonitor.showMessage(TaskMonitor.Level.ERROR, "Column name must be specified");
            return;
        }
        if (this.mapTo == null) {
            taskMonitor.showMessage(TaskMonitor.Level.ERROR, "New column name must be specified");
            return;
        }
        String rawTarget = (String)this.mapTo.getSelectedValue();
        String rawSource = (String)this.columnName.getSelectedValue();
        this.column = this.nodeTable.getColumn(rawSource);
        if (this.column == null) {
            taskMonitor.showMessage(TaskMonitor.Level.ERROR, "Can't find column " + rawSource + " in table " + this.nodeTable.toString());
            return;
        }
        String speciesVal = null;
        CyRow networkTableRow0 = null;
        System.out.println("networkTable " + this.networkTable);
        if (this.networkTable != null) {
            networkTableRow0 = this.networkTable.getRow((Object)0);
            networkTableRow0.set("idmapper.species", (Object)speciesVal);
            System.out.println("write species as " + speciesVal);
            if (speciesVal != null) {
                this.species.setSelectedValue((Object)speciesVal);
            }
        } else {
            taskMonitor.showMessage(TaskMonitor.Level.ERROR, "networkTable not found");
        }
        speciesVal = (String)this.species.getSelectedValue();
        MappingSource source = MappingSource.nameLookup((String)this.mapFrom.getSelectedValue());
        if (this.column.getType() == Double.class || this.column.getType() == Integer.class || this.column.getType() == Boolean.class) {
            if (this.VERBOSE) {
                System.out.println("Can't map a numeric column as identifiers");
            }
            return;
        }
        MappingSource saveTarget = MappingSource.nameLookup(rawTarget);
        Species saveSpecies = Species.lookup(speciesVal);
        if (this.VERBOSE) {
            System.out.println("saving species as " + saveSpecies.name());
        }
        boolean source_is_list = false;
        if (this.column.getType() == List.class) {
            source_is_list = true;
        }
        List values = this.column.getValues(this.column.getType());
        ArrayList<String> ids = new ArrayList<String>();
        for (Object v : values) {
            if (v == null) continue;
            if (source_is_list) {
                for (Object lv : (List)v) {
                    MappingUtil.addCleanedStrValueToList(ids, lv);
                }
                continue;
            }
            MappingUtil.addCleanedStrValueToList(ids, v);
        }
        try {
            BridgeDbIdMapper map = new BridgeDbIdMapper();
            this.res = map.map(ids, source.system(), saveTarget.system(), saveSpecies.name(), saveSpecies.name());
            this.matched_ids = map.getMatchedIds();
            this.unmatched_ids = map.getUnmatchedIds();
        }
        catch (Exception e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(null, e.getMessage(), "ID Mapping Error", 0);
                }
            });
            return;
        }
        if (this.VERBOSE) {
            System.out.println();
            System.out.println("Unmatched:");
            if (this.unmatched_ids != null) {
                for (String u : this.unmatched_ids) {
                    System.out.println(u);
                }
            }
            System.out.println();
            System.out.println("Matched:");
            if (this.matched_ids != null) {
                for (String u : this.matched_ids) {
                    System.out.println(u);
                }
            }
            System.out.println();
        }
        this.new_column_name = saveTarget.descriptor();
        this.new_column_name = MappingUtil.makeNewColumnName(this.new_column_name, source.descriptor(), this.new_column_name, this.column);
        boolean all_unique = true;
        int non_unique = 0;
        int unique = 0;
        int min = Integer.MAX_VALUE;
        int max = 0;
        if (this.res != null) {
            for (Map.Entry<String, IdMapping> entry : this.res.entrySet()) {
                Set<String> v = entry.getValue().getTargetIds();
                if (v == null) continue;
                if (v.size() > 1) {
                    all_unique = false;
                    ++non_unique;
                    if (v.size() > max) {
                        max = v.size();
                    }
                    if (v.size() >= min) continue;
                    min = v.size();
                    continue;
                }
                ++unique;
            }
        }
        boolean many_to_one = false;
        if (this.matched_ids.size() > 0) {
            boolean all_single = false;
            if (this.forceSingle) {
                this.nodeTable.createColumn(this.new_column_name, String.class, false);
            } else {
                all_single = MappingUtil.isAllSingle(source_is_list, this.res, this.column, this.nodeTable);
                if (all_single) {
                    this.nodeTable.createColumn(this.new_column_name, String.class, false);
                } else {
                    this.nodeTable.createListColumn(this.new_column_name, String.class, false);
                }
            }
            many_to_one = MappingUtil.fillNewColumn(source_is_list, this.res, this.nodeTable, this.column, this.new_column_name, this.forceSingle || all_single);
        }
        String targ = saveTarget.descriptor();
        String src = source.descriptor();
        String msg = MappingUtil.createMsg(this.new_column_name, targ, src, ids, this.matched_ids, all_unique, non_unique, unique, min, max, many_to_one, this.forceSingle);
    }

    public <R> R getResults(Class<? extends R> type) {
        if (type.equals(String.class)) {
            if (this.column == null) {
                return (R)"Unable to map column";
            }
            String res = "Mapped column " + (String)this.mapFrom.getSelectedValue() + " in table " + this.nodeTable + " to " + (String)this.mapTo.getSelectedValue();
            return (R)res;
        }
        if (type.equals(JSONResult.class)) {
            JSONResult res = () -> {
                if (this.column == null) {
                    return "{}";
                }
                if (this.VERBOSE) {
                    System.out.println("column = " + this.new_column_name);
                }
                return "{ \"new column\" : \"" + this.new_column_name + " \" }";
            };
            return (R)res;
        }
        return (R)this.column;
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(CyColumn.class, String.class, JSONResult.class);
    }
}

