/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.idmapper.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.cytoscape.idmapper.IdGuess;
import org.cytoscape.idmapper.IdMapper;
import org.cytoscape.idmapper.IdMapping;
import org.cytoscape.idmapper.MappingSource;
import org.cytoscape.idmapper.internal.IdMappingImpl;

public class BridgeDbIdMapper
implements IdMapper {
    public static final String DEFAULT_MAP_SERVICE_URL_STR = "https://webservice.bridgedb.org";
    public static final boolean DEBUG = true;
    private final String _url;
    private Set<String> _unmatched_ids;
    private Set<String> _matched_ids;
    final Map<String, String> details = new TreeMap<String, String>();

    public BridgeDbIdMapper(String url) {
        this._url = url;
    }

    public BridgeDbIdMapper() {
        this(DEFAULT_MAP_SERVICE_URL_STR);
    }

    @Override
    public Set<String> getUnmatchedIds() {
        return this._unmatched_ids;
    }

    @Override
    public Set<String> getMatchedIds() {
        return this._matched_ids;
    }

    @Override
    public Map<String, IdMapping> map(Collection<String> query_ids, String source_type, String target_type, String source_species, String target_species) {
        List<String> response = null;
        this._matched_ids = new TreeSet<String>();
        this._unmatched_ids = new TreeSet<String>();
        try {
            response = BridgeDbIdMapper.runQuery(query_ids, target_species, "xrefsBatch", source_type, this._url);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (response != null) {
            for (String string : query_ids) {
            }
            try {
                Map<String, IdMapping> res = this.parseResponse(response, source_species, source_type, target_species, target_type);
                return res;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public Map<String, IdMapping> mapList(Collection<String> query_ids, List<MappingSource> source_types, List<MappingSource> target_types, String source_species, String target_species) {
        return null;
    }

    @Override
    public Map<String, IdGuess> guess(Collection<String> query_ids, String source_species) {
        return null;
    }

    private final Map<String, IdMapping> parseResponse(List<String> res_list, String source_species, String source_type, String target_species, String target_type) throws IOException {
        TreeMap<String, IdMapping> res = new TreeMap<String, IdMapping>();
        for (String s : res_list) {
            String[] s2;
            String[] s1 = s.split("\t");
            if (s1.length != 3) {
                throw new IOException("illegal format: " + s);
            }
            IdMappingImpl idmap = new IdMappingImpl();
            idmap.setSourceSpecies(source_species);
            idmap.setTargetType(MappingSource.systemLookup(target_type));
            idmap.setSourceType(MappingSource.systemLookup(s1[1]));
            idmap.addSourceId(s1[0]);
            for (String s2_str : s2 = s1[2].split(",")) {
                if (s2_str == null || s2_str.toLowerCase().equals("n/a")) continue;
                String[] s3 = s2_str.split(":", 2);
                if (s3.length != 2) {
                    throw new IOException("illegal format: " + s);
                }
                if (!s3[0].equals(target_type)) continue;
                idmap.addTargetId(s3[1]);
            }
            if (idmap.getTargetIds().size() > 0) {
                res.put(s1[0], idmap);
                this._matched_ids.add(s1[0]);
            } else {
                this._unmatched_ids.add(s1[0]);
            }
            this.details.put(s1[0], s1[1]);
        }
        return res;
    }

    private static final List<String> post(String url_str, String species, String command, String database, String query) throws IOException {
        String line;
        String link = url_str + "/" + species + "/" + command;
        if (!"Unspecified".equals(database)) {
            link = link + "/" + database;
        }
        URL url = new URL(link);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setDoOutput(true);
        conn.setRequestMethod("POST");
        OutputStream os = conn.getOutputStream();
        os.write(query.getBytes());
        os.flush();
        if (conn.getResponseCode() != 200) {
            throw new IOException("HTTP error code : " + conn.getResponseCode());
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        ArrayList<String> res = new ArrayList<String>();
        while ((line = br.readLine()) != null) {
            res.add(line);
        }
        br.close();
        conn.disconnect();
        os.close();
        return res;
    }

    private static final List<String> runQuery(Collection<String> ids, String species, String command, String sourceType, String url_str) throws IOException {
        String query = BridgeDbIdMapper.makeQuery(ids);
        return BridgeDbIdMapper.post(url_str, species, command, sourceType, query);
    }

    private static final String makeQuery(Collection<String> ids) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String id : ids) {
            if (first) {
                first = false;
            } else {
                sb.append("\n");
            }
            sb.append(id);
        }
        return sb.toString();
    }

    public static void main(String[] args) throws IOException {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add("ENSMUSG00000063455");
        ids.add("ENSMUSG00000073823");
        ids.add("ENSMUSG00000037031");
        BridgeDbIdMapper map = new BridgeDbIdMapper();
        String source_type = "En";
        String target_type = "S";
        String source_species = "Mouse";
        String target_species = "Mouse";
        Map<String, IdMapping> x = map.map(ids, "En", "S", "Mouse", "Mouse");
    }
}

