/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.webservice.internal.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.io.webservice.WebServiceClient;
import org.cytoscape.io.webservice.swing.WebServiceGUIClient;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.webservice.internal.ui.AboutDialog;
import org.cytoscape.work.swing.DialogTaskManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebServiceImportDialog<T>
extends JDialog {
    private static final long serialVersionUID = 4454012178961756787L;
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private static final String NO_CLIENT = "No Service Client";
    private JButton cancelButton;
    private JComboBox datasourceComboBox;
    private JLabel datasourceLabel;
    private JTabbedPane mainTabbedPane;
    private JPanel propertyPanel;
    private JScrollPane propertyScrollPane;
    private JButton searchButton;
    private JScrollPane searchTermScrollPane;
    private JTextPane queryTextPane;
    private JButton aboutButton;
    private JPanel buttonPanel;
    private JPanel queryPanel;
    private JButton clearButton;
    private JPanel dataQueryPanel;
    private JPanel datasourcePanel;
    private JLabel titleIconLabel;
    private JPanel titlePanel;
    private Set<WebServiceClient> clients;
    private Map<WebServiceClient, Container> serviceUIPanels = new HashMap<WebServiceClient, Container>();
    private int numClients;
    private final Class<T> type;
    private final CyServiceRegistrar serviceRegistrar;
    boolean readyToShow;

    public WebServiceImportDialog(Class<T> type, String title, CyServiceRegistrar serviceRegistrar) {
        super((Frame)((CySwingApplication)serviceRegistrar.getService(CySwingApplication.class)).getJFrame(), false);
        this.type = type;
        this.serviceRegistrar = serviceRegistrar;
        this.numClients = 0;
        this.clients = new HashSet<WebServiceClient>();
        this.initGUI();
        this.datasourceComboBox.addItem(NO_CLIENT);
        this.setComponentsEnabled(false);
        this.setTitle(title);
    }

    public void addClient(WebServiceClient client, Map props) {
        if (!this.typeCheck(client)) {
            return;
        }
        if (this.numClients == 0) {
            this.datasourceComboBox.removeAllItems();
        }
        this.datasourceComboBox.addItem(client);
        this.clients.add(client);
        ++this.numClients;
        this.setComponentsEnabled(true);
        if (client instanceof WebServiceGUIClient) {
            this.serviceUIPanels.put(client, null);
        }
        if (this.datasourceComboBox.getModel().getSize() != 0) {
            this.datasourceComboBox.setSelectedIndex(0);
        }
        this.datasourceComboBoxActionPerformed(null);
        logger.info("New network import client registered: " + client);
    }

    public void removeClient(WebServiceClient client, Map props) {
        if (!this.typeCheck(client)) {
            return;
        }
        this.datasourceComboBox.removeItem(client);
        this.clients.remove(client);
        this.serviceUIPanels.remove(client);
        --this.numClients;
        if (this.numClients == 0) {
            this.datasourceComboBox.removeAllItems();
            this.datasourceComboBox.addItem(NO_CLIENT);
            this.setComponentsEnabled(false);
        }
    }

    private boolean typeCheck(WebServiceClient client) {
        Class<?>[] interfaces = client.getClass().getInterfaces();
        boolean found = false;
        for (Class<?> inf : interfaces) {
            if (!inf.equals(this.type)) continue;
            found = true;
            break;
        }
        return found;
    }

    private void initGUI() {
        this.initComponents();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.queryPanel, "Center");
        this.pack();
        this.datasourceComboBoxActionPerformed(null);
    }

    private void setComponentsEnabled(boolean enable) {
        this.datasourceComboBox.setEnabled(enable);
        this.searchButton.setEnabled(enable);
        this.aboutButton.setEnabled(enable);
        this.cancelButton.setEnabled(enable);
    }

    private void initComponents() {
        this.mainTabbedPane = new JTabbedPane();
        this.searchTermScrollPane = new JScrollPane();
        this.queryTextPane = new JTextPane();
        this.propertyPanel = new JPanel();
        this.queryTextPane.setFont(new Font("SansSerif", 0, 12));
        this.queryTextPane.setText("Please enter search terms...");
        this.searchTermScrollPane.setViewportView(this.queryTextPane);
        this.mainTabbedPane.addTab("Query", this.searchTermScrollPane);
        GroupLayout propertyPanelLayout = new GroupLayout(this.propertyPanel);
        this.propertyPanel.setLayout(propertyPanelLayout);
        propertyPanelLayout.setHorizontalGroup(propertyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 408, Short.MAX_VALUE));
        propertyPanelLayout.setVerticalGroup(propertyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 303, Short.MAX_VALUE));
        this.propertyScrollPane = new JScrollPane();
        this.propertyScrollPane.setViewportView(this.propertyPanel);
        this.mainTabbedPane.addTab("Search Property", this.propertyScrollPane);
        this.titlePanel = new JPanel();
        this.titleIconLabel = new JLabel();
        this.datasourcePanel = new JPanel();
        this.datasourceLabel = new JLabel();
        this.datasourceComboBox = new JComboBox();
        this.datasourceComboBox.setRenderer(new ClientComboBoxCellRenderer());
        this.aboutButton = new JButton();
        this.searchButton = new JButton();
        this.cancelButton = new JButton();
        this.clearButton = new JButton();
        this.dataQueryPanel = new JPanel();
        this.setDefaultCloseOperation(2);
        GroupLayout titlePanelLayout = new GroupLayout(this.titlePanel);
        this.titlePanel.setLayout(titlePanelLayout);
        titlePanelLayout.setHorizontalGroup(titlePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.titleIconLabel, -2, 461, -2));
        titlePanelLayout.setVerticalGroup(titlePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.titleIconLabel));
        this.datasourceLabel.setText("Data Source:");
        this.datasourceComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebServiceImportDialog.this.datasourceComboBoxActionPerformed(evt);
            }
        });
        this.aboutButton.setText("About");
        this.aboutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebServiceImportDialog.this.aboutButtonActionPerformed(evt);
            }
        });
        GroupLayout dataSourceLayout = new GroupLayout(this.datasourcePanel);
        this.datasourcePanel.setLayout(dataSourceLayout);
        dataSourceLayout.setAutoCreateContainerGaps(false);
        dataSourceLayout.setAutoCreateGaps(true);
        dataSourceLayout.setHorizontalGroup(dataSourceLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dataSourceLayout.createSequentialGroup().addContainerGap().addComponent(this.datasourceLabel).addComponent(this.datasourceComboBox, -2, -1, -2).addGap(20, 20, Short.MAX_VALUE).addComponent(this.aboutButton).addContainerGap()));
        dataSourceLayout.setVerticalGroup(dataSourceLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dataSourceLayout.createSequentialGroup().addGroup(dataSourceLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.datasourceLabel).addComponent(this.aboutButton).addComponent(this.datasourceComboBox, -2, -1, -2))));
        this.searchButton.setText("Search");
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebServiceImportDialog.this.searchButtonActionPerformed();
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebServiceImportDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.clearButton.setText("Clear");
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebServiceImportDialog.this.clearButtonActionPerformed(evt);
            }
        });
        this.buttonPanel = LookAndFeelUtil.createOkCancelPanel((JButton)this.searchButton, (JButton)this.cancelButton, (JComponent[])new JComponent[]{this.clearButton});
        GroupLayout dataQueryPanelLayout = new GroupLayout(this.dataQueryPanel);
        this.dataQueryPanel.setLayout(dataQueryPanelLayout);
        dataQueryPanelLayout.setHorizontalGroup(dataQueryPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 461, Short.MAX_VALUE));
        dataQueryPanelLayout.setVerticalGroup(dataQueryPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 247, Short.MAX_VALUE));
        this.queryPanel = new JPanel();
        GroupLayout layout = new GroupLayout(this.queryPanel);
        this.queryPanel.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.titlePanel, -1, -1, Short.MAX_VALUE).addComponent(this.datasourcePanel, -1, -1, Short.MAX_VALUE).addComponent(this.dataQueryPanel, -1, -1, Short.MAX_VALUE).addComponent(this.buttonPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.titlePanel, -2, -1, -2).addComponent(this.datasourcePanel, -2, -1, -2).addComponent(this.dataQueryPanel, -1, -1, Short.MAX_VALUE).addComponent(this.buttonPanel, -2, -1, -2));
        this.dataQueryPanel.setLayout(new BorderLayout());
    }

    public void prepareForDisplay() {
        this.readyToShow = true;
        this.datasourceComboBoxActionPerformed(null);
    }

    private void searchButtonActionPerformed() {
        Object selected = this.datasourceComboBox.getSelectedItem();
        if (selected == null) {
            return;
        }
        WebServiceClient client = null;
        if (!(selected instanceof WebServiceClient)) {
            throw new IllegalStateException("Selected client is not a compatible one.");
        }
        client = (WebServiceClient)selected;
        DialogTaskManager taskManager = (DialogTaskManager)this.serviceRegistrar.getService(DialogTaskManager.class);
        taskManager.execute(client.createTaskIterator((Object)this.queryTextPane.getText()));
    }

    private void clearButtonActionPerformed(ActionEvent evt) {
        this.queryTextPane.setText("");
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.queryTextPane.setText("");
        this.dispose();
    }

    private void datasourceComboBoxActionPerformed(ActionEvent evt) {
        if (!this.readyToShow) {
            return;
        }
        Object selected = this.datasourceComboBox.getSelectedItem();
        if (selected == null && (selected = this.datasourceComboBox.getItemAt(0)) == null) {
            return;
        }
        this.queryTextPane.setText("");
        if (!(selected instanceof WebServiceClient)) {
            return;
        }
        WebServiceClient client = (WebServiceClient)selected;
        this.dataQueryPanel.removeAll();
        Container gui = this.getUIPanel(client);
        if (gui != null) {
            this.dataQueryPanel.add((Component)gui, "Center");
            this.buttonPanel.setVisible(false);
        } else {
            this.dataQueryPanel.add((Component)this.mainTabbedPane, "Center");
            this.buttonPanel.setVisible(true);
        }
        this.pack();
        this.repaint();
    }

    private Container getUIPanel(WebServiceClient client) {
        Container container = this.serviceUIPanels.get(client);
        if (container == null && client instanceof WebServiceGUIClient && (container = ((WebServiceGUIClient)client).getQueryBuilderGUI()) != null) {
            this.serviceUIPanels.put(client, container);
        }
        return container;
    }

    private void aboutButtonActionPerformed(ActionEvent evt) {
        WebServiceClient wsc = (WebServiceClient)this.datasourceComboBox.getSelectedItem();
        String clientName = wsc.getDisplayName();
        String description = wsc.getDescription();
        AboutDialog aboutDialog = new AboutDialog((Window)this, Dialog.ModalityType.APPLICATION_MODAL, this.serviceRegistrar);
        aboutDialog.showDialog(clientName, description);
    }

    private final class ClientComboBoxCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1494017058040636621L;

        private ClientComboBoxCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof WebServiceClient) {
                String displayName = ((WebServiceClient)value).getDisplayName();
                this.setText(displayName);
            }
            return this;
        }
    }
}

