/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.webservice.internal.ui;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.UIDefaults;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.util.swing.OpenBrowser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AboutDialog
extends JDialog
implements HyperlinkListener {
    private static final long serialVersionUID = 8966870102741519552L;
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private static final Dimension WINDOW_SIZE = new Dimension(500, 400);
    private final CyServiceRegistrar serviceRegistrar;
    private JLabel titleLabel;
    private JEditorPane mainEditorPane;
    private JScrollPane mainScrollPane;

    public AboutDialog(Window parent, Dialog.ModalityType modal, CyServiceRegistrar serviceRegistrar) {
        super(parent, modal);
        this.serviceRegistrar = serviceRegistrar;
        this.initComponents();
        this.mainEditorPane.setEditable(false);
        this.mainEditorPane.addHyperlinkListener(this);
        this.setLocationRelativeTo(parent);
        this.setModalityType(DEFAULT_MODALITY_TYPE);
        this.setPreferredSize(WINDOW_SIZE);
        this.setSize(WINDOW_SIZE);
    }

    public AboutDialog(Window parent, Dialog.ModalityType modal, String title, Icon icon, URL contentURL, CyServiceRegistrar serviceRegistrar) {
        super(parent, modal);
        this.serviceRegistrar = serviceRegistrar;
        this.initComponents();
        this.mainEditorPane.setContentType("text/html");
        this.setPreferredSize(WINDOW_SIZE);
        this.setSize(WINDOW_SIZE);
    }

    public void showDialog(String title, String description) {
        this.setTitle("About " + title);
        this.titleLabel.setText(title);
        URL target = null;
        this.mainEditorPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        try {
            target = new URL(description);
        }
        catch (MalformedURLException e) {
            this.mainEditorPane.setContentType("text/html");
            this.mainEditorPane.setText(description);
            this.repaint();
            this.setVisible(true);
            return;
        }
        try {
            this.mainEditorPane.setPage(target);
            this.pack();
            this.repaint();
            this.setVisible(true);
        }
        catch (IOException e) {
            this.mainEditorPane.setText("Could not connect to " + target.toString());
            this.pack();
            this.repaint();
            this.setVisible(true);
        }
    }

    private void initComponents() {
        this.setTitle("About");
        this.setDefaultCloseOperation(2);
        this.mainEditorPane = new JEditorPane();
        this.mainEditorPane.setBorder(BorderFactory.createEmptyBorder());
        this.mainEditorPane.setEditable(false);
        this.mainEditorPane.setBackground(this.getBackground());
        if (LookAndFeelUtil.isNimbusLAF()) {
            UIDefaults defaults = new UIDefaults();
            defaults.put("EditorPane[Enabled].backgroundPainter", this.getBackground());
            this.mainEditorPane.putClientProperty("Nimbus.Overrides", defaults);
            this.mainEditorPane.putClientProperty("Nimbus.Overrides.InheritDefaults", true);
        }
        this.mainScrollPane = new JScrollPane();
        this.mainScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.mainScrollPane.setHorizontalScrollBarPolicy(31);
        this.mainScrollPane.setViewportView(this.mainEditorPane);
        this.titleLabel = new JLabel();
        this.titleLabel.setFont(new Font(this.titleLabel.getName(), 1, 18));
        this.titleLabel.setHorizontalAlignment(0);
        JButton closeButton = new JButton(new AbstractAction("Close"){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutDialog.this.dispose();
            }
        });
        JPanel buttonPanel = LookAndFeelUtil.createOkCancelPanel((JButton)closeButton, null);
        JPanel contents = new JPanel();
        JSeparator sep1 = new JSeparator();
        JSeparator sep2 = new JSeparator();
        GroupLayout layout = new GroupLayout(contents);
        contents.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createSequentialGroup().addGap(20).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.titleLabel, -1, -1, Short.MAX_VALUE).addComponent(sep1, -1, -1, Short.MAX_VALUE).addComponent(this.mainScrollPane, -1, -1, Short.MAX_VALUE).addComponent(sep2, -1, -1, Short.MAX_VALUE).addComponent(buttonPanel, -1, -1, Short.MAX_VALUE)).addGap(20));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.titleLabel, -2, -1, -2).addComponent(sep1, -2, -1, -2).addComponent(this.mainScrollPane, -1, 215, Short.MAX_VALUE).addComponent(sep2, -2, -1, -2).addComponent(buttonPanel, -2, -1, -2));
        this.getContentPane().add(contents);
        LookAndFeelUtil.setDefaultOkCancelKeyStrokes((JRootPane)this.getRootPane(), (Action)closeButton.getAction(), (Action)closeButton.getAction());
        this.getRootPane().setDefaultButton(closeButton);
        this.pack();
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
            return;
        }
        String url = e.getURL().toString();
        try {
            ((OpenBrowser)this.serviceRegistrar.getService(OpenBrowser.class)).openURL(url);
        }
        catch (Exception err) {
            logger.warn("Unable to open browser for " + url.toString(), (Throwable)err);
        }
    }
}

