/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.model.internal.column;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.internal.column.ColumnData;

public class LongToBooleanColumn
implements ColumnData {
    private final Set<Long> trueKeys;
    private final Set<Long> falseKeys;

    LongToBooleanColumn(Supplier<Set<Long>> setFactory) {
        this.trueKeys = setFactory.get();
        this.falseKeys = setFactory.get();
    }

    @Override
    public int countMatchingRows(Object value) {
        if (Boolean.TRUE.equals(value)) {
            return this.trueKeys.size();
        }
        if (Boolean.FALSE.equals(value)) {
            return this.falseKeys.size();
        }
        return 0;
    }

    @Override
    public Collection<CyRow> getMatchingRows(Map<Object, CyRow> rows, Object value) {
        Set<Long> keys = Boolean.TRUE.equals(value) ? this.trueKeys : (Boolean.FALSE.equals(value) ? this.falseKeys : Collections.emptySet());
        ArrayList<CyRow> matchingRows = new ArrayList<CyRow>();
        for (Long key : keys) {
            matchingRows.add(rows.get(key));
        }
        return matchingRows;
    }

    @Override
    public <T> Collection<T> getMatchingKeys(Object value, Class<T> type) {
        Set<Long> keys = Boolean.TRUE.equals(value) ? this.trueKeys : (Boolean.FALSE.equals(value) ? this.falseKeys : Collections.emptySet());
        return new ArrayList<Long>(keys);
    }

    @Override
    public boolean put(Object key, Object value) {
        if (value == null) {
            return this.remove(key);
        }
        boolean changed = false;
        if (Boolean.TRUE.equals(value)) {
            changed = this.trueKeys.add((Long)key);
            this.falseKeys.remove(key);
        } else if (Boolean.FALSE.equals(value)) {
            changed = this.falseKeys.add((Long)key);
            this.trueKeys.remove(key);
        }
        return changed;
    }

    @Override
    public Object get(Object key) {
        if (this.trueKeys.contains(key)) {
            return Boolean.TRUE;
        }
        if (this.falseKeys.contains(key)) {
            return Boolean.FALSE;
        }
        return null;
    }

    @Override
    public boolean remove(Object key) {
        boolean changed = false;
        changed |= this.trueKeys.remove(key);
        return changed |= this.falseKeys.remove(key);
    }

    @Override
    public Set<Object> keySet() {
        return Sets.union(this.trueKeys, this.falseKeys);
    }
}

