/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.model.internal.column;

import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.Long2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cytoscape.model.internal.column.CanonicalStringPool;
import org.cytoscape.model.internal.column.CanonicalStringPoolFilter;
import org.cytoscape.model.internal.column.ColumnData;
import org.cytoscape.model.internal.column.ColumnDataFactory;
import org.cytoscape.model.internal.column.EquationSupport;
import org.cytoscape.model.internal.column.LongToBooleanColumn;
import org.cytoscape.model.internal.column.MapColumn;

public class ColumnDataFactoryFastUtil
implements ColumnDataFactory {
    private final CanonicalStringPool stringPool = new CanonicalStringPool();

    @Override
    public void clearCache() {
        this.stringPool.clear();
    }

    @Override
    public ColumnData create(Class<?> primaryKeyType, Class<?> type, Class<?> listElementType, int defaultInitSize) {
        if (Long.class.equals(primaryKeyType)) {
            if (Integer.class.equals(type)) {
                return new EquationSupport(new MapColumn((Map<Object, Object>)new Long2IntOpenHashMap()));
            }
            if (Long.class.equals(type)) {
                return new EquationSupport(new MapColumn((Map<Object, Object>)new Long2LongOpenHashMap()));
            }
            if (Double.class.equals(type)) {
                return new EquationSupport(new MapColumn((Map<Object, Object>)new Long2DoubleOpenHashMap()));
            }
            if (String.class.equals(type)) {
                return new CanonicalStringPoolFilter(this.stringPool, new MapColumn((Map<Object, Object>)new Long2ObjectOpenHashMap()));
            }
            if (Boolean.class.equals(type)) {
                return new EquationSupport(new LongToBooleanColumn(() -> new LongOpenHashSet()));
            }
        }
        return new MapColumn(new HashMap<Object, Object>(defaultInitSize));
    }

    @Override
    public List<?> createList(Class<?> elementType, List<?> data) {
        if (Integer.class.equals(elementType)) {
            return new IntArrayList(data);
        }
        if (Long.class.equals(elementType)) {
            return new LongArrayList(data);
        }
        if (Double.class.equals(elementType)) {
            return new DoubleArrayList(data);
        }
        if (Boolean.class.equals(elementType)) {
            return new BooleanArrayList(data);
        }
        if (String.class.equals(elementType)) {
            ArrayList canonData = new ArrayList(data.size());
            for (Object value : data) {
                if (value instanceof String) {
                    value = this.stringPool.canonicalize((String)value);
                }
                canonData.add(value);
            }
            return canonData;
        }
        return new ArrayList(data);
    }
}

