/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.model.internal;

import java.util.Collection;
import java.util.Iterator;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.events.NetworkAddedEvent;
import org.cytoscape.model.events.NetworkAddedListener;
import org.cytoscape.model.events.RowSetRecord;
import org.cytoscape.model.events.RowsSetEvent;
import org.cytoscape.model.events.RowsSetListener;
import org.cytoscape.model.subnetwork.CyRootNetwork;

public class NetworkNameSetListener
implements RowsSetListener,
NetworkAddedListener {
    final CyRootNetwork rootNetwork;

    public NetworkNameSetListener(CyRootNetwork rootNetwork) {
        this.rootNetwork = rootNetwork;
    }

    public void handleEvent(RowsSetEvent e) {
        CyTable sourceTable = (CyTable)e.getSource();
        if (sourceTable.equals(this.rootNetwork.getDefaultNetworkTable())) {
            this.updateRootNetworkTableNames(e.getPayloadCollection());
        } else {
            this.updateSubNetworkTableNames(e.getColumnRecords("name"), sourceTable);
        }
    }

    private void updateSubNetworkTableNames(Collection<RowSetRecord> payloadCollection, CyTable sourceTable) {
        for (CyNetwork net : this.rootNetwork.getSubNetworkList()) {
            Iterator<RowSetRecord> iterator;
            if (!sourceTable.equals(net.getDefaultNetworkTable()) || !(iterator = payloadCollection.iterator()).hasNext()) continue;
            RowSetRecord record = iterator.next();
            Object name = record.getValue();
            this.setTablesName(name.toString() + " default ", net.getDefaultEdgeTable(), net.getDefaultNodeTable(), net.getDefaultNetworkTable());
            return;
        }
    }

    private void updateRootNetworkTableNames(Collection<RowSetRecord> payloadCollection) {
        Iterator<RowSetRecord> iterator = payloadCollection.iterator();
        if (iterator.hasNext()) {
            RowSetRecord record = iterator.next();
            Object name = record.getValue();
            this.setTablesName(name + " root shared ", this.rootNetwork.getSharedEdgeTable(), this.rootNetwork.getSharedNodeTable(), this.rootNetwork.getSharedNetworkTable());
            this.setTablesName(name + " root default ", this.rootNetwork.getDefaultEdgeTable(), this.rootNetwork.getDefaultNodeTable(), this.rootNetwork.getDefaultNetworkTable());
            return;
        }
    }

    private void setTablesName(String name, CyTable edgeTable, CyTable nodeTable, CyTable networkTable) {
        edgeTable.setTitle(name + " edge");
        networkTable.setTitle(name + " network");
        nodeTable.setTitle(name + " node");
    }

    public void handleEvent(NetworkAddedEvent e) {
        CyNetwork sourceNetwork = e.getNetwork();
        String name = (String)sourceNetwork.getRow((CyIdentifiable)sourceNetwork).get("name", String.class);
        if (sourceNetwork.equals(this.rootNetwork.getBaseNetwork())) {
            this.setRootNetworkName(name);
        }
        if (this.rootNetwork.containsNetwork(sourceNetwork)) {
            this.updateSubNetworkTableNames(sourceNetwork, name);
        }
    }

    private void setRootNetworkName(String name) {
        CyRow row = this.rootNetwork.getRow((CyIdentifiable)this.rootNetwork);
        if (!row.isSet("name") || ((String)row.get("name", String.class)).isEmpty()) {
            this.rootNetwork.getRow((CyIdentifiable)this.rootNetwork).set("name", (Object)name);
        }
    }

    private void updateSubNetworkTableNames(CyNetwork net, String name) {
        net.getDefaultEdgeTable().setTitle(name + " default edge");
        net.getDefaultNetworkTable().setTitle(name + " default network");
        net.getDefaultNodeTable().setTitle(name + " default node");
    }
}

