/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.model.internal;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.cytoscape.equations.Equation;
import org.cytoscape.equations.IdentDescriptor;
import org.cytoscape.equations.Interpreter;
import org.cytoscape.model.internal.CyTableImpl;

class EqnSupport {
    private EqnSupport() {
    }

    static boolean scalarEquationIsCompatible(Object equationCandidate, Class<?> targetType) {
        if (!(equationCandidate instanceof Equation)) {
            return false;
        }
        Equation equation = (Equation)equationCandidate;
        Class eqType = equation.getType();
        if (targetType == String.class) {
            return true;
        }
        if (targetType == Boolean.class || Number.class.isAssignableFrom(targetType)) {
            return eqType == Boolean.class || Number.class.isAssignableFrom(eqType);
        }
        return false;
    }

    static boolean listEquationIsCompatible(Equation equation, Class<?> listElementType) {
        return true;
    }

    static Object convertEqnResultToColumnType(Class<?> columnType, Object result) {
        Class<?> resultType = result.getClass();
        if (resultType == columnType) {
            return result;
        }
        if (columnType == List.class && List.class.isAssignableFrom(resultType)) {
            return result;
        }
        if (columnType == String.class) {
            return result.toString();
        }
        if (Number.class.isAssignableFrom(resultType)) {
            if (columnType == Number.class || columnType == Double.class) {
                return ((Number)result).doubleValue();
            }
            if (columnType == Long.class) {
                return ((Number)result).longValue();
            }
            if (columnType == Integer.class) {
                return ((Number)result).intValue();
            }
        }
        if (columnType == Boolean.class && resultType == Long.class) {
            return (Long)result == 0L ? Boolean.FALSE : Boolean.TRUE;
        }
        if (columnType == Boolean.class && resultType == Double.class) {
            return (Double)result == 0.0 ? Boolean.FALSE : Boolean.TRUE;
        }
        throw new IllegalArgumentException("unexpected equation result type " + resultType.getSimpleName() + " for a column of type " + columnType.getSimpleName() + ".");
    }

    static Object evalEquation(Equation equation, Object key, Interpreter interpreter, Set<String> currentlyActiveAttributes, String columnName, Appendable lastInternalError, CyTableImpl tableImpl) {
        if (currentlyActiveAttributes.contains(columnName)) {
            currentlyActiveAttributes.clear();
            try {
                lastInternalError.append("Recursive equation evaluation of \"" + columnName + "\".");
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
        currentlyActiveAttributes.add(columnName);
        Set attribReferences = equation.getVariableReferences();
        Map defaultValues = equation.getDefaultVariableValues();
        TreeMap<String, IdentDescriptor> nameToDescriptorMap = new TreeMap<String, IdentDescriptor>();
        for (String attribRef : attribReferences) {
            if (attribRef.equals("ID")) {
                nameToDescriptorMap.put("ID", new IdentDescriptor(key));
                continue;
            }
            Object attribValue = tableImpl.getValue(key, attribRef);
            if (attribValue == null) {
                Object defaultValue = defaultValues.get(attribRef);
                if (defaultValue != null) {
                    attribValue = defaultValue;
                } else {
                    currentlyActiveAttributes.clear();
                    try {
                        lastInternalError.append("Missing value for referenced column \"" + attribRef + "\".");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return null;
                }
            }
            try {
                nameToDescriptorMap.put(attribRef, new IdentDescriptor(attribValue));
            }
            catch (Exception e) {
                currentlyActiveAttributes.clear();
                try {
                    lastInternalError.append("Bad column reference to \"" + attribRef + "\".");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        }
        try {
            Object result = interpreter.execute(equation, nameToDescriptorMap);
            currentlyActiveAttributes.remove(columnName);
            return result;
        }
        catch (Exception e) {
            currentlyActiveAttributes.clear();
            try {
                lastInternalError.append(e.getMessage());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }
}

