/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.model.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.cytoscape.equations.Equation;
import org.cytoscape.equations.Interpreter;
import org.cytoscape.event.CyEvent;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.SUIDFactory;
import org.cytoscape.model.SavePolicy;
import org.cytoscape.model.VirtualColumnInfo;
import org.cytoscape.model.events.ColumnCreatedEvent;
import org.cytoscape.model.events.ColumnDeletedEvent;
import org.cytoscape.model.events.ColumnNameChangedEvent;
import org.cytoscape.model.events.RowSetRecord;
import org.cytoscape.model.events.RowsCreatedEvent;
import org.cytoscape.model.events.RowsDeletedEvent;
import org.cytoscape.model.events.RowsSetEvent;
import org.cytoscape.model.events.TableAddedEvent;
import org.cytoscape.model.events.TableAddedListener;
import org.cytoscape.model.events.TablePrivacyChangedEvent;
import org.cytoscape.model.events.TableTitleChangedEvent;
import org.cytoscape.model.internal.CyColumnImpl;
import org.cytoscape.model.internal.CyListImpl;
import org.cytoscape.model.internal.EqnSupport;
import org.cytoscape.model.internal.NonVirtualColumnInfo;
import org.cytoscape.model.internal.VirtualColumn;
import org.cytoscape.model.internal.column.ColumnData;
import org.cytoscape.model.internal.column.ColumnDataFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CyTableImpl
implements CyTable,
TableAddedListener {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private Set<String> currentlyActiveAttributes;
    private Map<String, ColumnData> attributes;
    private Map<Object, CyRow> rows;
    private Map<String, CyColumn> types;
    private ArrayList<CyColumn> colList;
    private ArrayList<CyRow> rowList;
    private Map<String, Set<CyColumn>> dependents;
    private Map<String, String> normalizedColumnNames;
    private String title;
    private boolean pub;
    private boolean isImmutable;
    private final Long suid;
    private String primaryKey;
    private Class<?> primaryKeyType;
    private final ColumnDataFactory columnFactory;
    private final CyEventHelper eventHelper;
    private final Interpreter interpreter;
    private final int defaultInitSize;
    String lastInternalError;
    private Map<String, VirtualColumn> virtualColumnMap;
    private SavePolicy savePolicy;
    private boolean fireEvents;
    private final Object lock = new Object();

    public CyTableImpl(String title, String primaryKey, Class<?> primaryKeyType, boolean pub, boolean isMutable, SavePolicy savePolicy, CyEventHelper eventHelper, ColumnDataFactory columnFactory, Interpreter interpreter, int defaultInitSize) {
        this.title = title;
        this.primaryKey = primaryKey;
        this.primaryKeyType = primaryKeyType;
        this.pub = pub;
        this.isImmutable = !isMutable;
        this.suid = SUIDFactory.getNextSUID();
        this.eventHelper = eventHelper;
        this.columnFactory = columnFactory;
        this.interpreter = interpreter;
        this.savePolicy = savePolicy;
        this.fireEvents = false;
        this.defaultInitSize = defaultInitSize;
        this.currentlyActiveAttributes = new HashSet<String>();
        this.attributes = new HashMap<String, ColumnData>();
        this.rows = new ConcurrentHashMap<Object, CyRow>(defaultInitSize, 0.5f, 2);
        this.types = new ConcurrentHashMap<String, CyColumn>(16, 0.75f, 2);
        this.colList = new ArrayList();
        this.rowList = new ArrayList();
        this.dependents = new HashMap<String, Set<CyColumn>>();
        this.normalizedColumnNames = new HashMap<String, String>();
        VirtualColumnInfo virtualInfo = NonVirtualColumnInfo.create(true);
        String normalizedPKName = this.normalizeColumnName(primaryKey);
        this.types.put(normalizedPKName, new CyColumnImpl(this, primaryKey, primaryKeyType, null, virtualInfo, true, true, null));
        this.colList.add(this.getColumn(normalizedPKName));
        this.attributes.put(normalizedPKName, columnFactory.create(primaryKeyType, primaryKeyType, null, defaultInitSize));
        this.virtualColumnMap = new HashMap<String, VirtualColumn>();
    }

    void clearDuplicateStringCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void swap(CyTable otherTable) {
        Object object = this.lock;
        synchronized (object) {
            CyTableImpl other = (CyTableImpl)otherTable;
            Set<String> tempCurrentlyActiveAttributes = this.currentlyActiveAttributes;
            this.currentlyActiveAttributes = other.currentlyActiveAttributes;
            other.currentlyActiveAttributes = tempCurrentlyActiveAttributes;
            Map<String, ColumnData> tempAttributes = this.attributes;
            this.attributes = other.attributes;
            other.attributes = tempAttributes;
            Map<Object, CyRow> tempRows = this.rows;
            this.rows = other.rows;
            other.rows = tempRows;
            Map<String, CyColumn> tempTypes = this.types;
            this.types = other.types;
            other.types = tempTypes;
            ArrayList<CyColumn> tempListCol = this.colList;
            this.colList = other.colList;
            other.colList = tempListCol;
            ArrayList<CyRow> tempListRow = this.rowList;
            this.rowList = other.rowList;
            other.rowList = tempListRow;
            Map<String, String> tempNormalizedColNames = this.normalizedColumnNames;
            this.normalizedColumnNames = other.normalizedColumnNames;
            other.normalizedColumnNames = tempNormalizedColNames;
            String tempTitle = this.title;
            this.title = other.title;
            other.title = tempTitle;
            boolean tempPub = this.pub;
            this.pub = other.pub;
            other.pub = tempPub;
            boolean tempIsImmutable = this.isImmutable;
            this.isImmutable = other.isImmutable;
            other.isImmutable = tempIsImmutable;
            String tempPrimaryKey = this.primaryKey;
            this.primaryKey = other.primaryKey;
            other.primaryKey = tempPrimaryKey;
            String tempLastInternalError = this.lastInternalError;
            this.lastInternalError = other.lastInternalError;
            other.lastInternalError = tempLastInternalError;
            Map<String, VirtualColumn> tempVirtualColumnMap = this.virtualColumnMap;
            this.virtualColumnMap = other.virtualColumnMap;
            other.virtualColumnMap = tempVirtualColumnMap;
            Map<String, Set<CyColumn>> tempDependents = this.dependents;
            this.dependents = other.dependents;
            other.dependents = tempDependents;
            SavePolicy tempSavePolicy = this.savePolicy;
            this.savePolicy = other.savePolicy;
            other.savePolicy = tempSavePolicy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateColumnName(String oldColumnName, String newColumnName) {
        Object object = this.lock;
        synchronized (object) {
            Set<CyColumn> columnDependents;
            if (this.currentlyActiveAttributes.remove(oldColumnName)) {
                this.currentlyActiveAttributes.add(newColumnName);
            }
            String normalizedOldColName = this.normalizeColumnName(oldColumnName);
            String normalizedNewColName = this.normalizeColumnName(newColumnName);
            ColumnData keyValuePairs = this.attributes.get(normalizedOldColName);
            if (keyValuePairs != null) {
                this.attributes.remove(normalizedOldColName);
                this.attributes.put(normalizedNewColName, keyValuePairs);
            }
            CyColumn column = this.types.get(normalizedOldColName);
            this.types.remove(normalizedOldColName);
            this.types.put(normalizedNewColName, column);
            VirtualColumn virtualColumn = this.virtualColumnMap.get(normalizedOldColName);
            if (virtualColumn != null) {
                this.virtualColumnMap.remove(normalizedOldColName);
                this.virtualColumnMap.put(normalizedNewColName, virtualColumn);
            }
            if ((columnDependents = this.dependents.get(normalizedOldColName)) != null) {
                this.dependents.remove(normalizedOldColName);
                this.dependents.put(normalizedNewColName, columnDependents);
            }
        }
        this.eventHelper.fireEvent((CyEvent)new ColumnNameChangedEvent((CyTable)this, oldColumnName, newColumnName));
    }

    boolean eventsEnabled() {
        return this.fireEvents;
    }

    public Long getSUID() {
        return this.suid;
    }

    public boolean isPublic() {
        return this.pub;
    }

    public void setPublic(boolean isPublic) {
        if (this.pub != isPublic) {
            this.pub = isPublic;
            if (this.fireEvents) {
                this.eventHelper.fireEvent((CyEvent)new TablePrivacyChangedEvent((CyTable)this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CyTable.Mutability getMutability() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isImmutable) {
                return CyTable.Mutability.PERMANENTLY_IMMUTABLE;
            }
            if (this.getDependentCount() == 0) {
                return CyTable.Mutability.MUTABLE;
            }
            return CyTable.Mutability.IMMUTABLE_DUE_TO_VIRT_COLUMN_REFERENCES;
        }
    }

    private final int getDependentCount() {
        int count = 0;
        for (Set<CyColumn> columnDependents : this.dependents.values()) {
            count += columnDependents.size();
        }
        return count;
    }

    public String getTitle() {
        return this.title;
    }

    public String toString() {
        return this.title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTitle(String title) {
        boolean valueChanged;
        String oldTitle = null;
        Object object = this.lock;
        synchronized (object) {
            boolean bl = valueChanged = !this.title.equals(title);
            if (valueChanged) {
                oldTitle = this.title;
                this.title = title;
            }
        }
        if (valueChanged && this.fireEvents && this.fireEvents) {
            this.eventHelper.fireEvent((CyEvent)new TableTitleChangedEvent((CyTable)this, oldTitle));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CyColumn> getColumns() {
        Object object = this.lock;
        synchronized (object) {
            return new ArrayList<CyColumn>(this.colList);
        }
    }

    public CyColumn getColumn(String columnName) {
        return this.types.get(this.normalizeColumnName(columnName));
    }

    public CyColumn getPrimaryKey() {
        return this.types.get(this.normalizeColumnName(this.primaryKey));
    }

    public int getRowCount() {
        return this.rows.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteColumn(String columnName) {
        Long suid = null;
        Object object = this.lock;
        synchronized (object) {
            if (columnName == null) {
                throw new NullPointerException("\"columnName\" must not be null.");
            }
            String normalizedColName = this.normalizeColumnName(columnName);
            CyColumn column = this.types.get(normalizedColName);
            if (column == null) {
                return;
            }
            suid = column.getSUID();
            if (column.isImmutable()) {
                throw new IllegalArgumentException("cannot delete immutable column \"" + columnName + "\".");
            }
            VirtualColumn virtColumn = this.virtualColumnMap.get(normalizedColName);
            if (this.attributes.containsKey(normalizedColName) || virtColumn != null) {
                if (virtColumn != null) {
                    CyColumn cyColumn = this.types.get(normalizedColName);
                    this.virtualColumnMap.remove(normalizedColName);
                    this.attributes.remove(normalizedColName);
                    this.types.remove(normalizedColName);
                    this.colList.remove(cyColumn);
                    VirtualColumnInfo info = cyColumn.getVirtualColumnInfo();
                    ((CyTableImpl)info.getSourceTable()).removeDependent(info.getSourceColumn(), cyColumn);
                } else {
                    this.attributes.remove(normalizedColName);
                    this.colList.remove(this.types.get(normalizedColName));
                    this.types.remove(normalizedColName);
                }
            }
        }
        this.eventHelper.fireEvent((CyEvent)new ColumnDeletedEvent((CyTable)this, columnName, suid));
    }

    private void addDependent(String columnName, CyColumn joinedColumn) {
        String normalizedName = this.normalizeColumnName(columnName);
        Set<CyColumn> set = this.dependents.get(normalizedName);
        if (set == null) {
            set = new HashSet<CyColumn>();
            this.dependents.put(normalizedName, set);
        }
        set.add(joinedColumn);
    }

    private void removeDependent(String columnName, CyColumn joinedColumn) {
        String normalizedName = this.normalizeColumnName(columnName);
        Set<CyColumn> set = this.dependents.get(normalizedName);
        if (set == null) {
            return;
        }
        set.remove(joinedColumn);
    }

    public <T> void createColumn(String columnName, Class<? extends T> type, boolean isImmutable) {
        this.createColumn(columnName, type, isImmutable, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void createColumn(String columnName, Class<? extends T> type, boolean isImmutable, T defaultValue) {
        Long suid;
        Object object = this.lock;
        synchronized (object) {
            if (columnName == null) {
                throw new NullPointerException("column name is null");
            }
            String normalizedColName = this.normalizeColumnName(columnName);
            if (this.types.containsKey(normalizedColName)) {
                throw new IllegalArgumentException("column already exists with name: '" + columnName + "' with type: " + this.types.get(normalizedColName).getType());
            }
            if (type == null) {
                throw new NullPointerException("type is null");
            }
            if (type == List.class) {
                throw new IllegalArgumentException("use createListColumn() to create List columns instead of createColumn for column '" + columnName + "'.");
            }
            this.checkClass(type);
            VirtualColumnInfo virtualInfo = NonVirtualColumnInfo.create(isImmutable);
            CyColumnImpl column = new CyColumnImpl(this, columnName, type, null, virtualInfo, false, isImmutable, defaultValue);
            suid = column.getSUID();
            this.types.put(normalizedColName, column);
            this.attributes.put(normalizedColName, this.columnFactory.create(this.primaryKeyType, type, null, this.defaultInitSize));
            this.colList.add(this.types.get(normalizedColName));
        }
        this.eventHelper.fireEvent((CyEvent)new ColumnCreatedEvent((CyTable)this, columnName, suid));
    }

    public <T> void createListColumn(String columnName, Class<T> listElementType, boolean isImmutable) {
        this.createListColumn(columnName, listElementType, isImmutable, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void createListColumn(String columnName, Class<T> listElementType, boolean isImmutable, List<T> defaultValue) {
        Long suid;
        Object object = this.lock;
        synchronized (object) {
            if (columnName == null) {
                throw new NullPointerException("column name is null");
            }
            String normalizedColName = this.normalizeColumnName(columnName);
            if (this.types.containsKey(normalizedColName)) {
                throw new IllegalArgumentException("column already exists with name: '" + columnName + "' with type: " + this.types.get(normalizedColName).getType());
            }
            if (listElementType == null) {
                throw new NullPointerException("listElementType is null");
            }
            this.checkClass(listElementType);
            VirtualColumnInfo virtualInfo = NonVirtualColumnInfo.create(isImmutable);
            CyColumnImpl column = new CyColumnImpl(this, columnName, List.class, listElementType, virtualInfo, false, isImmutable, defaultValue);
            this.types.put(normalizedColName, column);
            suid = column.getSUID();
            this.attributes.put(normalizedColName, this.columnFactory.create(this.primaryKeyType, List.class, listElementType, this.defaultInitSize));
            this.colList.add(this.types.get(normalizedColName));
        }
        this.eventHelper.fireEvent((CyEvent)new ColumnCreatedEvent((CyTable)this, columnName, suid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> List<T> getColumnValues(String columnName, Class<? extends T> type) {
        if (columnName == null) {
            throw new NullPointerException("column name is null.");
        }
        if (type == null) {
            throw new NullPointerException("column type is null.");
        }
        Object object = this.lock;
        synchronized (object) {
            ArrayList<Object> l = new ArrayList<Object>();
            for (Object key : this.rows.keySet()) {
                l.add(this.getValue(key, columnName, type));
            }
            return l;
        }
    }

    CyRow getRowNoCreate(Object key) {
        this.checkKey(key);
        return this.rows.get(key);
    }

    public CyRow getRow(Object key) {
        this.checkKey(key);
        CyRow row = this.rows.get(key);
        if (row != null) {
            return row;
        }
        row = new InternalRow(key);
        this.rows.put(key, row);
        this.rowList.add(row);
        if (this.fireEvents) {
            this.eventHelper.addEventPayload((Object)this, key, RowsCreatedEvent.class);
        }
        return row;
    }

    public boolean rowExists(Object primaryKey) {
        return primaryKey != null && this.rows.containsKey(primaryKey);
    }

    public String getLastInternalError() {
        return this.lastInternalError;
    }

    private final void checkKey(Object suid) {
        if (suid == null) {
            throw new NullPointerException("key is null");
        }
        if (!this.types.get(this.normalizeColumnName(this.primaryKey)).getType().isAssignableFrom(suid.getClass())) {
            throw new IllegalArgumentException("key of type " + suid.getClass() + " and not the expected: " + this.types.get(this.normalizeColumnName(this.primaryKey)).getType().getName());
        }
    }

    public List<CyRow> getAllRows() {
        return this.rowList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CyRow> getMatchingRows(String columnName, Object value) {
        Object object = this.lock;
        synchronized (object) {
            String normalizedColName = this.normalizeColumnName(columnName);
            VirtualColumn virtColumn = this.virtualColumnMap.get(normalizedColName);
            if (virtColumn != null) {
                return virtColumn.getMatchingRows(value);
            }
            if (normalizedColName.equals(this.normalizeColumnName(this.primaryKey))) {
                CyRow matchingRow = this.rows.get(value);
                List<Object> list = matchingRow == null ? Collections.emptyList() : Collections.singletonList(matchingRow);
                return list;
            }
            ColumnData keyToValueMap = this.attributes.get(normalizedColName);
            return keyToValueMap.getMatchingRows(this.rows, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Collection<T> getMatchingKeys(String columnName, Object value, Class<T> type) {
        Object object = this.lock;
        synchronized (object) {
            String normalizedColName = this.normalizeColumnName(columnName);
            VirtualColumn virtColumn = this.virtualColumnMap.get(normalizedColName);
            if (virtColumn != null) {
                return virtColumn.getMatchingKeys(value, type);
            }
            if (normalizedColName.equals(this.normalizeColumnName(this.primaryKey))) {
                CyRow matchingRow = this.rows.get(value);
                List list = matchingRow == null ? Collections.emptyList() : Collections.singletonList(type.cast(value));
                return list;
            }
            ColumnData keyToValueMap = this.attributes.get(normalizedColName);
            return keyToValueMap.getMatchingKeys(value, type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countMatchingRows(String columnName, Object value) {
        Object object = this.lock;
        synchronized (object) {
            String normalizedColName = this.normalizeColumnName(columnName);
            VirtualColumn virtColumn = this.virtualColumnMap.get(normalizedColName);
            if (virtColumn != null) {
                return virtColumn.countMatchingRows(value);
            }
            ColumnData keyToValueMap = this.attributes.get(normalizedColName);
            return keyToValueMap.countMatchingRows(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setX(Object key, String columnName, Object value) {
        Object newRawValue;
        Object newValue;
        VirtualColumn virtColumn;
        boolean isList;
        if (columnName == null) {
            throw new NullPointerException("columnName must not be null.");
        }
        if (value == null) {
            throw new NullPointerException("value must not be null.");
        }
        Object object = this.lock;
        synchronized (object) {
            String normalizedColName = this.normalizeColumnName(columnName);
            if (this.types.get(normalizedColName) == null) {
                throw new IllegalArgumentException("column: '" + columnName + "' does not yet exist.");
            }
            Class columnType = this.types.get(normalizedColName).getType();
            isList = columnType == List.class;
        }
        if (isList) {
            this.setListX(key, columnName, value);
            return;
        }
        boolean changed = true;
        Object object2 = this.lock;
        synchronized (object2) {
            String normalizedColName = this.normalizeColumnName(columnName);
            if (this.types.get(normalizedColName) == null) {
                throw new IllegalArgumentException("column: '" + columnName + "' does not yet exist.");
            }
            Class columnType = this.types.get(normalizedColName).getType();
            if (!(value instanceof Equation)) {
                this.checkType(value);
            }
            if ((virtColumn = this.virtualColumnMap.get(normalizedColName)) != null) {
                virtColumn.setValue(key, value);
                newValue = virtColumn.getValue(key);
                newRawValue = virtColumn.getRawValue(key);
            } else {
                ColumnData keyToValueMap = this.attributes.get(normalizedColName);
                if (!columnType.isAssignableFrom(value.getClass()) && !EqnSupport.scalarEquationIsCompatible(value, columnType)) {
                    throw new IllegalArgumentException("value of \"" + columnName + "\" is not of type " + columnType);
                }
                if (value instanceof Equation) {
                    newRawValue = value;
                    Equation equation = (Equation)value;
                    keyToValueMap.put(key, equation);
                    StringBuilder errorMsg = new StringBuilder();
                    newValue = this.evalEquation(equation, key, columnName, errorMsg);
                    this.lastInternalError = errorMsg.toString();
                } else {
                    newRawValue = newValue = columnType.cast(value);
                    changed = keyToValueMap.put(key, newValue);
                }
            }
        }
        if (this.fireEvents && changed && virtColumn == null) {
            this.fireVirtualColumnRowSetEvent(this, key, columnName, newValue, newRawValue);
        }
    }

    private Object evalEquation(Equation equation, Object key, String columnName, Appendable errorsMessages) {
        return EqnSupport.evalEquation(equation, key, this.interpreter, this.currentlyActiveAttributes, columnName, errorsMessages, this);
    }

    private void fireVirtualColumnRowSetEvent(CyTableImpl table, Object key, String columnName, Object newValue, Object newRawValue) {
        this.fireVirtualColumnRowSetEvent(this, key, columnName, newValue, newRawValue, Collections.newSetFromMap(new IdentityHashMap()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireVirtualColumnRowSetEvent(CyTableImpl table, Object key, String columnName, Object newValue, Object newRawValue, Set<VirtualColumnInfo> seen) {
        Set<CyColumn> columnDependents;
        CyRow row = table.getRowNoCreate(key);
        if (row == null) {
            return;
        }
        this.eventHelper.addEventPayload((Object)table, (Object)new RowSetRecord(row, columnName, newValue, newRawValue), RowsSetEvent.class);
        Iterator<CyColumn> iterator = this.lock;
        synchronized (iterator) {
            String normalizedColumnName = this.normalizeColumnName(columnName);
            columnDependents = this.dependents.get(normalizedColumnName);
            if (columnDependents == null) {
                return;
            }
        }
        for (CyColumn dependent : columnDependents) {
            VirtualColumnInfo info = dependent.getVirtualColumnInfo();
            if (seen.contains(info)) continue;
            seen.add(info);
            CyTableImpl table2 = (CyTableImpl)dependent.getTable();
            String targetJoinKey = info.getTargetJoinKey();
            if (targetJoinKey.equals(table2.getPrimaryKey().getName())) {
                this.fireVirtualColumnRowSetEvent(table2, key, dependent.getName(), newValue, newRawValue, seen);
                continue;
            }
            String normalizedTargetJoinKey = table2.normalizeColumnName(targetJoinKey);
            ColumnData keyToValueMap = table2.attributes.get(normalizedTargetJoinKey);
            if (keyToValueMap == null) continue;
            for (Object key2 : keyToValueMap.keySet()) {
                if (!keyToValueMap.get(key2).equals(key)) continue;
                this.fireVirtualColumnRowSetEvent(table2, key2, dependent.getName(), newValue, newRawValue, seen);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setListX(Object key, String columnName, Object value) {
        Object newValue;
        VirtualColumn virtColumn;
        CyListImpl rawValue;
        boolean changed = true;
        Object object = this.lock;
        synchronized (object) {
            String normalizedColName = this.normalizeColumnName(columnName);
            CyColumn column = this.types.get(normalizedColName);
            CyRow row = this.rows.get(key);
            Class type = column.getListElementType();
            if (value instanceof CyListImpl) {
                rawValue = value;
            } else if (value instanceof List) {
                List list = value;
                if (!list.isEmpty()) {
                    this.checkType(list.get(0));
                }
                List<?> listData = this.columnFactory.createList(type, list);
                rawValue = new CyListImpl(type, listData, this.eventHelper, row, column, this);
            } else {
                if (!(value instanceof Equation)) {
                    throw new IllegalArgumentException("value is a " + value.getClass().getName() + " and not a List for column '" + columnName + "'.");
                }
                if (!EqnSupport.listEquationIsCompatible((Equation)value, type)) {
                    throw new IllegalArgumentException("value is not a List equation of a compatible type for column '" + columnName + "'.");
                }
                rawValue = value;
            }
            virtColumn = this.virtualColumnMap.get(normalizedColName);
            if (virtColumn != null) {
                virtColumn.setValue(key, rawValue);
                newValue = virtColumn.getListValue(key);
            } else {
                ColumnData keyToValueMap = this.attributes.get(normalizedColName);
                changed = keyToValueMap.put(key, rawValue);
                if (rawValue instanceof Equation) {
                    StringBuilder errorMsg = new StringBuilder();
                    newValue = this.evalEquation((Equation)rawValue, this.suid, columnName, errorMsg);
                    this.lastInternalError = errorMsg.toString();
                } else {
                    newValue = rawValue;
                }
            }
        }
        if (this.fireEvents && changed && virtColumn == null) {
            this.fireVirtualColumnRowSetEvent(this, key, columnName, newValue, rawValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unSetX(Object key, String columnName) {
        VirtualColumn virtColumn;
        boolean changed = true;
        Object object = this.lock;
        synchronized (object) {
            String normalizedColName = this.normalizeColumnName(columnName);
            virtColumn = this.virtualColumnMap.get(normalizedColName);
            if (virtColumn != null) {
                virtColumn.setValue(key, null);
            } else {
                ColumnData keyToValueMap = this.attributes.get(normalizedColName);
                if (!this.types.containsKey(normalizedColName) || keyToValueMap == null) {
                    throw new IllegalArgumentException("column: '" + columnName + "' does not yet exist.");
                }
                changed = keyToValueMap.remove(key);
            }
        }
        if (this.fireEvents && changed && virtColumn == null) {
            this.fireVirtualColumnRowSetEvent(this, key, columnName, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getValueOrEquation(Object key, String columnName) {
        Object object = this.lock;
        synchronized (object) {
            String normalizedColName = this.normalizeColumnName(columnName);
            return this.getValueOrEquation(key, columnName, this.virtualColumnMap.get(normalizedColName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object getValueOrEquation(Object key, String columnName, VirtualColumn virtColumn) {
        Object object = this.lock;
        synchronized (object) {
            String normalizedColName = this.normalizeColumnName(columnName);
            if (this.primaryKey.equalsIgnoreCase(normalizedColName)) {
                return key;
            }
            if (virtColumn != null) {
                return virtColumn.getRawValue(key);
            }
            ColumnData keyToValueMap = this.attributes.get(normalizedColName);
            if (keyToValueMap == null) {
                return null;
            }
            return keyToValueMap.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T getX(Object key, String columnName, Class<? extends T> type, T defaultValue) {
        Object value;
        if (type.isAssignableFrom(List.class)) {
            logger.debug("risky use of get() instead of getList() for retrieving list");
        }
        this.lastInternalError = null;
        Object object = this.lock;
        synchronized (object) {
            value = this.getValue(key, columnName, type);
            if (value == null) {
                return this.getDefaultValue(columnName, defaultValue);
            }
        }
        return type.cast(value);
    }

    Object getValue(Object key, String columnName) {
        CyColumn column = this.getColumn(columnName);
        Class type = column == null ? null : column.getType();
        return this.getValue(key, columnName, type);
    }

    private final Object getValue(Object key, String columnName, Class<?> type) {
        String normalizedColName = this.normalizeColumnName(columnName);
        VirtualColumn virtColumn = this.virtualColumnMap.get(normalizedColName);
        Object vl = this.getValueOrEquation(key, columnName, virtColumn);
        if (virtColumn != null && vl == null) {
            return virtColumn.getValue(key);
        }
        if (vl == null) {
            return null;
        }
        if (vl instanceof Equation) {
            StringBuilder errorMsg = new StringBuilder();
            Object value = this.evalEquation((Equation)vl, key, columnName, errorMsg);
            this.lastInternalError = errorMsg.toString();
            if (type == null) {
                return value;
            }
            if (value != null) {
                return EqnSupport.convertEqnResultToColumnType(type, value);
            }
            return null;
        }
        return vl;
    }

    private final <T> T getDefaultValue(String columnName, T defaultValue) {
        if (defaultValue == null) {
            CyColumn column = this.getColumn(columnName);
            if (column == null) {
                return null;
            }
            return (T)column.getDefaultValue();
        }
        return defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> List<T> getListX(Object key, String columnName, Class<? extends T> listElementType, List<T> defaultValue) {
        Object object = this.lock;
        synchronized (object) {
            String normalizedColName = this.normalizeColumnName(columnName);
            CyColumn type = this.types.get(normalizedColName);
            if (type == null) {
                logger.warn("'" + columnName + "' does not yet exist.");
                return defaultValue;
            }
            Class expectedListElementType = type.getListElementType();
            if (expectedListElementType == null) {
                throw new IllegalArgumentException("'" + columnName + "' is not a List.");
            }
            if (expectedListElementType != listElementType) {
                throw new IllegalArgumentException("invalid list element type for column '" + columnName + ", found: " + listElementType.getName() + ", expected: " + expectedListElementType.getName() + ".");
            }
            this.lastInternalError = null;
            VirtualColumn virtColumn = this.virtualColumnMap.get(normalizedColName);
            Object vl = this.getValueOrEquation(key, columnName, virtColumn);
            if (virtColumn != null && vl == null) {
                return (List)virtColumn.getListValue(key);
            }
            if (vl == null) {
                return this.getDefaultValue(columnName, defaultValue);
            }
            if (vl instanceof Equation) {
                StringBuilder errorMsg = new StringBuilder();
                Object result = this.evalEquation((Equation)vl, key, columnName, errorMsg);
                if (result == null || result instanceof List) {
                    this.lastInternalError = errorMsg.toString();
                    return (List)result;
                }
                this.lastInternalError = "Invalid type for List column";
                return null;
            }
            return (List)vl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> boolean isSetX(Object key, String columnName) {
        Object object = this.lock;
        synchronized (object) {
            String normalizedColName = this.normalizeColumnName(columnName);
            if (this.primaryKey.equalsIgnoreCase(normalizedColName)) {
                return true;
            }
            VirtualColumn virtColumn = this.virtualColumnMap.get(normalizedColName);
            if (virtColumn != null) {
                return virtColumn.getRawValue(key) != null;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl12 : MonitorExitStatement: MONITOREXIT : var3_3
            ColumnData keyToValueMap = this.attributes.get(normalizedColName);
            return keyToValueMap != null && keyToValueMap.get(key) != null;
        }
    }

    private void checkClass(Class<?> c) {
        if (c == Integer.class || c == Long.class || c == Double.class || c == String.class || c == Boolean.class) {
            return;
        }
        throw new IllegalArgumentException("invalid class: " + c.getName());
    }

    private final void checkType(Object o) {
        if (o instanceof String) {
            return;
        }
        if (o instanceof Integer) {
            return;
        }
        if (o instanceof Boolean) {
            return;
        }
        if (o instanceof Double) {
            return;
        }
        if (o instanceof Long) {
            return;
        }
        throw new IllegalArgumentException("invalid type: " + o.getClass().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String addVirtualColumn(String virtualColumnName, String sourceColumnName, CyTable sourceTable, String targetJoinKeyName, boolean isImmutable) {
        if (virtualColumnName == null) {
            throw new NullPointerException("\"virtualColumn\" argument must never be null.");
        }
        if (sourceColumnName == null) {
            throw new NullPointerException("\"sourceColumn\" argument must never be null.");
        }
        if (sourceTable == null) {
            throw new NullPointerException("\"sourceTable\" argument must never be null.");
        }
        if (targetJoinKeyName == null) {
            throw new NullPointerException("\"targetJoinKey\" argument must never be null.");
        }
        String targetName = "failed to create column";
        Long suid = null;
        Object object = this.lock;
        synchronized (object) {
            String normalizedColName = this.normalizeColumnName(virtualColumnName);
            if (this.types.containsKey(normalizedColName)) {
                throw new IllegalArgumentException("column already exists with name: '" + virtualColumnName + "' with type: " + this.types.get(normalizedColName).getType());
            }
            CyColumn sourceColumn = sourceTable.getColumn(this.normalizeColumnName(sourceColumnName));
            if (sourceColumn == null) {
                throw new IllegalArgumentException("\"" + sourceColumnName + "\" is not a column in source table.");
            }
            CyColumn targetJoinKey = this.getColumn(targetJoinKeyName);
            if (targetJoinKey == null) {
                throw new IllegalArgumentException("\"" + targetJoinKeyName + "\" is not a known column in this table.");
            }
            CyColumn sourceJoinKey = sourceTable.getPrimaryKey();
            if (sourceJoinKey.getType() != targetJoinKey.getType()) {
                throw new IllegalArgumentException("\"" + sourceJoinKey.getName() + "\" has a different type from \"" + targetJoinKeyName + "\".");
            }
            VirtualColumn virtualColumn = new VirtualColumn((CyTableImpl)sourceTable, sourceColumnName, this, sourceTable.getPrimaryKey().getName(), targetJoinKeyName, isImmutable);
            targetName = virtualColumnName;
            CyColumnImpl targetColumn = new CyColumnImpl(this, targetName, sourceColumn.getType(), sourceColumn.getListElementType(), virtualColumn, false, isImmutable, sourceColumn.getDefaultValue());
            suid = targetColumn.getSUID();
            ((CyTableImpl)sourceTable).addDependent(sourceColumnName, targetColumn);
            String normalizedTargetName = this.normalizeColumnName(targetName);
            this.types.put(normalizedTargetName, targetColumn);
            this.attributes.put(normalizedTargetName, this.columnFactory.create(this.primaryKeyType, sourceColumn.getType(), sourceColumn.getListElementType(), this.defaultInitSize));
            this.virtualColumnMap.put(normalizedTargetName, virtualColumn);
            this.colList.add(this.types.get(normalizedTargetName));
        }
        this.eventHelper.fireEvent((CyEvent)new ColumnCreatedEvent((CyTable)this, targetName, suid));
        return targetName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAllVirtColumns() {
        Object object = this.lock;
        synchronized (object) {
            if (this.getDependentCount() > 0) {
                return;
            }
            for (String columnName : this.virtualColumnMap.keySet()) {
                CyColumn column = this.types.get(columnName);
                this.types.remove(columnName);
                this.colList.remove(column);
                VirtualColumnInfo info = column.getVirtualColumnInfo();
                ((CyTableImpl)info.getSourceTable()).removeDependent(info.getSourceColumn(), column);
            }
            this.virtualColumnMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addVirtualColumns(CyTable sourceTable, String targetJoinKeyName, boolean isImmutable) {
        Object object = this.lock;
        synchronized (object) {
            if (sourceTable == null) {
                throw new NullPointerException("\"sourceTable\" argument must never be null.");
            }
            if (targetJoinKeyName == null) {
                throw new NullPointerException("\"targetJoinKeyName\" argument must never be null.");
            }
            CyColumn targetJoinKey = this.getColumn(targetJoinKeyName);
            if (targetJoinKey == null) {
                throw new IllegalArgumentException("\"" + targetJoinKeyName + "\" is not a known column in this table (" + this.getTitle() + ").");
            }
            CyColumn sourceJoinKey = sourceTable.getPrimaryKey();
            if (sourceJoinKey.getType() != targetJoinKey.getType()) {
                throw new IllegalArgumentException("\"" + sourceJoinKey.getName() + "\" has a different type from \"" + targetJoinKeyName + "\".");
            }
            Collection columns = sourceTable.getColumns();
            for (CyColumn column : columns) {
                String normalizedColName;
                if (column == sourceTable.getPrimaryKey() || !this.types.containsKey(normalizedColName = this.normalizeColumnName(column.getName()))) continue;
                throw new IllegalArgumentException("column already exists with name: '" + column.getName() + "' with type: " + this.types.get(normalizedColName).getType());
            }
            for (CyColumn column : columns) {
                if (column == sourceTable.getPrimaryKey()) continue;
                String columnName = column.getName();
                this.addVirtualColumn(columnName, columnName, sourceTable, targetJoinKeyName, isImmutable);
            }
        }
    }

    public SavePolicy getSavePolicy() {
        return this.savePolicy;
    }

    public void setSavePolicy(SavePolicy policy) {
        this.savePolicy = policy;
    }

    public void handleEvent(TableAddedEvent e) {
        if (e.getTable() == this) {
            this.fireEvents = true;
        }
    }

    private final String normalizeColumnName(String initialName) {
        String name = this.normalizedColumnNames.get(initialName);
        if (name == null) {
            name = initialName.toLowerCase();
            this.normalizedColumnNames.put(initialName, name);
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteRows(Collection<?> primaryKeys) {
        boolean changed = false;
        Object object = this.lock;
        synchronized (object) {
            Collection<CyColumn> columns = this.getColumns();
            ArrayList<ColumnData> attributeMaps = new ArrayList<ColumnData>(columns.size());
            for (CyColumn col : columns) {
                String normalizedColName = this.normalizeColumnName(col.getName());
                ColumnData keyToValueMap = this.attributes.get(normalizedColName);
                if (keyToValueMap == null) continue;
                attributeMaps.add(keyToValueMap);
            }
            HashSet<CyRow> rowsToRemoveFromList = new HashSet<CyRow>();
            for (Object key : primaryKeys) {
                this.checkKey(key);
                CyRow row = this.rows.remove(key);
                if (row == null) continue;
                rowsToRemoveFromList.add(row);
                for (ColumnData keyToValueMap : attributeMaps) {
                    keyToValueMap.remove(key);
                }
                changed = true;
            }
            this.rowList.removeAll(rowsToRemoveFromList);
        }
        if (changed) {
            this.eventHelper.fireEvent((CyEvent)new RowsDeletedEvent((CyTable)this, primaryKeys));
        }
        return changed;
    }

    private final class InternalRow
    implements CyRow {
        private final Object key;
        private final Long suid = SUIDFactory.getNextSUID();

        InternalRow(Object key) {
            this.key = key;
        }

        public Long getSUID() {
            return this.suid;
        }

        public void set(String attributeName, Object value) {
            if (value == null) {
                CyTableImpl.this.unSetX(this.key, attributeName);
            } else {
                CyTableImpl.this.setX(this.key, attributeName, value);
            }
        }

        public <T> T get(String attributeName, Class<? extends T> c) {
            return CyTableImpl.this.getX(this.key, attributeName, c, null);
        }

        public <T> T get(String attributeName, Class<? extends T> c, T defValue) {
            return CyTableImpl.this.getX(this.key, attributeName, c, defValue);
        }

        public <T> List<T> getList(String attributeName, Class<T> c) {
            return CyTableImpl.this.getListX(this.key, attributeName, c, null);
        }

        public <T> List<T> getList(String attributeName, Class<T> c, List<T> defValue) {
            return CyTableImpl.this.getListX(this.key, attributeName, c, defValue);
        }

        public Object getRaw(String attributeName) {
            return CyTableImpl.this.getValueOrEquation(this.key, attributeName);
        }

        public boolean isSet(String attributeName) {
            return CyTableImpl.this.isSetX(this.key, attributeName);
        }

        public Map<String, Object> getAllValues() {
            HashMap<String, Object> nameToValueMap = new HashMap<String, Object>(CyTableImpl.this.types.size());
            for (CyColumn column : CyTableImpl.this.types.values()) {
                String columnName = column.getName();
                Class type = column.getType();
                if (type == List.class) {
                    Class elementType = column.getListElementType();
                    nameToValueMap.put(columnName, CyTableImpl.this.getListX(this.key, columnName, elementType, null));
                    continue;
                }
                nameToValueMap.put(columnName, CyTableImpl.this.getX(this.key, columnName, type, null));
            }
            return nameToValueMap;
        }

        public CyTable getTable() {
            return CyTableImpl.this;
        }

        public String toString() {
            return "Table: " + CyTableImpl.this.title + " SUID: " + this.suid + " isImmutable: " + CyTableImpl.this.isImmutable + " public: " + CyTableImpl.this.pub;
        }
    }
}

