/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.model.internal;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.cytoscape.equations.Interpreter;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableFactory;
import org.cytoscape.model.SavePolicy;
import org.cytoscape.model.events.TableAddedEvent;
import org.cytoscape.model.events.TableAddedListener;
import org.cytoscape.model.internal.CyTableImpl;
import org.cytoscape.model.internal.column.ColumnDataFactory;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.session.events.SessionLoadedEvent;
import org.cytoscape.session.events.SessionLoadedListener;

public class CyTableFactoryImpl
implements CyTableFactory,
SessionLoadedListener {
    private final CyEventHelper eventHelper;
    private final CyServiceRegistrar serviceRegistrar;
    private final WeakEventDelegator eventDelegator;
    private final ColumnDataFactory columnFactory;

    public CyTableFactoryImpl(CyEventHelper eventHelper, CyServiceRegistrar serviceRegistrar) {
        this.eventHelper = eventHelper;
        this.serviceRegistrar = serviceRegistrar;
        this.eventDelegator = new WeakEventDelegator();
        this.columnFactory = ColumnDataFactory.createDefaultFactory();
        this.serviceRegistrar.registerService((Object)this.eventDelegator, TableAddedListener.class, new Properties());
    }

    public CyTable createTable(String name, String primaryKey, Class<?> primaryKeyType, boolean pub, boolean isMutable) {
        return this.createTable(name, primaryKey, primaryKeyType, pub, isMutable, CyTableFactory.InitialTableSize.MEDIUM);
    }

    public CyTable createTable(String name, String primaryKey, Class<?> primaryKeyType, boolean pub, boolean isMutable, CyTableFactory.InitialTableSize size) {
        CyTableImpl table = new CyTableImpl(name, primaryKey, primaryKeyType, pub, isMutable, SavePolicy.SESSION_FILE, this.eventHelper, this.columnFactory, (Interpreter)this.serviceRegistrar.getService(Interpreter.class), size.getSize());
        this.eventDelegator.addListener(table);
        return table;
    }

    public void handleEvent(SessionLoadedEvent e) {
        this.columnFactory.clearCache();
    }

    private class WeakEventDelegator
    implements TableAddedListener {
        List<WeakReference<TableAddedListener>> tables = new ArrayList<WeakReference<TableAddedListener>>();

        private WeakEventDelegator() {
        }

        public synchronized void addListener(TableAddedListener t) {
            this.tables.add(new WeakReference<TableAddedListener>(t));
        }

        public synchronized void handleEvent(TableAddedEvent e) {
            for (WeakReference<TableAddedListener> ref : this.tables) {
                TableAddedListener l = (TableAddedListener)ref.get();
                if (l == null) continue;
                l.handleEvent(e);
            }
        }
    }
}

