/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.model.internal;

import org.cytoscape.event.CyEvent;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.events.SetNetworkPointerEvent;
import org.cytoscape.model.events.UnsetNetworkPointerEvent;
import org.cytoscape.model.internal.CyIdentifiableImpl;

class CyNodeImpl
extends CyIdentifiableImpl
implements CyNode {
    private final CyEventHelper eventHelper;
    private CyNetwork nestedNet = null;

    CyNodeImpl(long suid, long ind, CyEventHelper eventHelper) {
        super(suid);
        this.eventHelper = eventHelper;
    }

    public synchronized CyNetwork getNetworkPointer() {
        return this.nestedNet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNetworkPointer(CyNetwork n) {
        CyNetwork orig;
        CyNodeImpl cyNodeImpl = this;
        synchronized (cyNodeImpl) {
            orig = this.nestedNet;
            if (n == this.nestedNet) {
                return;
            }
            this.nestedNet = n;
        }
        if (orig != null) {
            this.eventHelper.fireEvent((CyEvent)new UnsetNetworkPointerEvent((CyNode)this, orig));
        }
        if (this.nestedNet != null) {
            this.eventHelper.fireEvent((CyEvent)new SetNetworkPointerEvent((CyNode)this, this.nestedNet));
        }
    }

    public String toString() {
        return "Node suid: " + this.getSUID();
    }
}

