/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.model.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkTableManager;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.events.TableAboutToBeDeletedEvent;
import org.cytoscape.model.events.TableAboutToBeDeletedListener;

public class CyNetworkTableManagerImpl
implements CyNetworkTableManager,
TableAboutToBeDeletedListener {
    private final Map<CyNetwork, Map<Class<? extends CyIdentifiable>, Map<String, CyTable>>> tables;
    private final Object lock = new Object();

    public CyNetworkTableManagerImpl() {
        this.tables = new WeakHashMap<CyNetwork, Map<Class<? extends CyIdentifiable>, Map<String, CyTable>>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<? extends CyIdentifiable> getTableType(CyTable table) {
        Object object = this.lock;
        synchronized (object) {
            for (Map<Class<? extends CyIdentifiable>, Map<String, CyTable>> typeMap : this.tables.values()) {
                for (Map.Entry<Class<? extends CyIdentifiable>, Map<String, CyTable>> entry : typeMap.entrySet()) {
                    Class<? extends CyIdentifiable> classType = entry.getKey();
                    for (CyTable tab : entry.getValue().values()) {
                        if (!tab.equals(table)) continue;
                        return classType;
                    }
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTableNamespace(CyTable table) {
        Object object = this.lock;
        synchronized (object) {
            for (Map<Class<? extends CyIdentifiable>, Map<String, CyTable>> typeMap : this.tables.values()) {
                for (Map<String, CyTable> stMap : typeMap.values()) {
                    for (String ns : stMap.keySet()) {
                        if (!stMap.get(ns).equals(table)) continue;
                        return ns;
                    }
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTable(CyNetwork network, Class<? extends CyIdentifiable> type, String namespace, CyTable table) {
        if (network == null) {
            throw new IllegalArgumentException("'network' cannot be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("'type' cannot be null");
        }
        if (namespace == null) {
            throw new IllegalArgumentException("'namespace' cannot be null");
        }
        if (table == null) {
            throw new IllegalArgumentException("'table' cannot be null");
        }
        Object object = this.lock;
        synchronized (object) {
            Map<Class<? extends CyIdentifiable>, Map<String, CyTable>> byType = this.tables.get(network);
            if (byType == null) {
                byType = new HashMap<Class<? extends CyIdentifiable>, Map<String, CyTable>>();
                HashMap<String, CyTable> type2Tables = new HashMap<String, CyTable>();
                type2Tables.put(namespace, table);
                byType.put(type, type2Tables);
                this.tables.put(network, byType);
                return;
            }
            Map<String, CyTable> reference = byType.get(type);
            if (reference == null) {
                HashMap<String, CyTable> type2Tables = new HashMap<String, CyTable>();
                type2Tables.put(namespace, table);
                byType.put(type, type2Tables);
                this.tables.put(network, byType);
                return;
            }
            if (namespace.equals("USER") && reference.get("USER") != null) {
                throw new IllegalArgumentException("Cannot overwrite the DEFAULT table");
            }
            if (namespace.equals("LOCAL_ATTRS") && reference.get("LOCAL_ATTRS") != null) {
                throw new IllegalArgumentException("Cannot overwrite the LOCAL table");
            }
            if (namespace.equals("HIDDEN") && reference.get("HIDDEN") != null) {
                throw new IllegalArgumentException("Cannot overwrite the HIDDEN table");
            }
            reference.put(namespace, table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CyTable getTable(CyNetwork network, Class<? extends CyIdentifiable> type, String namespace) {
        Object object = this.lock;
        synchronized (object) {
            Map<Class<? extends CyIdentifiable>, Map<String, CyTable>> byType = this.tables.get(network);
            if (network == null) {
                throw new IllegalArgumentException("'network' cannot be null");
            }
            if (type == null) {
                throw new IllegalArgumentException("'type' cannot be null");
            }
            if (namespace == null) {
                throw new IllegalArgumentException("'namespace' cannot be null");
            }
            if (byType == null) {
                return null;
            }
            Map<String, CyTable> reference = byType.get(type);
            if (reference == null) {
                return null;
            }
            return reference.get(namespace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTable(CyNetwork network, Class<? extends CyIdentifiable> type, String namespace) {
        if (network == null) {
            throw new IllegalArgumentException("'network' cannot be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("'type' cannot be null");
        }
        if (namespace == null) {
            throw new IllegalArgumentException("'namespace' cannot be null");
        }
        if (namespace.equals("USER")) {
            throw new IllegalArgumentException("cannot remove default tables");
        }
        Object object = this.lock;
        synchronized (object) {
            Map<Class<? extends CyIdentifiable>, Map<String, CyTable>> byType = this.tables.get(network);
            if (byType == null) {
                return;
            }
            Map<String, CyTable> reference = byType.get(type);
            if (reference == null) {
                return;
            }
            reference.remove(namespace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, CyTable> getTables(CyNetwork network, Class<? extends CyIdentifiable> type) {
        if (network == null) {
            throw new IllegalArgumentException("network cannot be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        Object object = this.lock;
        synchronized (object) {
            Map<Class<? extends CyIdentifiable>, Map<String, CyTable>> byType = this.tables.get(network);
            if (byType == null) {
                return Collections.emptyMap();
            }
            Map<String, CyTable> namespace2tableMap = byType.get(type);
            if (namespace2tableMap == null) {
                return Collections.emptyMap();
            }
            return new HashMap<String, CyTable>(namespace2tableMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CyNetwork getNetworkForTable(CyTable table) {
        Object object = this.lock;
        synchronized (object) {
            for (Map.Entry<CyNetwork, Map<Class<? extends CyIdentifiable>, Map<String, CyTable>>> entry : this.tables.entrySet()) {
                CyNetwork network = entry.getKey();
                for (Map<String, CyTable> typeMap : entry.getValue().values()) {
                    if (!typeMap.values().contains(table)) continue;
                    return network;
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.lock;
        synchronized (object) {
            this.tables.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<CyNetwork> getNetworkSet() {
        Object object = this.lock;
        synchronized (object) {
            return Collections.unmodifiableSet(this.tables.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllTables(CyNetwork network) {
        Object object = this.lock;
        synchronized (object) {
            this.tables.remove(network);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(TableAboutToBeDeletedEvent e) {
        CyTable tableToDelete = e.getTable();
        Object object = this.lock;
        synchronized (object) {
            for (Map<Class<? extends CyIdentifiable>, Map<String, CyTable>> typeMap : this.tables.values()) {
                for (Map.Entry<Class<? extends CyIdentifiable>, Map<String, CyTable>> entry : typeMap.entrySet()) {
                    Map<String, CyTable> namespace2tableMap = entry.getValue();
                    Iterator<Map.Entry<String, CyTable>> iter = namespace2tableMap.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry<String, CyTable> namespaceTblEntry = iter.next();
                        String namespace = namespaceTblEntry.getKey();
                        CyTable tbl = namespaceTblEntry.getValue();
                        if (!tableToDelete.equals(tbl)) continue;
                        if (!("USER".equals(namespace) || "LOCAL_ATTRS".equals(namespace) || "HIDDEN".equals(namespace) || "SHARED_ATTRS".equals(namespace) || "SHARED_DEFAULT_ATTRS".equals(namespace))) {
                            iter.remove();
                        }
                        return;
                    }
                }
            }
        }
    }
}

