/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.model.internal;

import org.cytoscape.event.CyEventHelper;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkFactory;
import org.cytoscape.model.CyNetworkTableManager;
import org.cytoscape.model.CyTableFactory;
import org.cytoscape.model.SavePolicy;
import org.cytoscape.model.internal.CyRootNetworkImpl;
import org.cytoscape.model.internal.CyTableManagerImpl;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CyNetworkFactoryImpl
implements CyNetworkFactory {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private final CyEventHelper help;
    private final CyTableManagerImpl mgr;
    private final CyNetworkTableManager networkTableMgr;
    private final CyTableFactory tableFactory;
    private final CyServiceRegistrar serviceRegistrar;

    public CyNetworkFactoryImpl(CyEventHelper help, CyTableManagerImpl mgr, CyNetworkTableManager networkTableMgr, CyTableFactory tableFactory, CyServiceRegistrar serviceRegistrar) {
        if (help == null) {
            throw new NullPointerException("CyEventHelper is null.");
        }
        if (mgr == null) {
            throw new NullPointerException("CyTableManager is null.");
        }
        if (tableFactory == null) {
            throw new NullPointerException("CyTableFactory is null.");
        }
        if (serviceRegistrar == null) {
            throw new NullPointerException("CyServiceRegistrar is null.");
        }
        this.help = help;
        this.mgr = mgr;
        this.networkTableMgr = networkTableMgr;
        this.tableFactory = tableFactory;
        this.serviceRegistrar = serviceRegistrar;
    }

    public CyNetwork createNetwork() {
        return this.createNetwork(SavePolicy.SESSION_FILE);
    }

    public CyNetwork createNetwork(SavePolicy policy) {
        CyRootNetworkImpl net = new CyRootNetworkImpl(this.help, this.mgr, this.networkTableMgr, this.tableFactory, this.serviceRegistrar, true, policy);
        logger.info("CyNetwork w/ public tables created: ID = " + net.getSUID());
        logger.info("CyNetwork w/ public tables created: Base Graph ID = " + net.getBaseNetwork().getSUID());
        return net.getBaseNetwork();
    }

    public CyNetwork createNetworkWithPrivateTables() {
        return this.createNetworkWithPrivateTables(SavePolicy.SESSION_FILE);
    }

    public CyNetwork createNetworkWithPrivateTables(SavePolicy policy) {
        CyRootNetworkImpl net = new CyRootNetworkImpl(this.help, this.mgr, this.networkTableMgr, this.tableFactory, this.serviceRegistrar, false, policy);
        logger.info("CyNetwork w/ private tables created: ID = " + net.getSUID());
        logger.info("CyNetwork w/ private tables created: Base Graph ID = " + net.getBaseNetwork().getSUID());
        return net.getBaseNetwork();
    }
}

