/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.model.internal;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.events.RowSetRecord;
import org.cytoscape.model.events.RowsSetEvent;
import org.cytoscape.model.internal.CyTableImpl;

public class CyListImpl<T>
implements List<T> {
    private Class<T> elementType;
    private List<T> delegate;
    private CyEventHelper eventHelper;
    private CyRow row;
    private CyColumn column;
    private CyTableImpl table;

    public CyListImpl(Class<T> elementType, List<T> delegate, CyEventHelper eventHelper, CyRow row, CyColumn column, CyTableImpl table) {
        this.elementType = elementType;
        this.delegate = delegate;
        this.eventHelper = eventHelper;
        this.row = row;
        this.column = column;
        this.table = table;
    }

    public Class<T> getListElementType() {
        return this.elementType;
    }

    @Override
    public boolean add(T item) {
        this.checkType(item);
        if (this.delegate.add(item)) {
            this.fireEvent();
            return true;
        }
        return false;
    }

    private void checkType(T item) {
        if (item == null || !this.elementType.isAssignableFrom(item.getClass())) {
            throw new IllegalArgumentException("This list only allows objects of type " + this.elementType.getName());
        }
    }

    private void fireEvent() {
        if (this.table.eventsEnabled()) {
            this.eventHelper.addEventPayload((Object)this.row.getTable(), (Object)new RowSetRecord(this.row, this.column.getName(), (Object)this, (Object)this), RowsSetEvent.class);
        }
    }

    @Override
    public void add(int index, T item) {
        this.checkType(item);
        this.fireEvent();
        this.delegate.add(index, item);
    }

    @Override
    public boolean addAll(Collection<? extends T> items) {
        for (T item : items) {
            this.checkType(item);
        }
        if (this.delegate.addAll(items)) {
            this.fireEvent();
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> items) {
        for (T item : items) {
            this.checkType(item);
        }
        if (this.delegate.addAll(index, items)) {
            this.fireEvent();
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.delegate.size() == 0) {
            return;
        }
        this.delegate.clear();
        this.fireEvent();
    }

    @Override
    public boolean contains(Object item) {
        return this.delegate.contains(item);
    }

    @Override
    public boolean containsAll(Collection<?> items) {
        return this.delegate.containsAll(items);
    }

    @Override
    public T get(int index) {
        return this.delegate.get(index);
    }

    @Override
    public int indexOf(Object item) {
        return this.delegate.indexOf(item);
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.listIterator();
    }

    @Override
    public int lastIndexOf(Object item) {
        return this.delegate.lastIndexOf(item);
    }

    @Override
    public ListIterator<T> listIterator() {
        ListIterator<T> iterator = this.delegate.listIterator();
        return this.createListIterator(iterator);
    }

    private ListIterator<T> createListIterator(final ListIterator<T> iterator) {
        return new ListIterator<T>(){

            @Override
            public void add(T item) {
                CyListImpl.this.checkType(item);
                iterator.add(item);
                CyListImpl.this.fireEvent();
            }

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public boolean hasPrevious() {
                return iterator.hasPrevious();
            }

            @Override
            public T next() {
                return iterator.next();
            }

            @Override
            public int nextIndex() {
                return iterator.nextIndex();
            }

            @Override
            public T previous() {
                return iterator.previous();
            }

            @Override
            public int previousIndex() {
                return iterator.previousIndex();
            }

            @Override
            public void remove() {
                iterator.remove();
                CyListImpl.this.fireEvent();
            }

            @Override
            public void set(T item) {
                CyListImpl.this.checkType(item);
                iterator.set(item);
                CyListImpl.this.fireEvent();
            }
        };
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.delegate.listIterator(index);
    }

    @Override
    public boolean remove(Object item) {
        if (this.delegate.remove(item)) {
            this.fireEvent();
            return true;
        }
        return false;
    }

    @Override
    public T remove(int index) {
        T value = this.delegate.remove(index);
        if (value == null) {
            return null;
        }
        this.fireEvent();
        return value;
    }

    @Override
    public boolean removeAll(Collection<?> items) {
        if (this.delegate.removeAll(items)) {
            this.fireEvent();
            return true;
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> items) {
        if (this.delegate.retainAll(items)) {
            this.fireEvent();
            return true;
        }
        return true;
    }

    @Override
    public T set(int index, T item) {
        T value = this.delegate.set(index, item);
        this.fireEvent();
        return value;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return new CyListImpl<T>(this.elementType, this.delegate.subList(fromIndex, toIndex), this.eventHelper, this.row, this.column, this.table);
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public <S> S[] toArray(S[] container) {
        return this.delegate.toArray(container);
    }

    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.delegate == null ? 0 : this.delegate.hashCode());
        result = 31 * result + (this.elementType == null ? 0 : this.elementType.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CyListImpl other = (CyListImpl)obj;
        if (this.delegate == null ? other.delegate != null : !this.delegate.equals(other.delegate)) {
            return false;
        }
        return !(this.elementType == null ? other.elementType != null : !this.elementType.equals(other.elementType));
    }
}

