/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.search.internal.util;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryParser.MultiFieldQueryParser;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Version;
import org.cytoscape.search.internal.util.AttributeFields;

public class CustomMultiFieldQueryParser
extends MultiFieldQueryParser {
    private AttributeFields attrFields;

    public CustomMultiFieldQueryParser(AttributeFields attrFields, Analyzer analyzer) {
        super(Version.LUCENE_30, attrFields.getFields(), analyzer);
        this.attrFields = attrFields;
        this.setAllowLeadingWildcard(true);
        BooleanQuery.setMaxClauseCount((int)5120);
    }

    protected Query getFieldQuery(String field, String queryText) throws ParseException {
        if (this.attrFields.getType(field) == Integer.class) {
            try {
                int num1 = Integer.parseInt(queryText);
                NumericRangeQuery q = NumericRangeQuery.newIntRange((String)field, (Integer)num1, (Integer)num1, (boolean)true, (boolean)true);
                return q;
            }
            catch (NumberFormatException num1) {}
        } else if (this.attrFields.getType(field) == Long.class) {
            try {
                long num1 = Long.parseLong(queryText);
                NumericRangeQuery q = NumericRangeQuery.newLongRange((String)field, (Long)num1, (Long)num1, (boolean)true, (boolean)true);
                return q;
            }
            catch (NumberFormatException num1) {}
        } else if (this.attrFields.getType(field) == Double.class) {
            try {
                double num1 = Double.parseDouble(queryText);
                NumericRangeQuery q = NumericRangeQuery.newDoubleRange((String)field, (Double)num1, (Double)num1, (boolean)true, (boolean)true);
                return q;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (queryText.charAt(0) == '?' || queryText.charAt(0) == '*') {
            System.out.println("Returning the wildcard query");
            return super.getWildcardQuery(field, queryText);
        }
        return super.getFieldQuery(field, queryText);
    }

    protected Query getRangeQuery(String field, String part1, String part2, boolean inclusive) throws ParseException {
        if (this.attrFields.getType(field) == Integer.class) {
            try {
                int num1 = Integer.parseInt(part1);
                int num2 = Integer.parseInt(part2);
                NumericRangeQuery q = NumericRangeQuery.newIntRange((String)field, (Integer)num1, (Integer)num2, (boolean)inclusive, (boolean)inclusive);
                return q;
            }
            catch (NumberFormatException e) {
                throw new ParseException(e.getMessage());
            }
        }
        if (this.attrFields.getType(field) == Long.class) {
            try {
                long num1 = Long.parseLong(part1);
                long num2 = Long.parseLong(part2);
                NumericRangeQuery q = NumericRangeQuery.newLongRange((String)field, (Long)num1, (Long)num2, (boolean)inclusive, (boolean)inclusive);
                return q;
            }
            catch (NumberFormatException e) {
                throw new ParseException(e.getMessage());
            }
        }
        if (this.attrFields.getType(field) == Double.class) {
            try {
                double num1 = Double.parseDouble(part1);
                double num2 = Double.parseDouble(part2);
                NumericRangeQuery q = NumericRangeQuery.newDoubleRange((String)field, (Double)num1, (Double)num2, (boolean)inclusive, (boolean)inclusive);
                return q;
            }
            catch (NumberFormatException e) {
                throw new ParseException(e.getMessage());
            }
        }
        return super.getRangeQuery(field, part1, part2, inclusive);
    }
}

