/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.search.internal;

import java.util.Collection;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.search.internal.ViewUpdator;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;

public class ViewUpdatorImpl
implements ViewUpdator {
    private final CyServiceRegistrar serviceRegistrar;

    public ViewUpdatorImpl(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    @Override
    public void updateView(CyNetwork network) {
        CyNetworkView view;
        CyNetworkView targetView;
        CyNetworkViewManager viewManager = (CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class);
        CyApplicationManager appManager = (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class);
        Collection views = viewManager.getNetworkViews(network);
        if (views != null && views.size() != 0 && (targetView = (CyNetworkView)views.iterator().next()) != null) {
            targetView.updateView();
        }
        if ((view = appManager.getCurrentNetworkView()) != null) {
            view.updateView();
        }
    }
}

