/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.search.internal;

import org.apache.lucene.store.RAMDirectory;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.search.internal.EnhancedSearch;
import org.cytoscape.search.internal.EnhancedSearchIndex;
import org.cytoscape.search.internal.EnhancedSearchPlugin;
import org.cytoscape.task.AbstractNetworkTask;
import org.cytoscape.work.TaskMonitor;

public class ReindexTask
extends AbstractNetworkTask {
    private CyNetwork network;
    private EnhancedSearch enhancedSearch;
    private boolean interrupted = false;

    public ReindexTask(CyNetwork network, EnhancedSearch enhancedSearch) {
        super(network);
        this.enhancedSearch = enhancedSearch;
        this.network = network;
    }

    public void run(TaskMonitor taskMonitor) {
        RAMDirectory idx = null;
        taskMonitor.setStatusMessage("Re-indexing network");
        idx = EnhancedSearchIndex.buildIndex(this.network, taskMonitor);
        this.enhancedSearch.setNetworkIndex(this.network, idx);
        if (this.interrupted) {
            return;
        }
        EnhancedSearchPlugin.attributeChanged = false;
        taskMonitor.setProgress(1.0);
        taskMonitor.setStatusMessage("Network re-indexed successfuly");
    }

    public void cancel() {
        this.interrupted = true;
    }
}

