/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.search.internal;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.search.internal.IndexAndSearchTask;
import org.cytoscape.search.internal.NodeAndEdgeSelector;
import org.cytoscape.search.internal.SearchResults;
import org.cytoscape.work.TaskMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeAndEdgeSelectorImpl
implements NodeAndEdgeSelector {
    private static final Logger logger = LoggerFactory.getLogger(NodeAndEdgeSelectorImpl.class);
    public static final long UNSET_NETWORK_CHECK_CANCEL_FREQ = 50000L;
    public static final int PROGRESS_UPDATE_FREQ = 10000;

    @Override
    public void selectNodesAndEdges(CyNetwork network, SearchResults searchResults, IndexAndSearchTask task, TaskMonitor taskMonitor) {
        if (network == null || network.getNodeList().size() == 0) {
            return;
        }
        int nodeHitCount = searchResults.getNodeHitCount();
        int edgeHitCount = searchResults.getEdgeHitCount();
        if (nodeHitCount == 0 && edgeHitCount == 0) {
            taskMonitor.setStatusMessage("Could not find any match.");
            this.unselectNodesAndEdges(network, task, taskMonitor);
            taskMonitor.setTitle("Search Finished");
            taskMonitor.setProgress(1.0);
            return;
        }
        if (!this.unselectNodesAndEdges(network, task, taskMonitor)) {
            return;
        }
        String nodeplural = "s";
        if (nodeHitCount == 1) {
            nodeplural = "";
        }
        String edgeplural = "s";
        if (edgeHitCount == 1) {
            edgeplural = "";
        }
        taskMonitor.setStatusMessage("Selecting " + nodeHitCount + " node" + nodeplural + " and " + edgeHitCount + " edge" + edgeplural);
        List<String> nodeHits = searchResults.getNodeHits();
        List<String> edgeHits = searchResults.getEdgeHits();
        int totalHitCount = nodeHitCount + edgeHitCount;
        long startTime = System.currentTimeMillis();
        this.selectNodes(nodeHits, nodeHitCount, totalHitCount, network, task, taskMonitor);
        this.selectEdges(edgeHits, edgeHitCount, totalHitCount, network, task, taskMonitor);
        if (task.isCancelled()) {
            return;
        }
        taskMonitor.setStatusMessage("Selecting " + nodeHitCount + " nodes and " + edgeHitCount + " edges completed in " + Long.toString(System.currentTimeMillis() - startTime) + " ms");
    }

    private boolean unselectNodes(CyNetwork network, IndexAndSearchTask task, TaskMonitor taskMonitor) {
        taskMonitor.setStatusMessage("Unsetting any existing selected nodes");
        long startTime = System.currentTimeMillis();
        Collection suids = network.getDefaultNodeTable().getMatchingKeys("selected", (Object)true, Long.class);
        long counter = 0L;
        int numNodes = suids.size();
        taskMonitor.setProgress(0.0);
        for (Long suid : suids) {
            CyNode n = network.getNode(suid.longValue());
            if (n == null) continue;
            network.getRow((CyIdentifiable)n).set("selected", (Object)false);
            if (++counter % 50000L == 0L && task.isCancelled()) {
                return false;
            }
            if (counter % 10000L != 0L) continue;
            taskMonitor.setProgress((double)counter / (double)numNodes);
        }
        taskMonitor.setStatusMessage("Unsetting any existing selected nodes completed in " + Long.toString(System.currentTimeMillis() - startTime) + " ms");
        return true;
    }

    private boolean unselectEdges(CyNetwork network, IndexAndSearchTask task, TaskMonitor taskMonitor) {
        taskMonitor.setStatusMessage("Unsetting any existing selected edges");
        long startTime = System.currentTimeMillis();
        Collection suids = network.getDefaultEdgeTable().getMatchingKeys("selected", (Object)true, Long.class);
        long counter = 0L;
        taskMonitor.setProgress(0.0);
        int numEdges = suids.size();
        for (Long suid : suids) {
            CyEdge e = network.getEdge(suid.longValue());
            if (e == null) continue;
            network.getRow((CyIdentifiable)e).set("selected", (Object)false);
            if (++counter % 50000L == 0L && task.isCancelled()) {
                return false;
            }
            if (counter % 10000L != 0L) continue;
            taskMonitor.setProgress((double)counter / (double)numEdges);
        }
        taskMonitor.setStatusMessage("Unsetting any existing selected edges completed in " + Long.toString(System.currentTimeMillis() - startTime) + " ms");
        return true;
    }

    private boolean unselectNodesAndEdges(CyNetwork network, IndexAndSearchTask task, TaskMonitor taskMonitor) {
        if (!this.unselectNodes(network, task, taskMonitor)) {
            return false;
        }
        return this.unselectEdges(network, task, taskMonitor);
    }

    private void selectNodes(List<String> nodeHits, int nodeHitCount, int totalHitCount, CyNetwork network, IndexAndSearchTask task, TaskMonitor taskMonitor) {
        Iterator<String> nodeIt = nodeHits.iterator();
        int counter = 0;
        taskMonitor.setProgress(0.0);
        while (nodeIt.hasNext() && !task.isCancelled()) {
            int currESPIndex = Integer.parseInt(nodeIt.next());
            CyNode currNode = network.getNode((long)currESPIndex);
            if (currNode != null) {
                network.getRow((CyIdentifiable)currNode).set("selected", (Object)true);
            } else {
                logger.warn("Unknown node identifier " + currESPIndex);
            }
            if (++counter % 10000 != 0) continue;
            taskMonitor.setProgress((double)(counter / totalHitCount));
        }
    }

    private void selectEdges(List<String> edgeHits, int edgeHitCount, int totalHitCount, CyNetwork network, IndexAndSearchTask task, TaskMonitor taskMonitor) {
        Iterator<String> edgeIt = edgeHits.iterator();
        int counter = totalHitCount - edgeHitCount;
        while (edgeIt.hasNext() && !task.isCancelled()) {
            int currESPIndex = Integer.parseInt(edgeIt.next());
            CyEdge currEdge = network.getEdge((long)currESPIndex);
            if (currEdge != null) {
                network.getRow((CyIdentifiable)currEdge).set("selected", (Object)true);
            } else {
                logger.warn("Unknown edge identifier " + currESPIndex);
            }
            if (++counter % 10000 != 0) continue;
            taskMonitor.setProgress((double)(counter / totalHitCount));
        }
    }
}

