/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.search.internal;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.lucene.store.RAMDirectory;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.search.internal.EnhancedSearch;
import org.cytoscape.search.internal.EnhancedSearchIndexFactory;
import org.cytoscape.search.internal.EnhancedSearchPlugin;
import org.cytoscape.search.internal.EnhancedSearchQueryFactory;
import org.cytoscape.search.internal.NodeAndEdgeSelector;
import org.cytoscape.search.internal.SearchResults;
import org.cytoscape.search.internal.ViewUpdator;
import org.cytoscape.task.AbstractNetworkTask;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexAndSearchTask
extends AbstractNetworkTask
implements ObservableTask {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    protected static final int MAX_QUERY_LEN = 65536;
    private static final long SLEEP_TIME = 1000L;
    private final EnhancedSearch enhancedSearch;
    private final String query;
    private SearchResults results;
    private final ViewUpdator viewUpdator;
    private final NodeAndEdgeSelector selector;
    private final EnhancedSearchQueryFactory queryFactory;
    private final EnhancedSearchIndexFactory indexFactory;

    public IndexAndSearchTask(CyNetwork network, EnhancedSearch enhancedSearch, String query, ViewUpdator viewUpdator, NodeAndEdgeSelector selector, EnhancedSearchQueryFactory queryFactory, EnhancedSearchIndexFactory indexFactory) {
        super(network);
        this.enhancedSearch = enhancedSearch;
        this.query = query;
        this.viewUpdator = viewUpdator;
        this.selector = selector;
        this.queryFactory = queryFactory;
        this.indexFactory = indexFactory;
    }

    protected boolean isCancelled() {
        return this.cancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TaskMonitor taskMonitor) {
        taskMonitor.setTitle("Searching the network");
        if (this.cancelled) {
            return;
        }
        if (this.query.length() > 65536) {
            this.results = SearchResults.syntaxError("At " + this.query.length() + " characters query string is too large");
            logger.error(this.results.getMessage());
            return;
        }
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            long startTime;
            RAMDirectory idx = null;
            EnhancedSearch.Status status = this.enhancedSearch.getNetworkIndexStatus(this.network);
            if (status != null && status.equals((Object)EnhancedSearch.Status.INDEX_SET) && !EnhancedSearchPlugin.attributeChanged) {
                idx = this.enhancedSearch.getNetworkIndex(this.network);
            } else {
                taskMonitor.setStatusMessage("Indexing network");
                startTime = System.currentTimeMillis();
                idx = this.getIndex(executor, this.network, taskMonitor);
                if (idx == null) {
                    this.results = SearchResults.fatalError("Error building index");
                    return;
                }
                this.enhancedSearch.setNetworkIndex(this.network, idx);
                EnhancedSearchPlugin.attributeChanged = false;
                taskMonitor.setStatusMessage("Indexing completed in " + Long.toString(System.currentTimeMillis() - startTime) + " ms");
            }
            taskMonitor.setStatusMessage("Executing query");
            startTime = System.currentTimeMillis();
            this.executeQuery(executor, this.network, idx);
            if (this.cancelled) {
                return;
            }
            taskMonitor.setStatusMessage("Executing query completed in " + Long.toString(System.currentTimeMillis() - startTime) + " ms");
            if (this.results == null) {
                this.results = SearchResults.fatalError("Unknown error");
            }
            if (!this.results.isError()) {
                this.selector.selectNodesAndEdges(this.network, this.results, this, taskMonitor);
                taskMonitor.setStatusMessage("Updating any network views");
                startTime = System.currentTimeMillis();
                this.viewUpdator.updateView(this.network);
                taskMonitor.setStatusMessage("Updating any network views completed in " + Long.toString(System.currentTimeMillis() - startTime) + " ms");
            }
        }
        finally {
            executor.shutdownNow();
        }
    }

    private void executeQuery(ExecutorService executor, CyNetwork network, RAMDirectory idx) {
        Future futureTask = executor.submit(this.queryFactory.getEnhancedSearchQuery(network, idx, this.query));
        try {
            while (!futureTask.isDone()) {
                if (this.cancelled) {
                    futureTask.cancel(true);
                    return;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.results = (SearchResults)futureTask.get();
        }
        catch (InterruptedException ie) {
            this.results = SearchResults.fatalError("Query interrupted");
        }
        catch (ExecutionException ee) {
            this.results = SearchResults.fatalError("Error running query: " + ee.getMessage());
        }
    }

    private RAMDirectory getIndex(ExecutorService executor, CyNetwork network, TaskMonitor taskMonitor) {
        Future futureTask = executor.submit(this.indexFactory.getEnhancedSearchIndex(network, taskMonitor));
        try {
            while (!futureTask.isDone()) {
                if (this.cancelled) {
                    futureTask.cancel(true);
                    return null;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            return (RAMDirectory)futureTask.get();
        }
        catch (InterruptedException ie) {
            return null;
        }
        catch (ExecutionException ee) {
            logger.error(ee.getMessage(), (Throwable)ee);
            return null;
        }
    }

    public <R> R getResults(Class<? extends R> type) {
        if (SearchResults.class.equals(type)) {
            return type.cast(this.results);
        }
        return null;
    }
}

