/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.search.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;

class IdentifiersCollector
extends Collector {
    private Searcher searcher;
    public List<String> nodeHitsIdentifiers = new ArrayList<String>();
    public List<String> edgeHitsIdentifiers = new ArrayList<String>();

    public IdentifiersCollector(Searcher searcher) {
        this.searcher = searcher;
    }

    public int getNodeHitCount() {
        return this.nodeHitsIdentifiers.size();
    }

    public int getEdgeHitCount() {
        return this.edgeHitsIdentifiers.size();
    }

    public List<String> getNodeHits() {
        return this.nodeHitsIdentifiers;
    }

    public List<String> getEdgeHits() {
        return this.edgeHitsIdentifiers;
    }

    public boolean acceptsDocsOutOfOrder() {
        return true;
    }

    public void collect(int id) {
        try {
            Document doc = this.searcher.doc(id);
            String currID = doc.get("ESP_INDEX");
            String currType = doc.get("ESP_TYPE");
            if (currType.equalsIgnoreCase("node")) {
                this.nodeHitsIdentifiers.add(currID);
            } else if (currType.equalsIgnoreCase("edge")) {
                this.edgeHitsIdentifiers.add(currID);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void setNextReader(IndexReader reader, int docBase) {
    }

    public void setScorer(Scorer scorer) {
    }
}

