/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.search.internal;

import java.awt.Component;
import org.cytoscape.application.events.SetCurrentNetworkViewEvent;
import org.cytoscape.application.events.SetCurrentNetworkViewListener;
import org.cytoscape.application.swing.AbstractToolBarComponent;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.events.ColumnDeletedEvent;
import org.cytoscape.model.events.ColumnDeletedListener;
import org.cytoscape.model.events.ColumnNameChangedEvent;
import org.cytoscape.model.events.ColumnNameChangedListener;
import org.cytoscape.model.events.NetworkAboutToBeDestroyedEvent;
import org.cytoscape.model.events.NetworkAboutToBeDestroyedListener;
import org.cytoscape.model.events.RemovedEdgesEvent;
import org.cytoscape.model.events.RemovedEdgesListener;
import org.cytoscape.model.events.RemovedNodesEvent;
import org.cytoscape.model.events.RemovedNodesListener;
import org.cytoscape.model.events.RowsSetEvent;
import org.cytoscape.model.events.RowsSetListener;
import org.cytoscape.search.internal.EnhancedSearchManager;
import org.cytoscape.search.internal.ui.EnhancedSearchPanel;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.session.events.SessionLoadedEvent;
import org.cytoscape.session.events.SessionLoadedListener;

public class EnhancedSearchPlugin
extends AbstractToolBarComponent
implements SetCurrentNetworkViewListener,
NetworkAboutToBeDestroyedListener,
SessionLoadedListener,
RowsSetListener,
ColumnDeletedListener,
RemovedNodesListener,
RemovedEdgesListener,
ColumnNameChangedListener {
    private final EnhancedSearchManager searchMgr = new EnhancedSearchManager();
    private final EnhancedSearchPanel searchPnl;
    public static boolean attributeChanged;

    public EnhancedSearchPlugin(CyServiceRegistrar serviceRegistrar) {
        this.searchPnl = new EnhancedSearchPanel(this.searchMgr, serviceRegistrar);
        this.setToolBarGravity(1.0E14f);
    }

    public Component getComponent() {
        return this.searchPnl;
    }

    public void handleEvent(SetCurrentNetworkViewEvent e) {
    }

    public void handleEvent(SessionLoadedEvent e) {
        if (this.searchMgr != null) {
            this.searchMgr.clear();
        }
    }

    public void handleEvent(NetworkAboutToBeDestroyedEvent e) {
        if (this.searchMgr != null) {
            CyNetwork network = e.getNetwork();
            this.searchMgr.removeNetworkIndex(network);
        }
    }

    public void handleEvent(ColumnDeletedEvent e) {
        attributeChanged = true;
    }

    public void handleEvent(ColumnNameChangedEvent e) {
        attributeChanged = true;
    }

    public void handleEvent(RowsSetEvent e) {
        if (!e.containsColumn("selected")) {
            attributeChanged = true;
        }
    }

    public void handleEvent(RemovedNodesEvent e) {
        attributeChanged = true;
    }

    public void handleEvent(RemovedEdgesEvent e) {
        attributeChanged = true;
    }
}

