/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.copycatLayout.internal.task;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.copycatLayout.internal.rest.CopycatLayoutResult;
import org.cytoscape.copycatLayout.internal.task.CopyNetworkViewLocationTask;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.layout.CyLayoutAlgorithmManager;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;
import org.cytoscape.work.util.ListSingleSelection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopycatLayoutTask
extends AbstractTask
implements ObservableTask {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private static final String displayName = "Copycat";
    protected final CyLayoutAlgorithmManager algoManager;
    protected CopycatLayoutResult result;
    private final TaskIterator ti;
    Map<String, CyNetworkView> viewMap;
    public ListSingleSelection<String> sourceNetwork;
    public ListSingleSelection<String> sourceColumn = null;
    public ListSingleSelection<String> targetNetwork;
    public ListSingleSelection<String> targetColumn = null;
    public boolean selectUnmapped = false;
    public boolean gridUnmapped = false;

    private List<String> getValidColumnNames(CyNetworkView netView) {
        if (netView == null) {
            return new ArrayList<String>();
        }
        CyNetwork network = (CyNetwork)netView.getModel();
        ArrayList<String> columnNames = new ArrayList<String>();
        for (CyColumn col : network.getDefaultNodeTable().getColumns()) {
            if (col.getType() != String.class && col.getType() != Integer.class) continue;
            columnNames.add(col.getName());
        }
        Collections.sort(columnNames);
        return columnNames;
    }

    private String getNetworkName(CyNetworkView view) {
        CyNetwork net = (CyNetwork)view.getModel();
        String name = (String)net.getRow((CyIdentifiable)net).get("name", String.class);
        return name;
    }

    @Tunable(description="Source network view", required=true, gravity=1.0, longDescription="The name of network to get node coordinates from")
    public ListSingleSelection<String> getsourceNetwork() {
        return this.sourceNetwork;
    }

    public void setsourceNetwork(ListSingleSelection<String> mfn) {
        if (this.sourceNetwork != null && ((String)mfn.getSelectedValue()).equals(this.sourceNetwork.getSelectedValue())) {
            return;
        }
        this.sourceNetwork = mfn;
        CyNetworkView fromNetworkView = this.viewMap.get(this.sourceNetwork.getSelectedValue());
        this.sourceColumn = new ListSingleSelection(this.getValidColumnNames(fromNetworkView));
    }

    @Tunable(description="Source network node column", required=true, gravity=2.0, listenForChange={"sourceNetwork"}, longDescription="The name of column in the node table used to match nodes", exampleStringValue="name")
    public ListSingleSelection<String> getsourceColumn() {
        if (this.sourceColumn == null) {
            CyNetworkView fromNetworkView = this.viewMap.get(this.sourceNetwork.getSelectedValue());
            this.sourceColumn = new ListSingleSelection(this.getValidColumnNames(fromNetworkView));
        }
        return this.sourceColumn;
    }

    public void setsourceColumn(ListSingleSelection<String> map) {
        this.sourceColumn = map;
    }

    @Tunable(description="Target network view", required=true, gravity=3.0, longDescription="The name of the network to apply coordinates to.")
    public ListSingleSelection<String> gettargetNetwork() {
        return this.targetNetwork;
    }

    public void settargetNetwork(ListSingleSelection<String> mtn) {
        if (this.targetNetwork != null && ((String)mtn.getSelectedValue()).equals(this.targetNetwork.getSelectedValue())) {
            return;
        }
        this.targetNetwork = mtn;
        CyNetworkView fromNetworkView = this.viewMap.get(this.targetNetwork.getSelectedValue());
        this.targetColumn = new ListSingleSelection(this.getValidColumnNames(fromNetworkView));
    }

    @Tunable(description="Target network node column", required=true, gravity=4.0, listenForChange={"targetNetwork"}, longDescription="The name of column in the node table used to match nodes", exampleStringValue="name")
    public ListSingleSelection<String> gettargetColumn() {
        if (this.targetColumn == null) {
            CyNetworkView toNetworkView = this.viewMap.get(this.targetNetwork.getSelectedValue());
            this.targetColumn = new ListSingleSelection(this.getValidColumnNames(toNetworkView));
        }
        return this.targetColumn;
    }

    public void settargetColumn(ListSingleSelection<String> map) {
        this.targetColumn = map;
    }

    @Tunable(description="Select unmapped nodes", gravity=5.0, groups={"After Layout"}, longDescription="If this is set to ```true```, any nodes in the target network that could not be matched to a node in the source network will be selected in the target network", exampleStringValue="true")
    public boolean getselectUnmapped() {
        return this.selectUnmapped;
    }

    public void setselectUnmapped(boolean b) {
        this.selectUnmapped = b;
    }

    @Tunable(description="Layout unmapped nodes in a grid", gravity=6.0, groups={"After Layout"}, longDescription="If this is set to ```true```, any nodes in the target network that could not be matched to a node in the source network will be laid out in a grid", exampleStringValue="true")
    public boolean getgridUnmapped() {
        return this.gridUnmapped;
    }

    public void setgridUnmapped(boolean b) {
        this.gridUnmapped = b;
    }

    public CopycatLayoutTask(CyApplicationManager cyApplicationManager, CyNetworkViewManager viewManager, CyLayoutAlgorithmManager algoManager, TaskIterator ti) {
        this.algoManager = algoManager;
        this.ti = ti;
        this.viewMap = new HashMap<String, CyNetworkView>();
        for (CyNetworkView v : viewManager.getNetworkViewSet()) {
            this.viewMap.put(this.getNetworkName(v), v);
        }
        ListSingleSelection sourceList = new ListSingleSelection(new ArrayList<String>(this.viewMap.keySet()));
        ListSingleSelection targetList = new ListSingleSelection(new ArrayList<String>(this.viewMap.keySet()));
        Iterator<String> names = this.viewMap.keySet().iterator();
        CyNetworkView networkView = cyApplicationManager.getCurrentNetworkView();
        if (networkView != null) {
            sourceList.setSelectedValue((Object)this.getNetworkName(networkView));
        } else if (names.hasNext()) {
            sourceList.setSelectedValue((Object)names.next());
        }
        if (names.hasNext()) {
            String name = names.next();
            if (names.hasNext() && name == sourceList.getSelectedValue()) {
                name = names.next();
            }
            targetList.setSelectedValue((Object)name);
        }
        this.setsourceNetwork((ListSingleSelection<String>)sourceList);
        this.settargetNetwork((ListSingleSelection<String>)targetList);
        this.targetColumn.setSelectedValue((Object)"name");
        this.sourceColumn.setSelectedValue((Object)"name");
    }

    void showError(final String message, final String title) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(null, message, title, 0);
            }
        });
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        taskMonitor.setTitle(displayName);
        String targetNetworkName = (String)this.targetNetwork.getSelectedValue();
        String targetColumnName = (String)this.targetColumn.getSelectedValue();
        String sourceColumnName = (String)this.sourceColumn.getSelectedValue();
        CyNetworkView targetNetworkView = this.viewMap.get(targetNetworkName);
        CyNetworkView sourceNetworkView = this.viewMap.get(this.sourceNetwork.getSelectedValue());
        if (targetNetworkView == null) {
            logger.error("Target network not found");
            throw new NetworkNotFoundError("Target network not found");
        }
        if (sourceNetworkView == null) {
            logger.error("Source network not found");
            throw new NetworkNotFoundError("Source network not found");
        }
        if (targetNetworkView.equals(sourceNetworkView)) {
            logger.warn("Source and target network must be different");
            this.showError("Source and target network must be different", "Invalid Network Views");
            return;
        }
        CyNetwork targetNetwork = (CyNetwork)targetNetworkView.getModel();
        CyNetwork sourceNetwork = (CyNetwork)sourceNetworkView.getModel();
        CyColumn sourceCol = sourceNetwork.getDefaultNodeTable().getColumn(sourceColumnName);
        if (sourceCol == null || sourceCol.getType() != String.class && sourceCol.getType() != Integer.class) {
            logger.error("Source column not found or invalid. Must be existing String or Integer column");
            throw new InvalidColumnError("Source column not found or invalid. Must be existing String or Integer column");
        }
        CyColumn targetCol = targetNetwork.getDefaultNodeTable().getColumn(targetColumnName);
        if (targetCol == null || targetCol.getType() != String.class && targetCol.getType() != Integer.class) {
            logger.error("Target column not found or invalid. Must be existing String or Integer column");
            throw new InvalidColumnError("Target column not found or invalid. Must be existing String or Integer column");
        }
        if (sourceCol.getType() != targetCol.getType()) {
            logger.error("Column types must match to map correctly");
            this.showError("Source and target column must be the same type", "Invalid Column Types");
            return;
        }
        Class cls = sourceCol.getType();
        HashMap<Object, View> sourceMap = new HashMap<Object, View>();
        for (View nodeView : sourceNetworkView.getNodeViews()) {
            if (this.cancelled) {
                return;
            }
            View val = sourceMap.put(sourceNetwork.getRow((CyIdentifiable)nodeView.getModel()).get(sourceColumnName, cls), nodeView);
            if (val != null) {
                logger.warn("Duplicate key in source");
            }
            if (!this.selectUnmapped) continue;
            sourceNetwork.getRow((CyIdentifiable)nodeView.getModel()).set("selected", (Object)false);
        }
        HashSet sourceUnmapped = new HashSet(sourceMap.values());
        HashSet<View<CyNode>> targetUnmapped = new HashSet<View<CyNode>>();
        int mappedNodeCount = 0;
        double maxX = 0.0;
        double minY = Double.MAX_VALUE;
        for (View view : targetNetworkView.getNodeViews()) {
            if (this.cancelled) {
                return;
            }
            Object val = targetNetwork.getRow((CyIdentifiable)view.getModel()).get(targetColumnName, cls);
            if (sourceMap.containsKey(val)) {
                this.copyNodeLocation((View<CyNode>)((View)sourceMap.get(val)), (View<CyNode>)view);
                sourceUnmapped.remove(sourceMap.get(val));
                ++mappedNodeCount;
                maxX = Math.max(maxX, (Double)view.getVisualProperty(BasicVisualLexicon.NODE_X_LOCATION));
                minY = Math.min(minY, (Double)view.getVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION));
            } else {
                targetUnmapped.add((View<CyNode>)view);
            }
            if (!this.selectUnmapped) continue;
            targetNetwork.getRow((CyIdentifiable)view.getModel()).set("selected", (Object)false);
        }
        if (this.selectUnmapped) {
            for (View view : sourceUnmapped) {
                if (this.cancelled) {
                    return;
                }
                sourceNetwork.getRow((CyIdentifiable)view.getModel()).set("selected", (Object)true);
            }
            for (View view : targetUnmapped) {
                if (this.cancelled) {
                    return;
                }
                targetNetwork.getRow((CyIdentifiable)view.getModel()).set("selected", (Object)true);
            }
        }
        if (this.gridUnmapped) {
            for (View view : targetUnmapped) {
                if (this.cancelled) {
                    return;
                }
                view.setVisualProperty(BasicVisualLexicon.NODE_X_LOCATION, (Object)(maxX + 200.0));
                view.setVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION, (Object)minY);
            }
            if (targetUnmapped.size() > 0) {
                this.grid(targetUnmapped, 80, 40);
            }
        }
        this.ti.append((Task)new CopyNetworkViewLocationTask(sourceNetworkView, targetNetworkView));
        this.result = new CopycatLayoutResult();
        this.result.mappedNodeCount = mappedNodeCount;
        this.result.unmappedNodeCount = targetUnmapped.size();
    }

    private void grid(Set<View<CyNode>> nodesToLayOut, int nodeHorizontalSpacing, int nodeVerticalSpacing) {
        double currX = 0.0;
        double currY = 0.0;
        double initialX = 0.0;
        double initialY = 0.0;
        int nodeCount = nodesToLayOut.size();
        int columns = (int)Math.sqrt(nodeCount);
        for (View<CyNode> nView : nodesToLayOut) {
            if (this.cancelled) {
                return;
            }
            initialX += (Double)nView.getVisualProperty(BasicVisualLexicon.NODE_X_LOCATION) / (double)nodeCount;
            initialY += (Double)nView.getVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION) / (double)nodeCount;
        }
        currX = initialX -= (double)(nodeHorizontalSpacing * (columns - 1) / 2);
        currY = initialY -= (double)(nodeVerticalSpacing * (columns - 1) / 2);
        int count = 0;
        for (View<CyNode> nView : nodesToLayOut) {
            if (this.cancelled) {
                return;
            }
            nView.setVisualProperty(BasicVisualLexicon.NODE_X_LOCATION, (Object)currX);
            nView.setVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION, (Object)currY);
            if (++count == columns) {
                count = 0;
                currX = initialX;
                currY += (double)nodeVerticalSpacing;
                continue;
            }
            currX += (double)nodeHorizontalSpacing;
        }
    }

    private void copyNodeLocation(View<CyNode> source, View<CyNode> target) {
        Double x = (Double)source.getVisualProperty(BasicVisualLexicon.NODE_X_LOCATION);
        Double y = (Double)source.getVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION);
        Double z = (Double)source.getVisualProperty(BasicVisualLexicon.NODE_Z_LOCATION);
        target.setVisualProperty(BasicVisualLexicon.NODE_X_LOCATION, (Object)x);
        target.setVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION, (Object)y);
        target.setVisualProperty(BasicVisualLexicon.NODE_Z_LOCATION, (Object)z);
    }

    public List<Class<?>> getResultClasses() {
        return Collections.unmodifiableList(Arrays.asList(String.class, CopycatLayoutResult.class, JSONResult.class));
    }

    public <R> R getResults(Class<? extends R> type) {
        if (type.equals(String.class)) {
            return (R)(this.result != null ? "# of mapped nodes:\t" + this.result.mappedNodeCount + "\t# of unmapped nodes:\t" + this.result.unmappedNodeCount : null);
        }
        if (type.equals(JSONResult.class)) {
            JSONResult res = () -> {
                if (this.result == null) {
                    return "{}";
                }
                return new Gson().toJson((Object)this.result);
            };
            return (R)res;
        }
        return (R)this.result;
    }

    private class InvalidColumnError
    extends Exception {
        private static final long serialVersionUID = 1L;

        public InvalidColumnError(String message) {
            super(message);
        }
    }

    private class NetworkNotFoundError
    extends Exception {
        private static final long serialVersionUID = 1L;

        public NetworkNotFoundError(String message) {
            super(message);
        }
    }
}

