/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.copycatLayout.internal;

import java.util.Properties;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.copycatLayout.internal.rest.CopycatLayoutResource;
import org.cytoscape.copycatLayout.internal.task.CopycatLayoutTaskFactory;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.service.util.AbstractCyActivator;
import org.cytoscape.view.layout.CyLayoutAlgorithmManager;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.work.SynchronousTaskManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.util.tracker.ServiceTracker;

public class CyActivator
extends AbstractCyActivator {
    private ServiceTracker ciResponseFactoryTracker = null;
    private ServiceTracker ciExceptionFactoryTracker = null;
    private ServiceTracker ciErrorFactoryTracker = null;

    public void start(BundleContext bc) throws InvalidSyntaxException {
        CyNetworkViewManager viewManager = (CyNetworkViewManager)this.getService(bc, CyNetworkViewManager.class);
        CyLayoutAlgorithmManager cyLayoutAlgoManager = (CyLayoutAlgorithmManager)this.getService(bc, CyLayoutAlgorithmManager.class);
        CyApplicationManager cyApplicationManager = (CyApplicationManager)this.getService(bc, CyApplicationManager.class);
        Properties copycatLayoutOpsProps = new Properties();
        copycatLayoutOpsProps.setProperty("preferredMenu", "Layout");
        copycatLayoutOpsProps.setProperty("preferredTaskManager", "menu");
        copycatLayoutOpsProps.setProperty("title", "Copycat Layout");
        copycatLayoutOpsProps.setProperty("menuGravity", "5.55");
        copycatLayoutOpsProps.setProperty("commandNamespace", "layout");
        copycatLayoutOpsProps.setProperty("command", "copycat");
        copycatLayoutOpsProps.setProperty("commandDescription", "Copy network layout from one network view to another");
        copycatLayoutOpsProps.setProperty("commandLongDescription", "Sets the coordinates for each node in the target network to the coordinates of a matching node in the source network.\n\nOptional parameters such as ```gridUnmapped``` and ```selectUnmapped``` determine the behavior of target network nodes that could not be matched.");
        copycatLayoutOpsProps.setProperty("commandSupportsJSON", "true");
        copycatLayoutOpsProps.setProperty("commandExampleJSON", "{\n  \"mappedNodeCount\": 100,\n  \"unmappedNodeCount\": 0\n}");
        CopycatLayoutTaskFactory copycatLayout = new CopycatLayoutTaskFactory(cyApplicationManager, viewManager, cyLayoutAlgoManager);
        this.registerAllServices(bc, (Object)copycatLayout, copycatLayoutOpsProps);
        SynchronousTaskManager taskManager = (SynchronousTaskManager)this.getService(bc, SynchronousTaskManager.class);
        CyNetworkManager cyNetworkManager = (CyNetworkManager)this.getService(bc, CyNetworkManager.class);
        CyNetworkViewManager cyNetworkViewManager = (CyNetworkViewManager)this.getService(bc, CyNetworkViewManager.class);
        this.ciResponseFactoryTracker = new ServiceTracker(bc, bc.createFilter("(objectClass=org.cytoscape.ci.CIResponseFactory)"), null);
        this.ciResponseFactoryTracker.open();
        this.ciExceptionFactoryTracker = new ServiceTracker(bc, bc.createFilter("(objectClass=org.cytoscape.ci.CIExceptionFactory)"), null);
        this.ciExceptionFactoryTracker.open();
        this.ciErrorFactoryTracker = new ServiceTracker(bc, bc.createFilter("(objectClass=org.cytoscape.ci.CIErrorFactory)"), null);
        this.ciErrorFactoryTracker.open();
        CopycatLayoutResource resource = new CopycatLayoutResource(cyApplicationManager, (SynchronousTaskManager<Object>)taskManager, cyNetworkManager, cyNetworkViewManager, copycatLayout, this.ciResponseFactoryTracker, this.ciExceptionFactoryTracker, this.ciErrorFactoryTracker);
        this.registerService(bc, resource, CopycatLayoutResource.class, new Properties());
    }

    public void shutDown() {
        if (this.ciResponseFactoryTracker != null) {
            this.ciResponseFactoryTracker.close();
        }
        if (this.ciExceptionFactoryTracker != null) {
            this.ciExceptionFactoryTracker.close();
        }
        if (this.ciErrorFactoryTracker != null) {
            this.ciErrorFactoryTracker.close();
        }
        super.shutDown();
    }
}

