/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.util;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.cytoscape.cg.internal.util.VisualPropertyIcon;
import org.cytoscape.cg.model.SVGCustomGraphics;
import org.cytoscape.cg.model.SVGLayer;
import org.cytoscape.view.presentation.customgraphics.Cy2DGraphicLayer;
import org.cytoscape.view.presentation.customgraphics.CyCustomGraphics;

public class CustomGraphicsIcon
extends VisualPropertyIcon<CyCustomGraphics<?>> {
    private List<? extends Cy2DGraphicLayer> cy2DLayers;

    public CustomGraphicsIcon(CyCustomGraphics<?> value, int width, int height, String name) {
        super(value, width, height, name);
        Image img = value.getRenderedImage();
        if (img != null) {
            this.setImage(img);
        }
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.width <= 0 || this.height <= 0) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        CyCustomGraphics cg = (CyCustomGraphics)this.getValue();
        if (cg instanceof SVGCustomGraphics) {
            if (this.cy2DLayers == null) {
                this.cy2DLayers = ((SVGCustomGraphics)cg).getLayers();
            }
            Rectangle2D.Float rect = new Rectangle2D.Float((float)x + (float)this.width / 2.0f, (float)y + (float)this.height / 2.0f, this.width, this.height);
            for (Cy2DGraphicLayer cy2DGraphicLayer : this.cy2DLayers) {
                if (!(cy2DGraphicLayer instanceof SVGLayer)) continue;
                ((SVGLayer)cy2DGraphicLayer).draw(g2, rect, rect);
            }
        } else {
            Image img = this.getImage();
            if (img != null) {
                int w = this.width;
                int n = this.height;
                int iw = img.getWidth(null);
                int ih = img.getHeight(null);
                int nw = iw;
                int nh = ih;
                if (iw > 0 && ih > 0) {
                    if (iw > w) {
                        nw = w;
                        nh = nw * ih / iw;
                    }
                    if (nh > n) {
                        nh = n;
                        nw = nh * iw / ih;
                    }
                    img = img.getScaledInstance(nw, nh, 16);
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g2.drawImage(img, (int)((float)x + (float)(w - nw) / 2.0f), (int)((float)y + (float)(n - nh) / 2.0f), nw, nh, c);
                }
            }
        }
        g2.dispose();
    }
}

