/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.model;

import java.awt.Image;

public class CustomGraphicsUtil {
    public static Image getResizedImage(Image original, Integer w, Integer h, boolean keepAspectRatio) {
        if (original == null) {
            throw new IllegalArgumentException("Original image cannot be null.");
        }
        if (w == null && h == null) {
            return original;
        }
        int currentW = original.getWidth(null);
        int currentH = original.getHeight(null);
        if (!keepAspectRatio) {
            return original.getScaledInstance(w, h, 16);
        }
        if (h == null) {
            float ratio = (float)currentH / (float)currentW;
            int converted = (int)((float)w.intValue() * ratio);
            return original.getScaledInstance(w, converted, 16);
        }
        float ratio = (float)currentW / (float)currentH;
        int converted = (int)((float)h.intValue() * ratio);
        return original.getScaledInstance(converted, h, 16);
    }
}

