/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.model;

import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import org.cytoscape.cg.internal.paint.TexturePaintFactory;
import org.cytoscape.cg.internal.util.ImageUtil;
import org.cytoscape.cg.model.AbstractURLImageCustomGraphics;
import org.cytoscape.cg.model.BitmapLayer;

public class BitmapCustomGraphics
extends AbstractURLImageCustomGraphics<BitmapLayer> {
    public static final String TYPE_NAMESPACE = "org.cytoscape.ding.customgraphics.bitmap";
    public static final String TYPE_NAME = "URLImageCustomGraphics";
    private static final String DEF_TAG = "bitmap image";
    private static final String DEF_IMAGE_FILE = "/images/no_image.png";
    private BufferedImage originalImage;
    private BufferedImage scaledImage;
    public static BufferedImage DEF_IMAGE;

    public BitmapCustomGraphics(Long id, String name, URL url) {
        super(id, name, url);
        this.tags.add(DEF_TAG);
        this.createImage();
        this.buildCustomGraphics(this.originalImage);
    }

    public BitmapCustomGraphics(Long id, String name, BufferedImage img) {
        super(id, name);
        if (img == null) {
            throw new IllegalArgumentException("Image cannot be null.");
        }
        this.fitRatio = 1.0f;
        if (this.displayName.startsWith("bundle:")) {
            int index = this.displayName.lastIndexOf("/");
            this.displayName = this.displayName.substring(index + 1);
        }
        this.tags.add(DEF_TAG);
        this.originalImage = img;
        this.buildCustomGraphics(this.originalImage);
    }

    public BitmapCustomGraphics(Long id, String name, URL url, BufferedImage img) {
        this(id, name, img);
        this.sourceUrl = url;
    }

    @Override
    public String getTypeNamespace() {
        return TYPE_NAMESPACE;
    }

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    public Image getRenderedImage() {
        if (this.width == this.originalImage.getWidth() && this.height == this.originalImage.getHeight()) {
            return this.originalImage;
        }
        if (this.scaledImage == null || this.scaledImage.getWidth() != this.width || this.scaledImage.getHeight() != this.height) {
            this.resizeImage(this.width, this.height);
        }
        return this.scaledImage;
    }

    public BufferedImage getOriginalImage() {
        return this.originalImage;
    }

    public Image resetImage() {
        if (this.scaledImage != null) {
            this.scaledImage.flush();
            this.scaledImage = null;
        }
        this.buildCustomGraphics(this.originalImage);
        return this.originalImage;
    }

    private void buildCustomGraphics(BufferedImage targetImg) {
        this.layers.clear();
        this.width = targetImg.getWidth();
        this.height = targetImg.getHeight();
        Rectangle2D.Double bound = new Rectangle2D.Double(-this.width / 2, -this.height / 2, this.width, this.height);
        TexturePaintFactory paintFactory = new TexturePaintFactory(targetImg);
        BitmapLayer cg = new BitmapLayer(bound, paintFactory);
        this.layers.add(cg);
    }

    private void createImage() {
        try {
            this.originalImage = ImageIO.read(this.getSourceURL());
        }
        catch (Exception e) {
            this.originalImage = DEF_IMAGE;
        }
        if (this.originalImage == null) {
            this.originalImage = DEF_IMAGE;
        }
    }

    private Image resizeImage(int width, int height) {
        Image img = this.originalImage.getScaledInstance(width, height, 16);
        try {
            this.scaledImage = ImageUtil.toBufferedImage(img);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return this.originalImage;
        }
        this.buildCustomGraphics(this.scaledImage);
        return this.scaledImage;
    }

    public int hashCode() {
        int prime = 31;
        int result = 11;
        result = prime * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BitmapCustomGraphics)) {
            return false;
        }
        BitmapCustomGraphics other = (BitmapCustomGraphics)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    static {
        try {
            DEF_IMAGE = ImageIO.read(BitmapCustomGraphics.class.getClassLoader().getResource(DEF_IMAGE_FILE));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

