/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.ListCellRenderer;
import javax.swing.border.CompoundBorder;
import org.cytoscape.cg.internal.util.ViewUtil;
import org.cytoscape.cg.internal.util.VisualPropertyIconFactory;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.presentation.customgraphics.CyCustomGraphics;

public class CustomGraphicsCellRenderer
extends JPanel
implements ListCellRenderer<CyCustomGraphics> {
    private static final int ICON_SIZE = 96;
    private static final int CELL_WIDTH = 150;
    private final Map<CyCustomGraphics<?>, ImagePanel> panelMap = new HashMap();

    @Override
    public Component getListCellRendererComponent(JList list, CyCustomGraphics cg, int index, boolean isSelected, boolean cellHasFocus) {
        ImagePanel target = null;
        if (cg != null) {
            target = this.panelMap.get(cg);
            if (target == null) {
                target = new ImagePanel(cg);
                this.panelMap.put(cg, target);
            }
            target.setSelected(isSelected);
        }
        return target;
    }

    private class ImagePanel
    extends JPanel {
        private final JLabel nameLbl;
        private final JLabel iconLbl;
        final Color BG_COLOR;
        final Color FG_COLOR;
        final Color SEL_BG_COLOR;
        final Color SEL_FG_COLOR;
        final Color BORDER_COLOR;

        ImagePanel(CyCustomGraphics<?> cg) {
            super(new BorderLayout());
            JList list = new JList();
            this.BG_COLOR = list.getBackground();
            this.FG_COLOR = list.getForeground();
            this.SEL_BG_COLOR = list.getSelectionBackground();
            this.SEL_FG_COLOR = list.getSelectionForeground();
            this.BORDER_COLOR = new JPopupMenu.Separator().getForeground();
            this.setToolTipText(cg.getDisplayName());
            String name = ViewUtil.getShortName(cg.getDisplayName());
            this.nameLbl = new JLabel(name);
            this.nameLbl.setHorizontalAlignment(0);
            this.nameLbl.setFont(this.nameLbl.getFont().deriveFont(LookAndFeelUtil.getSmallFontSize()));
            this.nameLbl.setOpaque(true);
            this.iconLbl = new JLabel();
            this.iconLbl.setHorizontalAlignment(0);
            this.iconLbl.setOpaque(true);
            this.iconLbl.setBackground(this.BG_COLOR);
            Icon icon = VisualPropertyIconFactory.createIcon(cg, 96, 96);
            this.iconLbl.setIcon(icon);
            this.add((Component)this.iconLbl, "Center");
            this.add((Component)this.nameLbl, "South");
            this.setPreferredSize(new Dimension(150, 10 + this.getPreferredSize().height));
        }

        void setSelected(boolean selected) {
            CompoundBorder border;
            if (selected) {
                border = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), BorderFactory.createLineBorder(this.SEL_BG_COLOR, 2));
                this.nameLbl.setBackground(this.SEL_BG_COLOR);
                this.nameLbl.setForeground(this.SEL_FG_COLOR);
            } else {
                border = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), BorderFactory.createLineBorder(this.BORDER_COLOR, 1));
                this.nameLbl.setBackground(this.BG_COLOR);
                this.nameLbl.setForeground(this.FG_COLOR);
            }
            this.setBorder(border);
        }
    }
}

