/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.model;

import java.text.Collator;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.cytoscape.cg.model.CustomGraphics2Manager;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.view.presentation.customgraphics.CustomGraphicLayer;
import org.cytoscape.view.presentation.customgraphics.CyCustomGraphics2;
import org.cytoscape.view.presentation.customgraphics.CyCustomGraphics2Factory;

public class CustomGraphics2ManagerImpl
implements CustomGraphics2Manager {
    private final Map<String, Set<CyCustomGraphics2Factory<? extends CustomGraphicLayer>>> groups;
    private final Map<String, CyCustomGraphics2Factory<? extends CustomGraphicLayer>> factories;
    private final Collator collator = Collator.getInstance(Locale.getDefault());
    private final Comparator<CyCustomGraphics2Factory<? extends CustomGraphicLayer>> factoryComparator;
    private static final CustomGraphics2ManagerImpl me = new CustomGraphics2ManagerImpl();

    private CustomGraphics2ManagerImpl() {
        this.groups = new ConcurrentHashMap<String, Set<CyCustomGraphics2Factory<? extends CustomGraphicLayer>>>();
        this.factories = new ConcurrentHashMap<String, CyCustomGraphics2Factory<? extends CustomGraphicLayer>>();
        this.factoryComparator = new Comparator<CyCustomGraphics2Factory<? extends CustomGraphicLayer>>(){

            @Override
            public int compare(CyCustomGraphics2Factory<?> f1, CyCustomGraphics2Factory<?> f2) {
                return CustomGraphics2ManagerImpl.this.collator.compare(f1.getDisplayName(), f2.getDisplayName());
            }
        };
    }

    public Set<CyCustomGraphics2Factory<? extends CustomGraphicLayer>> getAllCustomGraphics2Factories() {
        Collection<CyCustomGraphics2Factory<? extends CustomGraphicLayer>> allFactories = this.factories.values();
        TreeSet<CyCustomGraphics2Factory<? extends CustomGraphicLayer>> set = new TreeSet<CyCustomGraphics2Factory<? extends CustomGraphicLayer>>(this.factoryComparator);
        set.addAll(allFactories);
        return set;
    }

    @Override
    public Collection<CyCustomGraphics2Factory<? extends CustomGraphicLayer>> getCustomGraphics2Factories(Class<? extends CyIdentifiable> targetType, String group) {
        Set<CyCustomGraphics2Factory<? extends CustomGraphicLayer>> col = null;
        Set<CyCustomGraphics2Factory<? extends CustomGraphicLayer>> set = this.groups.get(group);
        if (set != null) {
            col = new TreeSet<CyCustomGraphics2Factory<? extends CustomGraphicLayer>>(this.factoryComparator);
            for (CyCustomGraphics2Factory<? extends CustomGraphicLayer> f : set) {
                if (!f.getSupportedTargetTypes().contains(targetType)) continue;
                col.add(f);
            }
        }
        return col != null ? col : Collections.emptySet();
    }

    @Override
    public CyCustomGraphics2Factory<? extends CustomGraphicLayer> getCustomGraphics2Factory(String factoryId) {
        return this.factories.get(factoryId);
    }

    @Override
    public CyCustomGraphics2Factory<? extends CustomGraphicLayer> getCustomGraphics2Factory(Class<? extends CyCustomGraphics2<? extends CustomGraphicLayer>> cls) {
        for (CyCustomGraphics2Factory<? extends CustomGraphicLayer> cf : this.factories.values()) {
            if (!cf.getSupportedClass().isAssignableFrom(cls)) continue;
            return cf;
        }
        return null;
    }

    @Override
    public Set<String> getGroups() {
        return this.groups.keySet();
    }

    public void addFactory(CyCustomGraphics2Factory<? extends CustomGraphicLayer> factory, Map<?, ?> props) {
        Set<CyCustomGraphics2Factory<? extends CustomGraphicLayer>> set;
        String group = (String)props.get("group");
        if (group == null) {
            group = "Others";
        }
        if ((set = this.groups.get(group)) == null) {
            set = new HashSet<CyCustomGraphics2Factory<? extends CustomGraphicLayer>>();
            this.groups.put(group, set);
        }
        set.add(factory);
        this.factories.put(factory.getId(), factory);
    }

    public void removeFactory(CyCustomGraphics2Factory<? extends CustomGraphicLayer> factory, Map<?, ?> props) {
        Set<CyCustomGraphics2Factory<? extends CustomGraphicLayer>> set;
        boolean removed;
        this.factories.remove(factory.getId());
        Iterator<Set<CyCustomGraphics2Factory<? extends CustomGraphicLayer>>> iterator = this.groups.values().iterator();
        while (iterator.hasNext() && !(removed = (set = iterator.next()).remove(factory))) {
        }
    }

    public static CustomGraphics2ManagerImpl getInstance() {
        return me;
    }
}

