/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.cytoscape.cg.model.AbstractCustomGraphics2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesJsonDeserializer
extends JsonDeserializer<Map<String, Object>> {
    private final AbstractCustomGraphics2<?> cg2;
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");

    public PropertiesJsonDeserializer(AbstractCustomGraphics2<?> cg2) {
        this.cg2 = cg2;
    }

    public Map<String, Object> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        ObjectMapper mapper = (ObjectMapper)jp.getCodec();
        JsonNode rootNode = (JsonNode)mapper.readTree(jp);
        if (rootNode.isObject()) {
            Iterator fieldNames = rootNode.fieldNames();
            while (fieldNames.hasNext()) {
                String key = (String)fieldNames.next();
                JsonNode jn = rootNode.get(key);
                Object value = PropertiesJsonDeserializer.readValue(key, jn.toString(), mapper, this.cg2);
                props.put(key, value);
            }
        }
        return props;
    }

    public static Object readValue(String key, String input, ObjectMapper mapper, AbstractCustomGraphics2<?> cg2) {
        Object value = null;
        Class<?> type = cg2.getSettingType(key);
        if (type != null) {
            TypeFactory typeFactory = mapper.getTypeFactory();
            try {
                if (type == Array.class) {
                    ArrayType arrType;
                    Class<?> elementType = cg2.getSettingElementType(key);
                    if (elementType != null && mapper.canDeserialize((JavaType)(arrType = typeFactory.constructArrayType(elementType)))) {
                        value = mapper.readValue(input, (JavaType)arrType);
                    }
                } else if (List.class.isAssignableFrom(type)) {
                    CollectionType collType;
                    Class<?> elementType = cg2.getSettingElementType(key);
                    if (elementType != null && mapper.canDeserialize((JavaType)(collType = typeFactory.constructCollectionType(List.class, elementType)))) {
                        value = mapper.readValue(input, (JavaType)collType);
                    }
                } else {
                    JavaType simpleType = typeFactory.constructSimpleType(type, new JavaType[0]);
                    if (mapper.canDeserialize(simpleType)) {
                        value = mapper.readValue(input, simpleType);
                    }
                }
            }
            catch (Exception e) {
                logger.error("Cannot parse JSON field " + key, (Throwable)e);
            }
        }
        return value;
    }
}

