/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.image;

import com.google.common.hash.Hashing;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.cytoscape.application.CyApplicationConfiguration;
import org.cytoscape.cg.internal.image.AbstractURLImageCustomGraphicsFactory;
import org.cytoscape.cg.internal.image.MissingSVGCustomGraphics;
import org.cytoscape.cg.model.CustomGraphicsManager;
import org.cytoscape.cg.model.SVGCustomGraphics;
import org.cytoscape.cg.model.SVGLayer;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.presentation.customgraphics.CyCustomGraphics;

public class SVGCustomGraphicsFactory
extends AbstractURLImageCustomGraphicsFactory<SVGLayer> {
    public static final String SUPPORTED_CLASS_ID = "org.cytoscape.ding.customgraphics.image.SVGCustomGraphics";

    public SVGCustomGraphicsFactory(CustomGraphicsManager manager, CyServiceRegistrar serviceRegistrar) {
        super(manager, serviceRegistrar);
    }

    public boolean supportsMime(String mimeType) {
        return "image/svg+xml".equalsIgnoreCase(mimeType);
    }

    public SVGCustomGraphics getInstance(String input) {
        try {
            URL url = null;
            Object name = null;
            boolean isSVGText = false;
            if (this.isDataURL(input)) {
                int idx = input.indexOf(44);
                if (idx == -1 || idx >= input.length() - 1) {
                    return null;
                }
                input = input.substring(idx + 1, input.length()).trim();
                isSVGText = true;
                String sha = Hashing.sha256().hashString((CharSequence)input, StandardCharsets.UTF_8).toString();
                name = sha + ".svg";
                CyApplicationConfiguration config = (CyApplicationConfiguration)this.serviceRegistrar.getService(CyApplicationConfiguration.class);
                File dir = config.getConfigurationDirectoryLocation();
                File file = new File(dir, (String)name);
                url = file.toURI().toURL();
            } else {
                name = input;
                url = new URL(input);
            }
            CyCustomGraphics cg = this.manager.getCustomGraphicsBySourceURL(url);
            if (!(cg instanceof SVGCustomGraphics)) {
                Long id = this.manager.getNextAvailableID();
                cg = isSVGText ? new SVGCustomGraphics(id, (String)name, url, input) : new SVGCustomGraphics(id, input, url);
                this.manager.addCustomGraphics(cg, url);
            }
            return (SVGCustomGraphics)cg;
        }
        catch (IOException e) {
            return null;
        }
    }

    protected SVGCustomGraphics createMissingImageCustomGraphics(String entryStr, long id, String sourceURL) {
        try {
            MissingSVGCustomGraphics cg = new MissingSVGCustomGraphics(entryStr, id, sourceURL, this);
            this.manager.addMissingImageCustomGraphics(cg);
            return cg;
        }
        catch (IOException e) {
            logger.error("Cannot create MissingSVGCustomGraphics object", (Throwable)e);
            return null;
        }
    }

    public Class<? extends CyCustomGraphics<?>> getSupportedClass() {
        return SVGCustomGraphics.class;
    }

    @Override
    public String getSupportedClassId() {
        return SUPPORTED_CLASS_ID;
    }

    private boolean isDataURL(String s) {
        return s.startsWith("data:image/svg+xml");
    }
}

