/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cg.internal.image;

import com.google.common.hash.Hashing;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import javax.imageio.ImageIO;
import org.cytoscape.application.CyApplicationConfiguration;
import org.cytoscape.cg.internal.image.AbstractURLImageCustomGraphicsFactory;
import org.cytoscape.cg.internal.image.MissingBitmapCustomGraphics;
import org.cytoscape.cg.model.BitmapCustomGraphics;
import org.cytoscape.cg.model.BitmapLayer;
import org.cytoscape.cg.model.CustomGraphicsManager;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.presentation.customgraphics.CyCustomGraphics;

public class BitmapCustomGraphicsFactory
extends AbstractURLImageCustomGraphicsFactory<BitmapLayer> {
    public static final String SUPPORTED_CLASS_ID = "org.cytoscape.ding.customgraphics.bitmap.URLImageCustomGraphics";
    private final List<String> MIME_TYPES = List.of("image/bmp", "image/x-windows-bmp", "image/gif", "image/jpeg", "image/png", "image/vnd.wap.wbmp");

    public BitmapCustomGraphicsFactory(CustomGraphicsManager manager, CyServiceRegistrar serviceRegistrar) {
        super(manager, serviceRegistrar);
    }

    public boolean supportsMime(String mimeType) {
        return this.MIME_TYPES.contains(mimeType);
    }

    public BitmapCustomGraphics getInstance(String input) {
        URL url = null;
        boolean isBase64 = this.isBase64DataURL(input);
        try {
            Object name;
            if (isBase64) {
                CyApplicationConfiguration config = (CyApplicationConfiguration)this.serviceRegistrar.getService(CyApplicationConfiguration.class);
                File dir = config.getConfigurationDirectoryLocation();
                String[] parts = input.split(",");
                if (parts.length < 2 || parts[1].isBlank()) {
                    return null;
                }
                input = parts[1].trim();
                String sha = Hashing.sha256().hashString((CharSequence)input, StandardCharsets.UTF_8).toString();
                String ext = this.getExtensionFromDataURL(input);
                name = sha + "." + ext;
                File file = new File(dir, (String)name);
                url = file.toURI().toURL();
            } else {
                name = input;
                url = new URL(input);
            }
            CyCustomGraphics cg = this.manager.getCustomGraphicsBySourceURL(url);
            if (!(cg instanceof BitmapCustomGraphics)) {
                Long id = this.manager.getNextAvailableID();
                if (isBase64) {
                    Base64.Decoder decoder = Base64.getDecoder();
                    byte[] imgBytes = decoder.decode(input);
                    ByteArrayInputStream bis = new ByteArrayInputStream(imgBytes);
                    BufferedImage img = ImageIO.read(bis);
                    bis.close();
                    cg = new BitmapCustomGraphics(id, (String)name, url, img);
                } else {
                    cg = new BitmapCustomGraphics(id, (String)name, url);
                }
                this.manager.addCustomGraphics(cg, url);
            }
            return (BitmapCustomGraphics)cg;
        }
        catch (IOException e) {
            return null;
        }
    }

    protected BitmapCustomGraphics createMissingImageCustomGraphics(String entryStr, long id, String sourceURL) {
        try {
            MissingBitmapCustomGraphics cg = new MissingBitmapCustomGraphics(entryStr, id, sourceURL, this);
            this.manager.addMissingImageCustomGraphics(cg);
            return cg;
        }
        catch (IOException e) {
            logger.error("Cannot create MissingBitmapCustomGraphics object", (Throwable)e);
            return null;
        }
    }

    public Class<? extends CyCustomGraphics<?>> getSupportedClass() {
        return BitmapCustomGraphics.class;
    }

    @Override
    public String getSupportedClassId() {
        return SUPPORTED_CLASS_ID;
    }

    private String getExtensionFromDataURL(String s) {
        String[] parts = s.split(",");
        switch (parts[0]) {
            case "data:image/gif;base64": {
                return "gif";
            }
            case "data:image/bmp;base64": {
                return "bmp";
            }
            case "data:image/png;base64": {
                return "png";
            }
        }
        return "jpg";
    }

    private boolean isBase64DataURL(String s) {
        return s.startsWith("data:") && s.contains(";base64,");
    }
}

